<?php 
/*
Template Name: Contact Page
*/ 

get_header();

$infographer_options = infographer_qode_return_global_options();

$hide_contact_form_website = "";
if ( isset( $infographer_options['hide_contact_form_website'] ) ) {
	$hide_contact_form_website = $infographer_options['hide_contact_form_website'];
}
?>
<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
	<?php get_template_part( 'title' ); ?>
	
	<?php if ( $infographer_options['enable_google_map'] == "yes" ) { ?>
		<div class="google_map" id="map_canvas">
			<?php echo infographer_qode_get_module_part( $infographer_options['google_maps_iframe'] ); ?>
		</div>
	<?php } ?>
	<div class="container" <?php infographer_qode_inline_page_background_style(); ?>>
		<div class="container_inner clearfix">
			<div class="contact_detail">
			<?php if($infographer_options['enable_contact_form'] == "yes"){ ?>	
				<div class="two_columns_66_33 clearfix">
					<div class="column1">
						<div class="column_inner">
							<div class="contact_form">
								<h2><?php if($infographer_options['contact_heading_above'] != "") { echo wp_kses_post($infographer_options['contact_heading_above']);  } else { ?><?php esc_attr_e('CONTACT US', 'infographer'); ?><?php } ?></h2>
								<?php if($infographer_options['contact_text_above'] != "") { ?>
									<p class="form-text-above"><?php echo wp_kses_post($infographer_options['contact_text_above']); ?></p>
								<?php } ?>
								<form id="contact-form" method="post" action="">
									<div class="clearfix">
										<div class="two_columns_50_50 clearfix">
											<div class="column1">
												<div class="column_inner">
													<input type="text" class="requiredField" name="fname" id="fname" value="" placeholder="<?php esc_attr_e('First Name *', 'infographer'); ?>" />
													<?php if ($hide_contact_form_website != "yes") { ?>
														<input type="text" class="requiredField email" name="email" id="email" value="" placeholder="<?php esc_attr_e('Email *', 'infographer'); ?>" />
													<?php } ?>
												</div>
											</div>
											<div class="column2">
												<div class="column_inner">
													<input type="text" class="requiredField" name="lname" id="lname" value="" placeholder="<?php esc_attr_e('Last Name *', 'infographer'); ?>" />
													<?php if ($hide_contact_form_website == "yes") { ?>
														<input type="hidden" name="website" id="website" value="" />
													<?php } else { ?>
														<input type="text" name="website" id="website" value="" placeholder="<?php esc_attr_e('Web site', 'infographer'); ?>" />
													<?php }?>
												</div>
											</div>
										</div>
									<?php if ($hide_contact_form_website == "yes") { ?>
										<input type="text" class="requiredField email" name="email" id="email" value="" placeholder="<?php esc_attr_e('Email *', 'infographer'); ?>" />
									<?php } ?>
									<textarea name="message" id="message" rows="10" placeholder="<?php esc_attr_e('Message', 'infographer'); ?>"></textarea>
									
									<?php
									if($infographer_options['use_recaptcha'] == "yes" && infographer_qode_is_core_installed()) :
										require_once INFOGRAPHER_CORE_MODULES_PATH . '/recaptchalib.php';
											if($infographer_options['recaptcha_public_key']) {
												$publickey = $infographer_options['recaptcha_public_key'];
											} else {
												$publickey = "6Lf1CeMSAAAAANl7S5nZt8XnLq0sJ9IthPYXeYi3";
											}
											if($infographer_options['recaptcha_private_key']) {
												$privatekey = $infographer_options['recaptcha_private_key'];
											} else {
												$privatekey = "6Lf1CeMSAAAAAOaiM7K_WhPnaf0L1b2cGRen-wBx";
											}

											if($infographer_options['page_transitions'] != ""){ ?>
												<script type="text/javascript">
													var RecaptchaOptions = {theme: 'clean'};
													Recaptcha.create("<?php echo esc_attr($publickey); ?>","captchaHolder",{theme: "clean",callback: Recaptcha.focus_response_field});
												</script>
											<?php } ?>
											<p id="captchaHolder"><?php echo recaptcha_get_html($publickey); ?></p>
											<p id="captchaStatus">&nbsp;</p>
									<?php endif; ?>
									
									<span class="submit_button">
										<input class="button small" type="submit" value="<?php esc_attr_e('CONTACT US', 'infographer'); ?>" />
									</span>
								</div>
								</form>	
							</div>
						</div>
					</div>
					<div class="column2">
						<div class="column_inner">
							<?php the_content(); ?>
						</div>
					</div>
				</div>	
				<?php }else{ ?>
						<?php the_content(); ?>
					<?php } ?>
				<div class="separator transparent"></div>
				
			</div>	
		</div>
	</div>					
<?php endwhile; ?>
<?php endif; ?>
<script type="text/javascript">
	jQuery(document).ready(function ($) {
		"use strict";
		
		$j('form#contact-form').submit(function () {
			$j('form#contact-form .contact-error').remove();
			var hasError = false;
			$j('form#contact-form .requiredField').each(function () {
				if (jQuery.trim($j(this).val()) === '') {
					var labelText = $j(this).prev('label').text();
					$j(this).parent().append('<strong class="contact-error"><?php esc_html_e( ' Required', 'infographer' ); ?></strong>');
					$j(this).addClass('inputError');
					hasError = true;
				} else {
					if ($j(this).hasClass('email')) {
						var emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
						if (!emailReg.test(jQuery.trim($j(this).val()))) {
							var labelText = $j(this).prev('label').text();
							$j(this).parent().append('<strong class="contact-error"><?php esc_html_e( ' Invalid', 'infographer' ); ?></strong>');
							$j(this).addClass('inputError');
							hasError = true;
						}
					}
				}
			});
			
			if (!hasError) {
				var challengeField = $j("input#recaptcha_challenge_field").val();
				var responseField = $j("input#recaptcha_response_field").val();
				var name = $j("input#fname").val();
				var lname = $j("input#lname").val();
				var email = $j("input#email").val();
				var website = $j("input#website").val();
				var message = $j("textarea#message").val();
				
				var html = $j.ajax({
					type: "POST",
					url: "<?php echo infographer_qode_is_core_installed() ? INFOGRAPHER_CORE_MODULES_URL_PATH . '/ajax_mail.php' : '' ?>",
					data: "recaptcha_challenge_field=" + challengeField + "&recaptcha_response_field=" + responseField + "&name=" + name + "&lname=" + lname + "&email=" + email + "&website=" + website + "&message=" + message,
					async: false
				}).responseText;
				
				if (html === "success") {
					var formInput = $j(this).serialize();
					
					$j("form#contact-form").before('<div class="contact-success"><strong><?php esc_html_e( 'THANK YOU!', 'infographer' ); ?></strong><p><?php esc_html_e( 'Your email was successfully sent. We will contact you as soon as possible.', 'infographer' ); ?></p></div>');
					
					$j.post($j(this).attr('action'), formInput);
					hasError = false;
					return false;
				} else {
					<?php if ($infographer_options['use_recaptcha'] == "yes") { ?>
						$j("#recaptcha_response_field").parent().append('<span class="contact-error extra-padding"><?php esc_html_e( 'Invalid Captcha', 'infographer' ); ?></span>');
						Recaptcha.reload();
					<?php } else { ?>
						$j("form#contact-form").before('<div class="contact-success"><strong><?php esc_html_e( "Email server problem", 'infographer' ); ?></strong></p></div>');
					<?php } ?>
					
					return false;
				}
			}
			return false;
		});
	});
</script>
<?php get_footer(); ?>