<?php
include_once get_template_directory() . '/theme-includes.php';

if ( ! function_exists( 'infographer_qode_rewrite_rules_on_theme_activation' ) ) {
	function infographer_qode_rewrite_rules_on_theme_activation() {
		flush_rewrite_rules();
	}
	
	add_action( 'after_switch_theme', 'infographer_qode_rewrite_rules_on_theme_activation' );
}

if ( ! function_exists( 'infographer_qode_add_theme_support' ) ) {
	function infographer_qode_add_theme_support() {
		//add support for feed links
		add_theme_support( 'automatic-feed-links' );
		
		//add theme support for post thumbnails
		add_theme_support( 'post-thumbnails' );
		
		//add theme support for title tag
		add_theme_support( 'title-tag' );
		
		//defined content width variable
		$GLOBALS['content_width'] = 940;
		
		load_theme_textdomain( 'infographer', get_template_directory() . '/languages' );
		
		//add theme support for editor style
		add_editor_style( 'css/admin/editor-style.css' );
		
		add_image_size( 'infographer-blog-type-1', 388, 263, true );
		add_image_size( 'infographer-blog-type-2', 1102, 412, true );
		add_image_size( 'infographer-blog-type-3', 490, 256, true );
		add_image_size( 'infographer-latest-posts', 503, 283, true );
		
		register_nav_menus(
			array(
				'top-navigation' => esc_html__( 'Top Navigation', 'infographer' )
			)
		);
	}
	
	add_action( 'after_setup_theme', 'infographer_qode_add_theme_support' );
}

if ( ! function_exists( 'infographer_qode_styles' ) ) {
	function infographer_qode_styles() {
		global $wp_styles;
		$global_options = infographer_qode_return_global_options();
		
		wp_enqueue_style( "infographer-default-style", QODE_ROOT . "/style.css" );
		wp_enqueue_style( "infographer-stylesheet", QODE_CSS_ROOT . "/stylesheet.min.css" );
		
		wp_enqueue_style( 'infographer-ie8-style', QODE_CSS_ROOT . '/ie8.min.css' );
		$wp_styles->add_data( 'infographer-ie8-style', 'conditional', 'IE 8' );
		
		wp_enqueue_style( 'infographer-ie9-style', QODE_CSS_ROOT . '/ie9.min.css' );
		$wp_styles->add_data( 'infographer-ie9-style', 'conditional', 'IE 9' );
		
		if ( file_exists( QODE_CSS_ROOT_DIR . '/style_dynamic.css' ) && infographer_qode_is_css_folder_writable() && ! is_multisite() ) {
			wp_enqueue_style( 'infographer-style-dynamic', QODE_CSS_ROOT . '/style_dynamic.css', array(), filemtime( QODE_CSS_ROOT_DIR . '/style_dynamic.css' ) );
		} else if ( file_exists( QODE_CSS_ROOT_DIR . '/style_dynamic_ms_id_' . infographer_qode_get_multisite_blog_id() . '.css' ) && infographer_qode_is_css_folder_writable() && is_multisite() ) {
			wp_enqueue_style( 'infographer-style-dynamic', QODE_CSS_ROOT . '/style_dynamic_ms_id_' . infographer_qode_get_multisite_blog_id() . '.css', array(), filemtime( QODE_CSS_ROOT_DIR . '/style_dynamic_ms_id_' . infographer_qode_get_multisite_blog_id() . '.css' ) );
		} else {
			wp_enqueue_style( 'infographer-style-dynamic', QODE_CSS_ROOT . '/style_dynamic_callback.php' ); // Temporary case for Major update
		}
		
		$responsiveness = "yes";
		if ( isset( $global_options['responsiveness'] ) ) {
			$responsiveness = $global_options['responsiveness'];
		}
		
		if ( $responsiveness != "no" ):
			wp_enqueue_style( "infographer-responsive", QODE_CSS_ROOT . "/responsive.min.css" );
			
			//include proper styles
			if ( file_exists( QODE_CSS_ROOT_DIR . '/style_dynamic_responsive.css' ) && infographer_qode_is_css_folder_writable() && ! is_multisite() ) {
				wp_enqueue_style( 'infographer-style-dynamic-responsive', QODE_CSS_ROOT . '/style_dynamic_responsive.css', array(), filemtime( QODE_CSS_ROOT_DIR . '/style_dynamic_responsive.css' ) );
			} else if ( file_exists( QODE_CSS_ROOT_DIR . '/style_dynamic_responsive_ms_id_' . infographer_qode_get_multisite_blog_id() . '.css' ) && infographer_qode_is_css_folder_writable() && is_multisite() ) {
				wp_enqueue_style( 'infographer-style-dynamic-responsive', QODE_CSS_ROOT . '/style_dynamic_responsive_ms_id_' . infographer_qode_get_multisite_blog_id() . '.css', array(), filemtime( QODE_CSS_ROOT_DIR . '/style_dynamic_responsive_ms_id_' . infographer_qode_get_multisite_blog_id() . '.css' ) );
			} else {
				wp_enqueue_style( 'infographer-style-dynamic-responsive', QODE_CSS_ROOT . '/style_dynamic_responsive_callback.php' ); // Temporary case for Major update
			}
		endif;
		
		if( infographer_qode_return_toolbar_variable() ){
			wp_enqueue_style( "infographer-toolbar", QODE_CSS_ROOT . "/toolbar.css" );
		}
		
		$custom_css = $global_options['custom_css'];
		
		if ( ! empty( $custom_css ) ) {
			if ( $responsiveness != "no" ) {
				wp_add_inline_style( 'infographer-style-dynamic-responsive', $custom_css );
			} else {
				wp_add_inline_style( 'infographer-style-dynamic', $custom_css );
			}
		}
		
		$font_weight_str = '200,300,400,500,600,700,800';
		$font_subset_str = 'latin,latin-ext';
		
		//default fonts
		$default_font_family = array(
			'Open Sans',
			'Oswald'
		);
		
		$modified_default_font_family = array();
		foreach ( $default_font_family as $default_font ) {
			$modified_default_font_family[] = $default_font . ':' . str_replace( ' ', '', $font_weight_str );
		}
		
		$default_font_string = implode( '|', $modified_default_font_family );
		
		$available_font_options = array_filter( array(
			$global_options['google_fonts'],
			$global_options['button_title_google_fonts'],
			$global_options['message_title_google_fonts'],
			$global_options['page_title_google_fonts'],
			$global_options['h1_google_fonts'],
			$global_options['h2_google_fonts'],
			$global_options['h3_google_fonts'],
			$global_options['h4_google_fonts'],
			$global_options['h5_google_fonts'],
			$global_options['h6_google_fonts'],
			$global_options['text_google_fonts'],
			$global_options['menu_google_fonts'],
			$global_options['dropdown_google_fonts'],
			$global_options['dropdown_google_fonts_thirdlvl'],
			$global_options['content_menu_google_fonts']
		) );
		
		//define available font options array
		$fonts_array = array();
		if ( ! empty( $available_font_options ) ) {
			foreach ( $available_font_options as $font_option_value ) {
				$font_option_string = $font_option_value . ':' . $font_weight_str;
				
				if ( ! in_array( str_replace( '+', ' ', $font_option_value ), $default_font_family ) && ! in_array( $font_option_string, $fonts_array ) ) {
					$fonts_array[] = $font_option_string;
				}
			}
			
			$fonts_array = array_diff( $fonts_array, array( '-1:' . $font_weight_str ) );
		}
		
		$google_fonts_string = implode( '|', $fonts_array );
		
		$protocol = is_ssl() ? 'https:' : 'http:';
		
		//is google font option checked anywhere in theme?
		if ( count( $fonts_array ) > 0 ) {
			
			//include all checked fonts
			$fonts_full_list      = $default_font_string . '|' . str_replace( '+', ' ', $google_fonts_string );
			$fonts_full_list_args = array(
				'family' => urlencode( $fonts_full_list ),
				'subset' => urlencode( $font_subset_str ),
			);
			
			$infographer_global_fonts = add_query_arg( $fonts_full_list_args, $protocol . '//fonts.googleapis.com/css' );
			wp_enqueue_style( 'infographer-google-fonts', esc_url_raw( $infographer_global_fonts ), array(), '1.0.0' );
			
		} else {
			//include default google font that theme is using
			$default_fonts_args          = array(
				'family' => urlencode( $default_font_string ),
				'subset' => urlencode( $font_subset_str ),
			);
			$infographer_global_fonts = add_query_arg( $default_fonts_args, $protocol . '//fonts.googleapis.com/css' );
			wp_enqueue_style( 'infographer-google-fonts', esc_url_raw( $infographer_global_fonts ), array(), '1.0.0' );
		}
	}
	
	add_action( 'wp_enqueue_scripts', 'infographer_qode_styles' );
}

if ( ! function_exists( 'infographer_qode_scripts' ) ) {
	function infographer_qode_scripts() {
		$global_options = infographer_qode_return_global_options();
		global $is_IE;

		//init theme core scripts
		wp_enqueue_script( 'jquery-ui-core' );
		wp_enqueue_script( 'jquery-ui-widget' );
		wp_enqueue_script( 'jquery-ui-mouse' );
		wp_enqueue_script( 'jquery-ui-draggable' );
		wp_enqueue_script( 'jquery-ui-droppable' );
		wp_enqueue_script( 'jquery-ui-resizable' );
		wp_enqueue_script( 'jquery-ui-selectable' );
		wp_enqueue_script( 'jquery-ui-sortable' );
		wp_enqueue_script( 'jquery-ui-accordion' );
		wp_enqueue_script( 'jquery-ui-autocomplete' );
		wp_enqueue_script( 'jquery-ui-button' );
		wp_enqueue_script( 'jquery-ui-datepicker' );
		wp_enqueue_script( 'jquery-ui-dialog' );
		wp_enqueue_script( 'jquery-effects-core' );
		wp_enqueue_script( 'jquery-effects-blind' );
		wp_enqueue_script( 'jquery-effects-bounce' );
		wp_enqueue_script( 'jquery-effects-clip' );
		wp_enqueue_script( 'jquery-effects-drop' );
		wp_enqueue_script( 'jquery-effects-explode' );
		wp_enqueue_script( 'jquery-effects-fade' );
		wp_enqueue_script( 'jquery-effects-fold' );
		wp_enqueue_script( 'jquery-effects-highlight' );
		wp_enqueue_script( 'jquery-effects-pulsate' );
		wp_enqueue_script( 'jquery-effects-scale' );
		wp_enqueue_script( 'jquery-effects-shake' );
		wp_enqueue_script( 'jquery-effects-slide' );
		wp_enqueue_script( 'jquery-effects-transfer' );
		wp_enqueue_script( 'jquery-ui-menu' );
		wp_enqueue_script( 'jquery-ui-position' );
		wp_enqueue_script( 'jquery-ui-progressbar' );
		wp_enqueue_script( 'jquery-ui-slider' );
		wp_enqueue_script( 'jquery-ui-spinner' );
		wp_enqueue_script( 'jquery-ui-tabs' );
		wp_enqueue_script( 'jquery-ui-tooltip' );
		wp_enqueue_script( 'jquery-form' );

		wp_enqueue_script('waypoints', QODE_JS_ROOT . '/plugins/waypoints.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script('absoluteCounter', QODE_JS_ROOT . '/plugins/absoluteCounter.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script("doubletaptogo", QODE_JS_ROOT . "/plugins/doubletaptogo.js",array('jquery'),false,true);
		wp_enqueue_script('appear', QODE_JS_ROOT . "/plugins/jquery.appear.js",array('jquery'),false,true);
		wp_enqueue_script( 'jquery-easing-1.3', QODE_JS_ROOT . '/plugins/jquery.easing.1.3.js',array( 'jquery' ),false,true );
		wp_enqueue_script( 'easypiechart', QODE_JS_ROOT . '/plugins/jquery.easy-pie-chart.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'fitvids', QODE_JS_ROOT . '/plugins/jquery.fitvids.js',array( 'jquery' ),false,true );
		wp_enqueue_script( 'flexslider', QODE_JS_ROOT . '/plugins/jquery.flexslider-min.js',array( 'jquery' ),false,true );
		wp_enqueue_script( 'mixitup', QODE_JS_ROOT . '/plugins/jquery.mixitup.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'waitforimages', QODE_JS_ROOT . '/plugins/jquery.waitforimages.js',array( 'jquery' ),false,true );
		wp_enqueue_script( 'modernizr', QODE_JS_ROOT . '/plugins/modernizr.min.js',array( 'jquery' ),false,true );
		wp_enqueue_script( 'prettyphoto', QODE_JS_ROOT . '/plugins/prettyPhoto.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'chartjs', QODE_JS_ROOT . '/plugins/Chart.min.js', array( 'jquery' ), false, true );

		
		if ( $is_IE ) {
			wp_enqueue_script( "html5", QODE_JS_ROOT . "/plugins/html5.js", array('jquery'), false, false );
		}
		
		if ( $global_options['enable_google_map'] == "yes" ) :
			if ( isset( $global_options['google_maps_api_key'] ) && $global_options['google_maps_api_key'] != '' ) {
				$google_maps_api_key = $global_options['google_maps_api_key'];
				wp_enqueue_script( "infographer-google-map-api", "https://maps.googleapis.com/maps/api/js?key=" . esc_attr( $google_maps_api_key ), array(), false, true );
			}
		endif;
		
		if ( file_exists( QODE_JS_ROOT_DIR . '/default_dynamic.js' ) && infographer_qode_is_js_folder_writable() && ! is_multisite() ) {
			wp_enqueue_script( 'infographer-default-dynamic', QODE_JS_ROOT . '/default_dynamic.js', array('jquery'), filemtime( QODE_JS_ROOT_DIR . '/default_dynamic.js' ), true );
		} else if ( file_exists( QODE_JS_ROOT_DIR . '/default_dynamic_ms_id_' . infographer_qode_get_multisite_blog_id() . '.js' ) && infographer_qode_is_js_folder_writable() && is_multisite() ) {
			wp_enqueue_script( 'infographer-default-dynamic', QODE_JS_ROOT . '/default_dynamic_ms_id_' . infographer_qode_get_multisite_blog_id() . '.js', array('jquery'), filemtime( QODE_JS_ROOT_DIR . '/default_dynamic_ms_id_' . infographer_qode_get_multisite_blog_id() . '.js' ), true );
		} else {
			wp_enqueue_script( 'infographer-default-dynamic', QODE_JS_ROOT . '/default_dynamic_callback.php', array('jquery'), false, true ); // Temporary case for Major update
		}
		
		wp_enqueue_script( "infographer-default", QODE_JS_ROOT . "/default.min.js", array('jquery'), false, true );
		
		$custom_js = $global_options['custom_js'];
		if ( ! empty( $custom_js ) ) {
			wp_add_inline_script( 'infographer-default', $custom_js );
		}
		
		global $wp_scripts;
		$wp_scripts->add_data( 'comment-reply', 'group', 1 );
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( "comment-reply" );
		}
		
		$has_ajax       = false;
		$qode_animation = "";
		if ( isset( $_SESSION['qode_animation'] ) ) {
			$qode_animation = $_SESSION['qode_animation'];
		}
		if ( ( $global_options['page_transitions'] != "0" ) && ( empty( $qode_animation ) || ( $qode_animation != "no" ) ) ) {
			$has_ajax = true;
		} elseif ( ! empty( $qode_animation ) && ( $qode_animation != "no" ) ) {
			$has_ajax = true;
		}
		
		if ( $has_ajax ) :
			wp_enqueue_script( "infographer-ajax", QODE_JS_ROOT . "/ajax.min.js", array('jquery'), false, true );
		endif;
		
		if ( $global_options['use_recaptcha'] == "yes" ) :
			wp_enqueue_script( "recaptcha-ajax", "https://www.google.com/recaptcha/api/js/recaptcha_ajax.js", array('jquery'), false, true );
		endif;
		
		if ( infographer_qode_return_toolbar_variable() ) {
			wp_enqueue_script( "infographer-toolbar", QODE_JS_ROOT . "/toolbar.js", array('jquery'), false, true );
		}
	}
	
	add_action('wp_enqueue_scripts', 'infographer_qode_scripts');
}

if ( ! function_exists( 'infographer_qode_admin_jquery' ) ) {
	function infographer_qode_admin_jquery() {
		wp_enqueue_script( 'jquery-ui-datepicker' );
		wp_enqueue_script( 'jquery-ui-accordion' );
		wp_enqueue_style( 'infographer-admin-style', QODE_CSS_ROOT . '/admin/admin-style.css', false, '1.0', 'screen' );
		wp_enqueue_style( 'infographer-admin-colorstyle', QODE_CSS_ROOT . '/admin/admin-colorpicker.css', false, '1.0', 'screen' );
		wp_enqueue_script( 'color-picker', QODE_JS_ROOT . '/admin/colorpicker.js', array( 'jquery' ), '1.0.0', false );
		wp_enqueue_style( 'thickbox' );
		wp_enqueue_script( 'thickbox' );
		wp_enqueue_script( 'infographer-admin-default', QODE_JS_ROOT . '/admin/default.js', array( 'jquery' ), '1.0.0', false );
		wp_enqueue_script( 'common' );
		wp_enqueue_script( 'wp-lists' );
		wp_enqueue_script( 'postbox' );
		wp_enqueue_media();
	}
	
	add_action( 'admin_enqueue_scripts', 'infographer_qode_admin_jquery' );
}

if ( ! function_exists( 'infographer_qode_enqueue_editor_customizer_styles' ) ) {
	/**
	 * Enqueue supplemental block editor styles
	 */
	function infographer_qode_enqueue_editor_customizer_styles() {
		$protocol = is_ssl() ? 'https:' : 'http:';
		//include default google font that theme is using
		$default_fonts_args          = array(
			'family' => urlencode( 'Open Sans:300,400,600,700' ),
			'subset' => urlencode( 'latin-ext' ),
		);
		$infographer_global_fonts = add_query_arg( $default_fonts_args, $protocol . '//fonts.googleapis.com/css' );
		wp_enqueue_style( 'infographer-editor-google-fonts', esc_url_raw( $infographer_global_fonts ) );
		
		wp_enqueue_style( 'infographer-editor-customizer-style', QODE_CSS_ROOT . '/admin/editor-customizer-style.css' );
		wp_enqueue_style( 'infographer-editor-blocks-style', QODE_CSS_ROOT . '/admin/editor-blocks-style.css' );
	}
	
	add_action( 'enqueue_block_editor_assets', 'infographer_qode_enqueue_editor_customizer_styles' );
}

if ( ! function_exists( 'infographer_qode_get_page_id' ) ) {
	/**
	 * Function that returns current page / post id.
	 * Checks if current page is any archive page (category, tag, date, author etc.) and returns -1 because that isn't
	 * page that is created in WP admin.
	 *
	 * @return int
	 */
	function infographer_qode_get_page_id() {
		
		if ( is_archive() || is_search() || is_404() || ( is_front_page() && is_home() ) ) {
			return - 1;
		}
		
		return get_queried_object_id();
	}
}

if ( ! function_exists( 'infographer_qode_user_scalable_meta' ) ) {
	/**
	 * Function that outputs user scalable meta if responsiveness is turned on
	 * Hooked to infographer_qode_action_header_meta action
	 */
	function infographer_qode_user_scalable_meta() {
		$global_options = infographer_qode_return_global_options();
		
		//is responsiveness option is chosen?
		if ( isset( $global_options['responsiveness'] ) && $global_options['responsiveness'] !== 'no' ) { ?>
			<meta name=viewport content="width=device-width,initial-scale=1,user-scalable=no">
		<?php } else { ?>
			<meta name=viewport content="width=1200,user-scalable=no">
		<?php }
	}
	
	add_action( 'infographer_qode_action_header_meta', 'infographer_qode_user_scalable_meta' );
}

if ( ! function_exists( 'infographer_qode_excerpt_more' ) ) {
	function infographer_qode_excerpt_more( $more ) {
		return '...';
	}
	
	add_filter( 'excerpt_more', 'infographer_qode_excerpt_more' );
}

if ( ! function_exists( 'infographer_qode_excerpt_length' ) ) {
	function infographer_qode_excerpt_length( $length ) {
		$global_options = infographer_qode_return_global_options();
		
		if ( $global_options['number_of_chars'] ) {
			return $global_options['number_of_chars'];
		} else {
			return 45;
		}
	}
	
	add_filter( 'excerpt_length', 'infographer_qode_excerpt_length', 999 );
}

if ( ! function_exists( 'infographer_qode_the_excerpt_max_charlength' ) ) {
	function infographer_qode_the_excerpt_max_charlength( $charlength ) {
		$global_options = infographer_qode_return_global_options();
		
		$via        = isset( $global_options['twitter_via'] ) && $global_options['twitter_via'] !== '' ? $global_options['twitter_via'] : '';
		$excerpt    = get_the_excerpt();
		$charlength = 136 - ( mb_strlen( $via ) + $charlength );
		
		if ( mb_strlen( $excerpt ) > $charlength ) {
			$subex   = mb_substr( $excerpt, 0, $charlength - 5 );
			$exwords = explode( ' ', $subex );
			$excut   = - ( mb_strlen( $exwords[ count( $exwords ) - 1 ] ) );
			
			if ( $excut < 0 ) {
				return mb_substr( $subex, 0, $excut );
			} else {
				return $subex;
			}
		} else {
			return $excerpt;
		}
	}
}

if ( ! function_exists( 'infographer_qode_excerpt' ) ) {
	/**
	 * Function that cuts post excerpt to the number of word based on previosly set global
	 * variable $word_count, which is defined in infographer_qode_set_blog_word_count function
	 */
	function infographer_qode_excerpt() {
		$global_options = infographer_qode_return_global_options();
		global $word_count, $post;
		
		if ( post_password_required() ) {
			echo get_the_password_form();
		} else {
			$word_count    = isset( $word_count ) && $word_count != "" ? $word_count : $global_options['number_of_chars'];
			$post_excerpt = $post->post_excerpt !== '' ? $post->post_excerpt : strip_tags( strip_shortcodes( $post->post_content ) );
			$clean_excerpt = strlen( $post_excerpt ) && strpos( $post_excerpt, '...' ) ? strstr( $post_excerpt, '...', true ) : $post_excerpt;
			
			if ( $clean_excerpt !== '' ) {
				$excerpt_word_array = explode( ' ', $clean_excerpt );
				$excerpt_word_array = array_slice( $excerpt_word_array, 0, $word_count );
				$excerpt            = implode( ' ', $excerpt_word_array ) . '...';
				
				echo '<p>' . wp_kses_post( $excerpt ) . '</p>';
			}
		}
	}
}

if ( ! function_exists( 'infographer_qode_shortcode_empty_paragraph_fix' ) ) {
	function infographer_qode_shortcode_empty_paragraph_fix( $content ) {
		$array = array(
			'<p>['    => '[',
			']</p>'   => ']',
			']<br />' => ']'
		);
		
		$content = strtr( $content, $array );
		
		return $content;
	}
	
	add_filter( 'the_content', 'infographer_qode_shortcode_empty_paragraph_fix' );
}

/**
 * Include the TGM_Plugin_Activation class.
 */
require_once QODE_INCLUDES_ROOT_DIR . '/class-tgm-plugin-activation.php';

if ( ! function_exists( 'infographer_qode_register_required_plugins' ) ) {
	/**
	 * Register the required plugins for this theme.
	 *
	 * In this example, we register two plugins - one included with the TGMPA library
	 * and one from the .org repo.
	 *
	 * The variable passed to tgmpa_register_plugins() should be an array of plugin
	 * arrays.
	 *
	 * This function is hooked into tgmpa_init, which is fired within the
	 * TGM_Plugin_Activation class constructor.
	 */
	function infographer_qode_register_required_plugins() {
		
		/**
		 * Array of plugin arrays. Required keys are name and slug.
		 * If the source is NOT from the .org repo, then source is also required.
		 */
		$plugins = array(
			
			// This is an example of how to include a plugin pre-packaged with a theme
			array(
				'name'               => esc_html__( 'Infographer Core', 'infographer' ),
				'slug'               => 'infographer-core',
				'source'             => get_template_directory() . '/plugins/infographer-core.zip',
				'version'            => '1.0.3',
				'required'           => true,
				'force_activation'   => false,
				'force_deactivation' => false
			),
			array(
				'name'               => esc_html__( 'Revolution Slider', 'infographer' ),
				'slug'               => 'revslider',
				'source'             => get_template_directory() . '/plugins/revslider.zip',
				'version'            => '6.2.23',
				'required'           => true,
				'force_activation'   => false,
				'force_deactivation' => false
			),
			array(
				'name'     => esc_html__( 'Envato Market', 'infographer' ),
				'slug'     => 'envato-market',
				'source'   => 'https://envato.github.io/wp-envato-market/dist/envato-market.zip',
				'required' => false
			)
		);
		
		/**
		 * Array of configuration settings. Amend each line as needed.
		 * If you want the default strings to be available under your own theme domain,
		 * leave the strings uncommented.
		 * Some of the strings are added into a sprintf, so see the comments at the
		 * end of each line for what each argument will be.
		 */
		$config = array(
			'domain'       => 'infographer',
			'default_path' => '',
			'parent_slug'  => 'themes.php',
			'capability'   => 'edit_theme_options',
			'menu'         => 'install-required-plugins',
			'has_notices'  => true,
			'is_automatic' => false,
			'message'      => '',
			'strings'      => array(
				'page_title'                      => esc_html__( 'Install Required Plugins', 'infographer' ),
				'menu_title'                      => esc_html__( 'Install Plugins', 'infographer' ),
				'installing'                      => esc_html__( 'Installing Plugin: %s', 'infographer' ),
				'oops'                            => esc_html__( 'Something went wrong with the plugin API.', 'infographer' ),
				'notice_can_install_required'     => _n_noop( 'This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.', 'infographer' ),
				'notice_can_install_recommended'  => _n_noop( 'This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.', 'infographer' ),
				'notice_cannot_install'           => _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.', 'infographer' ),
				'notice_can_activate_required'    => _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.', 'infographer' ),
				'notice_can_activate_recommended' => _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.', 'infographer' ),
				'notice_cannot_activate'          => _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.', 'infographer' ),
				'notice_ask_to_update'            => _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.', 'infographer' ),
				'notice_cannot_update'            => _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.', 'infographer' ),
				'install_link'                    => _n_noop( 'Begin installing plugin', 'Begin installing plugins', 'infographer' ),
				'activate_link'                   => _n_noop( 'Activate installed plugin', 'Activate installed plugins', 'infographer' ),
				'return'                          => esc_html__( 'Return to Required Plugins Installer', 'infographer' ),
				'plugin_activated'                => esc_html__( 'Plugin activated successfully.', 'infographer' ),
				'complete'                        => esc_html__( 'All plugins installed and activated successfully. %s', 'infographer' ),
				'nag_type'                        => 'updated'
			)
		);
		
		tgmpa( $plugins, $config );
	}
	
	add_action( 'tgmpa_register', 'infographer_qode_register_required_plugins' );
}

if ( ! function_exists( 'infographer_qode_compare_portfolio_images' ) ) {
	function infographer_qode_compare_portfolio_images( $a, $b ) {
		if ( isset( $a['portfolioimgordernumber'] ) && isset( $b['portfolioimgordernumber'] ) ) {
			if ( $a['portfolioimgordernumber'] == $b['portfolioimgordernumber'] ) {
				return 0;
			}
			
			return ( $a['portfolioimgordernumber'] < $b['portfolioimgordernumber'] ) ? - 1 : 1;
		}
		
		return 0;
	}
}

if ( ! function_exists( 'infographer_qode_compare_portfolio_options' ) ) {
	function infographer_qode_compare_portfolio_options( $a, $b ) {
		if ( isset( $a['optionlabelordernumber'] ) && isset( $b['optionlabelordernumber'] ) ) {
			if ( $a['optionlabelordernumber'] == $b['optionlabelordernumber'] ) {
				return 0;
			}
			
			return ( $a['optionlabelordernumber'] < $b['optionlabelordernumber'] ) ? - 1 : 1;
		}
		
		return 0;
	}
}

if ( ! function_exists( 'infographer_qode_hex2rgb' ) ) {
	function infographer_qode_hex2rgb( $hex ) {
		$hex = str_replace( "#", "", $hex );
		
		if ( strlen( $hex ) == 3 ) {
			$r = hexdec( substr( $hex, 0, 1 ) . substr( $hex, 0, 1 ) );
			$g = hexdec( substr( $hex, 1, 1 ) . substr( $hex, 1, 1 ) );
			$b = hexdec( substr( $hex, 2, 1 ) . substr( $hex, 2, 1 ) );
		} else {
			$r = hexdec( substr( $hex, 0, 2 ) );
			$g = hexdec( substr( $hex, 2, 2 ) );
			$b = hexdec( substr( $hex, 4, 2 ) );
		}
		$rgb = array( $r, $g, $b );
		
		return $rgb; // returns an array with the rgb values
	}
}

if ( ! function_exists( 'infographer_qode_register_sidebars' ) ) {
	function infographer_qode_register_sidebars() {
		register_sidebar( array(
			'name'          => esc_html__( 'Default Sidebar', 'infographer' ),
			'id'            => 'sidebar',
			'description'   => esc_html__( 'Default Sidebar area. In order to display this area you need to enable sidebar layout through global theme options or on page meta box options.', 'infographer' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s posts_holder">',
			'after_widget'  => '</div>',
			'before_title' => '<h5>',
			'after_title' => '</h5>'
		) );
		
		register_sidebar( array(
			'name'          => esc_html__( 'Sidebar for Page', 'infographer' ),
			'id'            => 'sidebar_page',
			'description'   => esc_html__( 'Default Sidebar area for Pages. In order to display this area you need to enable sidebar layout through global theme options or on page meta box options.', 'infographer' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s posts_holder">',
			'after_widget'  => '</div>',
			'before_title' => '<h5>',
			'after_title' => '</h5>'
		) );
		
		register_sidebar( array(
			'name'          => esc_html__( 'Header Right', 'infographer' ),
			'id'            => 'header_right',
			'description'   => esc_html__( 'Widgets added here will appear on the right side in header area', 'infographer' ),
			'before_widget' => '<div class="header-widget %2$s header-right-widget">',
			'after_widget'  => '</div>',
			'before_title'  => '',
			'after_title'   => ''
		) );
		
		register_sidebar( array(
			'name'          => esc_html__( 'Footer Column 1', 'infographer' ),
			'id'            => 'footer_column_1',
			'description'   => esc_html__( 'Widgets added here will appear in the first column of top footer area', 'infographer' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4>',
			'after_title'   => '</h4>'
		) );
		
		register_sidebar( array(
			'name'          => esc_html__( 'Footer Column 2', 'infographer' ),
			'id'            => 'footer_column_2',
			'description'   => esc_html__( 'Widgets added here will appear in the second column of top footer area', 'infographer' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4>',
			'after_title'   => '</h4>'
		) );
		
		register_sidebar( array(
			'name'          => esc_html__( 'Footer Column 3', 'infographer' ),
			'id'            => 'footer_column_3',
			'description'   => esc_html__( 'Widgets added here will appear in the third column of top footer area', 'infographer' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4>',
			'after_title'   => '</h4>'
		) );
		
		register_sidebar( array(
			'name'          => esc_html__( 'Footer Column 4', 'infographer' ),
			'id'            => 'footer_column_4',
			'description'   => esc_html__( 'Widgets added here will appear in the fourth column of top footer area', 'infographer' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4>',
			'after_title'   => '</h4>'
		) );
		
		register_sidebar( array(
			'name'          => esc_html__( 'Footer Text', 'infographer' ),
			'id'            => 'footer_text',
			'description'   => esc_html__( 'Widgets added here will appear in the footer bottom text area', 'infographer' ),
			'before_widget' => '',
			'after_widget'  => '',
			'before_title'  => '',
			'after_title'   => ''
		) );
	}
	
	add_action( 'widgets_init', 'infographer_qode_register_sidebars' );
}

if ( ! function_exists( 'infographer_qode_comment' ) ) {
	function infographer_qode_comment( $comment, $args, $depth ) {
		$GLOBALS['comment'] = $comment;
		
		$is_pingback_comment = $comment->comment_type == 'pingback';
		
		$comment_class = 'comment';
		
		if ( $is_pingback_comment ) {
			$comment_class .= ' pingback-comment';
		}
		?>
		<li>
		<div class="<?php echo esc_attr( $comment_class ); ?>">
			<?php if ( ! $is_pingback_comment ) { ?>
				<div class="image"> <?php echo get_avatar($comment, 120); ?> </div>
			<?php } ?>
			<div class="text">
				<span class="name"><?php if ( $is_pingback_comment ) { esc_html_e( 'Pingback:', 'infographer' ); } ?><?php echo get_comment_author_link(); ?></span>
				<?php if ( ! $is_pingback_comment ) { ?>
					<div class="text_holder" id="comment-<?php echo esc_attr( comment_ID() ); ?>">
						<?php comment_text(); ?>
					</div>
				<?php } ?>
				<?php comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
			</div>
		</div>
		
		<?php if ( $comment->comment_approved == '0' ) : ?>
			<p><em><?php esc_html_e( 'Your comment is awaiting moderation.', 'infographer' ); ?></em></p>
		<?php endif; ?>
		<?php
	}
}