<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>"/>
	
	<?php
	/**
	 * infographer_qode_action_header_meta hook
	 *
	 * @see infographer_core_header_meta() - hooked with 10
	 * @see infographer_qode_user_scalable_meta() - hooked with 10
	 */
	do_action( 'infographer_qode_action_header_meta' );
	?>
	
	<link rel="profile" href="http://gmpg.org/xfn/11"/>
	<?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
		<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<?php endif; ?>
	
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
	<div class="wrapper">
		<?php do_action( 'infographer_qode_after_wrapper_begin' ); ?>
		
		<?php get_template_part( 'includes/modules/back-to-top' ); ?>
		<?php get_template_part( 'includes/modules/header' ); ?>
		<div class="content">
			<?php do_action( 'infographer_qode_after_content_begin' ); ?>
			<div class="<?php echo esc_attr( apply_filters( 'infographer_qode_content_classes', 'content_inner' ) ); ?>">
				<?php get_template_part( 'slider' ); ?>
				
			