<?php
$infographer_options = infographer_qode_return_global_options();

$header_hide = false;
if ( $infographer_options['header_hide'] == "yes" ) {
	$header_hide = true;
}

$header_in_grid = false;
if ( $infographer_options['header_in_grid'] == "yes" ) {
	$header_in_grid = true;
}

$menu_position = "left";
if ( $infographer_options['menu_position'] == "right" ) {
	$menu_position = "right";
}

if ( $infographer_options['menu_lineheight'] != "" ) {
	$line_height = $infographer_options['menu_lineheight'];
} else {
	$line_height = 80;
}

$header_classes = array();

if ( isset( $infographer_options['header_fixed'] ) && $infographer_options['header_fixed'] == "no" ) {
	$header_classes[] = 'no_fixed';
}

$logo_styles = array();

if ( ! empty( $line_height ) ) {
	$logo_styles[] = 'height:' . intval( $line_height ) . 'px;';
}

if ( ! $header_hide ) { ?>
	<header class="page_header <?php echo esc_attr( implode( ' ', $header_classes ) ); ?>">
		<div class="header_outer">
			<?php if ( $header_in_grid ){ ?>
			<div class="container">
				<div class="container_inner clearfix">
					<?php } ?>
					<div class="header_inner clearfix">
						<div class="logo" <?php infographer_qode_inline_style( $logo_styles ); ?>>
							<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
								<img src="<?php echo esc_url( $infographer_options['logo_image'] ); ?>" alt="<?php esc_attr_e( 'Logo image', 'infographer' ); ?>"/>
							</a>
						</div>
						
						<nav class="main_menu drop_down <?php echo esc_attr( $menu_position ); ?>">
							<?php
							wp_nav_menu( array(
								'theme_location'  => 'top-navigation',
								'container'       => '',
								'container_class' => '',
								'menu_class'      => 'clearfix',
								'menu_id'         => '',
								'fallback_cb'     => 'infographer_qode_top_navigation_fallback',
								'walker'          => new infographer_qode_type1_walker_nav_menu()
							) );
							?>
						</nav>
						
						<?php if ( has_nav_menu( 'top-navigation' ) ) { ?>
							<div class='selectnav_button'><span>&nbsp;</span></div>
						<?php } ?>
						
						<?php if ( $infographer_options['header_widget_area'] == "yes" && is_active_sidebar( 'header_right' ) ) { ?>
							<div class="header_right_widget">
								<?php dynamic_sidebar( 'header_right' ); ?>
							</div>
						<?php } ?>
						
						<nav class="selectnav"></nav>
					</div>
					
					<?php if ( $header_in_grid ){ ?>
				</div>
			</div>
		<?php } ?>
		</div>
	</header>
<?php } ?>