<?php
$infographer_options = infographer_qode_return_global_options();

if ( $infographer_options['enable_social_share'] == "yes" ) {
	$post_type = get_post_type();
	
	$twitter_via = "";
	if ( ! empty( $infographer_options['twitter_via'] ) ) {
		$twitter_via = esc_html__( " via ", 'infographer' ) . $infographer_options['twitter_via'];
	}
	
	if ( isset( $infographer_options["post_types_names_$post_type"] ) && $infographer_options["post_types_names_$post_type"] == $post_type ) { ?>
		<div class="social-share">
			<ul>
				<?php if ( $infographer_options['enable_facebook_share'] == "yes" ) { ?>
					<li>
						<a href="#" onclick="window.open('https://www.facebook.com/sharer.php?s=100&amp;p[title]=<?php echo get_the_title(); ?>&amp;p[summary]=<?php echo htmlspecialchars( get_the_excerpt() ); ?>&amp;p[url]=<?php echo urlencode( get_permalink() ); ?>&amp;&p[images][0]=<?php if ( function_exists( 'the_post_thumbnail' ) ) { echo wp_get_attachment_url( get_post_thumbnail_id() ); } ?>', 'sharer', 'toolbar=0,status=0,width=620,height=280');" href="javascript: void(0)">
							<?php if ( ! empty( $infographer_options['facebook_icon'] ) ) { ?>
								<img src="<?php echo esc_url( $infographer_options['facebook_icon'] ); ?>"/>
							<?php } else { ?>
								<img src="<?php echo get_template_directory_uri(); ?>/css/img/icon_facebook_like.png" alt="<?php esc_attr_e( 'Facebook Share Image', 'infographer' ); ?>"/>
							<?php } ?>
							<span><?php esc_html_e( 'Share', 'infographer' ); ?></span>
						</a>
					</li>
				<?php } ?>
				<?php if ( $infographer_options['enable_twitter_share'] == "yes" ) { ?>
					<li>
						<?php ?>
						<a href="#" onclick="popUp=window.open('https://twitter.com/share?url=<?php echo urlencode( get_permalink() ); ?>&text=<?php echo urlencode( infographer_qode_the_excerpt_max_charlength( mb_strlen( get_permalink() ) ) . $twitter_via ); ?>&count=horiztonal', 'popupwindow', 'scrollbars=yes,width=800,height=400');popUp.focus();return false;" target="_blank" rel="nofollow">
							<?php if ( ! empty( $infographer_options['twitter_icon'] ) ) { ?>
								<img src="<?php echo esc_url( $infographer_options['twitter_icon'] ); ?>"/>
							<?php } else { ?>
								<img src="<?php echo get_template_directory_uri(); ?>/css/img/icon_tweet.png" alt="<?php esc_attr_e( 'Twitter Share Image', 'infographer' ); ?>"/>
							<?php } ?>
							<span><?php esc_html_e( 'Tweet', 'infographer' ); ?></span>
						</a>
					</li>
				<?php } ?>
				<?php if ( $infographer_options['enable_google_plus'] == "yes" ) { ?>
					<li>
						<a href="#" onclick="popUp=window.open('https://plus.google.com/share?url=<?php echo urlencode( get_permalink() ); ?>', 'popupwindow', 'scrollbars=yes,width=800,height=400');popUp.focus();return false">
							<?php if ( ! empty( $infographer_options['google_plus_icon'] ) ) { ?>
								<img src="<?php echo esc_url( $infographer_options['google_plus_icon'] ); ?>"/>
							<?php } else { ?>
								<img src="<?php echo get_template_directory_uri(); ?>/css/img/icon_g_plus.png" alt="<?php esc_attr_e( 'Google + Share Image', 'infographer' ); ?>"/>
							<?php } ?>
							<span><?php esc_html_e( 'Share', 'infographer' ); ?></span>
						</a>
					</li>
				<?php } ?>
			</ul>
		</div>
	<?php }
} ?>	
