<?php

if ( ! function_exists( 'infographer_qode_add_theme_version_class' ) ) {
	/**
	 * Function that adds classes on body for version of theme
	 */
	function infographer_qode_add_theme_version_class( $classes ) {
		$current_theme = wp_get_theme();
		$theme_prefix  = 'infographer';
		
		//is child theme activated?
		if ( $current_theme->parent() ) {
			//add child theme version
			$classes[] = $theme_prefix . '-child-theme-ver-' . $current_theme->get( 'Version' );
			
			//get parent theme
			$current_theme = $current_theme->parent();
		}
		
		if ( $current_theme->exists() && $current_theme->get( 'Version' ) != "" ) {
			$classes[] = $theme_prefix . '-theme-ver-' . $current_theme->get( 'Version' );
		}
		
		return $classes;
	}
	
	add_filter( 'body_class', 'infographer_qode_add_theme_version_class' );
}

/* Add class on body for ajax */

if ( ! function_exists( 'infographer_qode_add_ajax_classes' ) ) {
	function infographer_qode_add_ajax_classes( $classes ) {
		$global_options = infographer_qode_return_global_options();
		
		$qode_animation = "";
		if ( isset( $_SESSION['qode_animation'] ) ) {
			$qode_animation = $_SESSION['qode_animation'];
		}
		if ( ( $global_options['page_transitions'] === "0" ) && ( $qode_animation == "no" ) ) :
			$classes[] = '';
		elseif ( $global_options['page_transitions'] === "1" && ( empty( $qode_animation ) || ( $qode_animation != "no" ) ) ) :
			$classes[] = 'ajax_updown';
			$classes[] = 'page_not_loaded';
		elseif ( $global_options['page_transitions'] === "2" && ( empty( $qode_animation ) || ( $qode_animation != "no" ) ) ) :
			$classes[] = 'ajax_fade';
			$classes[] = 'page_not_loaded';
		elseif ( $global_options['page_transitions'] === "3" && ( empty( $qode_animation ) || ( $qode_animation != "no" ) ) ) :
			$classes[] = 'ajax_updown_fade';
			$classes[] = 'page_not_loaded';
		elseif ( $global_options['page_transitions'] === "4" && ( empty( $qode_animation ) || ( $qode_animation != "no" ) ) ) :
			$classes[] = 'ajax_leftright';
			$classes[] = 'page_not_loaded';
		elseif ( ! empty( $qode_animation ) && $qode_animation != "no" ) :
			$classes[] = 'page_not_loaded';
		endif;
		
		return $classes;
	}
	
	add_filter( 'body_class', 'infographer_qode_add_ajax_classes' );
}

if ( ! function_exists( 'infographer_qode_add_boxed_class' ) ) {
	function infographer_qode_add_boxed_class( $classes ) {
		$global_options = infographer_qode_return_global_options();
		
		if ( isset( $global_options['boxed'] ) && $global_options['boxed'] == "yes" ) :
			$classes[] = 'boxed';
		endif;
		
		return $classes;
	}
	
	add_filter( 'body_class', 'infographer_qode_add_boxed_class' );
}

/* Add class for no delay on body */

if ( ! function_exists( 'infographer_qode_delay_class' ) ) {
	function infographer_qode_delay_class( $classes ) {
		$global_options = infographer_qode_return_global_options();
		
		$delay = false;
		if ( isset( $global_options['delay'] ) && $global_options['delay'] == "yes" ) {
			$delay = true;
		}
		
		if ( $delay ) {
			$classes[] = 'no_delay';	
		}
		
		$show_page_title = get_post_meta( infographer_qode_get_page_id(), "qode_show-page-title", true );
		
		if ( $show_page_title ) :
			$classes[] = 'qode_page_title_on';
		endif;
		
		return $classes;
	}
	
	add_filter( 'body_class', 'infographer_qode_delay_class' );
}