<?php

if ( ! function_exists( 'infographer_qode_is_css_folder_writable' ) ) {
	function infographer_qode_is_css_folder_writable() {
		return is_writable( QODE_CSS_ROOT_DIR );
	}
}

if ( ! function_exists( 'infographer_qode_is_js_folder_writable' ) ) {
	function infographer_qode_is_js_folder_writable() {
		return is_writable( QODE_JS_ROOT_DIR );
	}
}

if ( ! function_exists( 'infographer_qode_get_multisite_blog_id' ) ) {
	function infographer_qode_get_multisite_blog_id() {
		if ( is_multisite() ) {
			return get_blog_details()->blog_id;
		}
	}
}

if ( ! function_exists( 'infographer_qode_generate_dynamic_css_and_js' ) ) {
	/**
	 * Function that gets content of dynamic assets files and puts that in static ones
	 */
	function infographer_qode_generate_dynamic_css_and_js() {
		global $wp_filesystem;
		WP_Filesystem();
		
		if ( infographer_qode_is_css_folder_writable() ) {
			
			ob_start();
			include_once QODE_CSS_ROOT_DIR . '/style_dynamic.php';
			$css = ob_get_clean();
			if ( is_multisite() ) {
				$wp_filesystem->put_contents( QODE_CSS_ROOT_DIR . '/style_dynamic_ms_id_' . infographer_qode_get_multisite_blog_id() . '.css', $css );
			} else {
				$wp_filesystem->put_contents( QODE_CSS_ROOT_DIR . '/style_dynamic.css', $css );
			}
			
			ob_start();
			include_once QODE_CSS_ROOT_DIR . '/style_dynamic_responsive.php';
			$css = ob_get_clean();
			if ( is_multisite() ) {
				$wp_filesystem->put_contents( QODE_CSS_ROOT_DIR . '/style_dynamic_responsive_ms_id_' . infographer_qode_get_multisite_blog_id() . '.css', $css );
			} else {
				$wp_filesystem->put_contents( QODE_CSS_ROOT_DIR . '/style_dynamic_responsive.css', $css );
			}
		}
		
		if ( infographer_qode_is_js_folder_writable() ) {
			
			ob_start();
			include_once QODE_JS_ROOT_DIR . '/default_dynamic.php';
			$js = ob_get_clean();
			if ( is_multisite() ) {
				$wp_filesystem->put_contents( QODE_JS_ROOT_DIR . '/default_dynamic_ms_id_' . infographer_qode_get_multisite_blog_id() . '.js', $js );
			} else {
				$wp_filesystem->put_contents( QODE_JS_ROOT_DIR . '/default_dynamic.js', $js );
			}
		}
	}
	
	add_action( 'infographer_qode_action_after_theme_option_save', 'infographer_qode_generate_dynamic_css_and_js' );
}

if ( ! function_exists( 'infographer_qode_add_style_dynamic' ) ) {
	function infographer_qode_add_style_dynamic() {
		$infographer_options = infographer_qode_return_global_options();
		?>
		
		<?php if (!empty($infographer_options['selection_color'])) { ?>
			/* Webkit */
			::selection {
			background: <?php echo esc_attr($infographer_options['selection_color']);  ?>;
			}
		<?php } ?>
		<?php if (!empty($infographer_options['selection_color'])) { ?>
			/* Gecko/Mozilla */
			::-moz-selection {
			background: <?php echo esc_attr($infographer_options['selection_color']);  ?>;
			}
		<?php } ?>
		<?php if (!empty($infographer_options['background_color']) || !empty($infographer_options['text_color']) || !empty($infographer_options['text_fontsize']) || $infographer_options['google_fonts'] != "-1") { ?>
			body {
			<?php if (!empty($infographer_options['background_color'])) { ?> background-color:<?php echo esc_attr($infographer_options['background_color']);  ?>; <?php } ?>
			<?php if($infographer_options['google_fonts'] != "-1"){ ?>
				<?php $font = str_replace('+', ' ', $infographer_options['google_fonts']); ?>
				font-family: <?php echo esc_attr($font); ?>, sans-serif;
			<?php } ?>
			<?php if (!empty($infographer_options['text_color'])) { ?> color: <?php echo esc_attr($infographer_options['text_color']);  ?>; <?php } ?>
			<?php if (!empty($infographer_options['text_fontsize'])) { ?> font-size: <?php echo intval($infographer_options['text_fontsize']); ?>px; <?php } ?>
			
			}
		<?php } ?>
		<?php
		if (!empty($infographer_options['first_color'])) {
			?>
			nav.main_menu > ul > li.active > a,
			nav.main_menu > ul > li.has_sub:hover > a,
			nav.main_menu > ul > li:hover > a,
			nav.content_menu,
			.button,
			input[type='submit'],
			.load_more a,
			.flip_image.back,
			.flip_icon.back,
			.highlight,
			.filter_holder ul,
			.projects_holder article .hover_inner .hover_inner_link_text_holder,
			.flex-direction-nav .flex-next:hover,
			.flex-direction-nav .flex-prev:hover,
			.two_columns_66_33 .column1 .flex-direction-nav .flex-prev:hover,
			.two_columns_66_33 .column1 .flex-direction-nav .flex-next:hover,
			.progress_bars_vertical.background_color .progress_content_outer .progress_content,
			.portfolio_navigation .portfolio_prev a:hover,
			.portfolio_navigation .portfolio_next a:hover,
			.portfolio_navigation .portfolio_button a:hover,
			.progress_bars.normal .progress_content,
			.tabs .tabs-nav li.active a,
			.message,
			.testimonials_text_holder,
			.pie_graf_legend ul li .color_holder,
			.line_graf_legend ul li .color_holder,
			.price_tables.light .puchase_cell,
			.price_table_inner ul li .button,
			.active_best_price,
			.pagination ul li a:hover,
			.pagination ul li.active span,
			.back_to_previous:hover,
			#back_to_top,
			#back_to_top:hover,
			.widget.widget_search form input[type="submit"],
			.widget .tagcloud a:hover
			{
			background-color: <?php echo esc_attr($infographer_options['first_color']);?>;
			}
			.progress_bars.gradient .progress_content{
			background-color: <?php echo esc_attr($infographer_options['first_color']);?>;
			background: -moz-linear-gradient(left,  #262626 9%, <?php echo esc_attr($infographer_options['first_color']);?> 100%); /* FF3.6+ */
			background: -webkit-gradient(linear, left top, right top, color-stop(9%,#262626), color-stop(100%,<?php echo esc_attr($infographer_options['first_color']);?>)); /* Chrome,Safari4+ */
			background: -webkit-linear-gradient(left,  #262626 9%,<?php echo esc_attr($infographer_options['first_color']);?> 100%); /* Chrome10+,Safari5.1+ */
			background: -o-linear-gradient(left,  #262626 9%,<?php echo esc_attr($infographer_options['first_color']);?> 100%); /* Opera 11.10+ */
			background: -ms-linear-gradient(left,  #262626 9%,<?php echo esc_attr($infographer_options['first_color']);?> 100%); /* IE10+ */
			background: linear-gradient(to right,  #262626 9%,<?php echo esc_attr($infographer_options['first_color']);?> 100%); /* W3C */
			filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#262626', endColorstr='<?php echo esc_attr($infographer_options['first_color']);?>',GradientType=1 ); /* IE6-8 */
			}
			.portfolio_single_text_holder h4,
			.post .read_more,
			.comment_holder .comment .text .replay:hover,
			.comment_holder .comment .text .comment-reply-link:hover,
			.progress_bars_vertical.pattern .progress_number
			{
			color: <?php echo esc_attr($infographer_options['first_color']);?>;
			}
			nav.content_menu ul li .arrow,
			.tabs .tabs-nav li.active .arrow,
			.message_arrow
			{
			border-color: <?php echo esc_attr($infographer_options['first_color']);?> transparent transparent transparent;
			}
			.testimonial_arrow
			{
			border-color: transparent <?php echo esc_attr($infographer_options['first_color']);?> transparent transparent;
			}
			blockquote
			{
			border-color: <?php echo esc_attr($infographer_options['first_color']);?>;
			}
		<?php } ?>
		
		<?php
		if (!empty($infographer_options['second_color'])) {
			?>
			blockquote,
			.portfolio_navigation .portfolio_prev a,
			.portfolio_navigation .portfolio_next a,
			.portfolio_navigation .portfolio_button,
			.portfolio_navigation .portfolio_button a,
			input[type='text'],
			.social-share ul li a,
			textarea,
			table.standard_table th,
			table.standard_table tr:nth-child(odd) td,
			.price_table_inner,
			.price_tables.light .price_cell,
			.comment_holder .comment,
			.pagination ul li span,
			.pagination ul li a,
			.tabs .tabs-container,
			.progress_bars .progress_content_outer
			{
			background-color: <?php echo esc_attr($infographer_options['second_color']);?>;
			}
		<?php } ?>
		<?php
		if (!empty($infographer_options['header_background_color'])) {
			?>
			header .header_outer,
			.selectnav ul {
			background-color: <?php echo esc_attr($infographer_options['header_background_color']);  ?>;
			}
			<?php
		}
		?>
		
		<?php
		$boxed = "no";
		if (isset($infographer_options['boxed']))
			$boxed = $infographer_options['boxed'];
		?>
		<?php if($boxed == "yes"){ ?>
			body.boxed{
			<?php if (!empty($infographer_options['background_color_box'])) { ?> background-color:<?php echo esc_attr($infographer_options['background_color_box']);  ?>; <?php } ?>
			<?php if($infographer_options['pattern_background_image'] != ""){  ?>
				background-image: url('<?php echo esc_url($infographer_options['pattern_background_image']) ?>');
				background-position: 0px 0px;
				background-repeat: repeat;
			<?php } ?>
			
			<?php if($infographer_options['background_image'] != ""){  ?>
				background-image: url('<?php echo esc_url($infographer_options['background_image']) ?>');
				background-attachment: fixed;
				background-position: center 0px;
				background-repeat: no-repeat;
			<?php } ?>
			}
			
			<?php if (!empty($infographer_options['background_color'])) { ?>
				body.boxed .content{
				background-color:<?php echo esc_attr($infographer_options['background_color']);  ?>;
				}
			<?php } ?>
		
		<?php } ?>
		
		<?php if (!empty($infographer_options['menu_lineheight']) && $infographer_options['header_hide'] == "no") { ?>
			.content{
			margin-top: <?php echo intval($infographer_options['menu_lineheight']); ?>px;
			}
		<?php }else if($infographer_options['header_hide'] == "no" || !isset($infographer_options['header_hide'])){ ?>
			.content{
			margin-top: 80px;
			}
		
		<?php } ?>
		
		<?php if (!empty($infographer_options['h1_color']) || !empty($infographer_options['h1_fontsize']) || !empty($infographer_options['h1_lineheight']) || !empty($infographer_options['h1_fontstyle']) || !empty($infographer_options['h1_fontweight']) || $infographer_options['h1_google_fonts'] != "-1") { ?>
			h1{
			<?php if (!empty($infographer_options['h1_color'])) { ?>	color: <?php echo esc_attr($infographer_options['h1_color']);  ?>; <?php } ?>
			<?php if($infographer_options['h1_google_fonts'] != "-1"){ ?>
				font-family: <?php echo str_replace('+', ' ', $infographer_options['h1_google_fonts']); ?>, sans-serif;
			<?php } ?>
			<?php if (!empty($infographer_options['h1_fontsize'])) { ?>font-size: <?php echo intval($infographer_options['h1_fontsize']);  ?>px; <?php } ?>
			<?php if (!empty($infographer_options['h1_lineheight'])) { ?>line-height: <?php echo intval($infographer_options['h1_lineheight']);  ?>px; <?php } ?>
			<?php if (!empty($infographer_options['h1_fontstyle'])) { ?>font-style: <?php echo esc_attr($infographer_options['h1_fontstyle']);  ?>; <?php } ?>
			<?php if (!empty($infographer_options['h1_fontweight'])) { ?>font-weight: <?php echo esc_attr($infographer_options['h1_fontweight']);  ?>; <?php } ?>
			}
		<?php } ?>
		<?php if (!empty($infographer_options['page_title_color']) || !empty($infographer_options['page_title_fontsize']) || !empty($infographer_options['page_title_lineheight']) || !empty($infographer_options['page_title_fontstyle']) || !empty($infographer_options['page_title_fontweight']) || $infographer_options['page_title_google_fonts'] != "-1") { ?>
			.title h1{
			<?php if (!empty($infographer_options['page_title_color'])) { ?>color: <?php echo esc_attr($infographer_options['page_title_color']);  ?>; <?php } ?>
			<?php if($infographer_options['page_title_google_fonts'] != "-1"){ ?>
				font-family: <?php echo str_replace('+', ' ', $infographer_options['page_title_google_fonts']); ?>, sans-serif;
			<?php } ?>
			<?php if (!empty($infographer_options['page_title_fontsize'])) { ?>font-size: <?php echo intval($infographer_options['page_title_fontsize']);  ?>px; <?php } ?>
			<?php if (!empty($infographer_options['page_title_lineheight'])) { ?>line-height: <?php echo intval($infographer_options['page_title_lineheight']);  ?>px; <?php } ?>
			<?php if (!empty($infographer_options['page_title_fontstyle'])) { ?>font-style: <?php echo esc_attr($infographer_options['page_title_fontstyle']);  ?>; <?php } ?>
			<?php if (!empty($infographer_options['page_title_fontweight'])) { ?>font-weight: <?php echo esc_attr($infographer_options['page_title_fontweight']);  ?>; <?php } ?>
			
			}
		<?php } ?>
		
		<?php if ($infographer_options['page_title_position'] != "0") { ?>
			.title .title_text{
			<?php if($infographer_options['page_title_position'] != "0"){ ?>
				text-align: <?php if($infographer_options['page_title_position'] == "1"){echo "left";} if($infographer_options['page_title_position'] == "2"){echo "center";} if($infographer_options['page_title_position'] == "3"){echo "right";}  ?>;
			<?php } ?>
			}
		<?php } ?>
		
		<?php if (!empty($infographer_options['page_title_color'])){ ?>
			.title .title_text span{
			color: <?php echo esc_attr($infographer_options['page_title_color']);  ?>;
			}
		<?php } ?>
		
		<?php if (!empty($infographer_options['h2_color']) || !empty($infographer_options['h2_fontsize']) || !empty($infographer_options['h2_lineheight']) || !empty($infographer_options['h2_fontstyle']) || !empty($infographer_options['h2_fontweight']) || $infographer_options['h2_google_fonts'] != "-1") { ?>
			h2, h2 a,
			.blog_single_holder h2
			{
			<?php if (!empty($infographer_options['h2_color'])) { ?>color: <?php echo esc_attr($infographer_options['h2_color']);  ?>; <?php } ?>
			<?php if($infographer_options['h2_google_fonts'] != "-1"){ ?>
				font-family: <?php echo str_replace('+', ' ', $infographer_options['h2_google_fonts']); ?>, sans-serif;
			<?php } ?>
			<?php if (!empty($infographer_options['h2_fontsize'])) { ?>font-size: <?php echo intval($infographer_options['h2_fontsize']);  ?>px; <?php } ?>
			<?php if (!empty($infographer_options['h2_lineheight'])) { ?>line-height: <?php echo intval($infographer_options['h2_lineheight']);  ?>px; <?php } ?>
			<?php if (!empty($infographer_options['h2_fontstyle'])) { ?>font-style: <?php echo esc_attr($infographer_options['h2_fontstyle']);  ?>; <?php } ?>
			<?php if (!empty($infographer_options['h2_fontweight'])) { ?>font-weight: <?php echo esc_attr($infographer_options['h2_fontweight']);  ?>; <?php } ?>
			}
		<?php } ?>
		<?php if (!empty($infographer_options['h3_color']) || !empty($infographer_options['h3_fontsize']) || !empty($infographer_options['h3_lineheight']) || !empty($infographer_options['h3_fontstyle']) || !empty($infographer_options['h3_fontweight']) || $infographer_options['h3_google_fonts'] != "-1") { ?>
			h3, h3 a{
			<?php if (!empty($infographer_options['h3_color'])) { ?>color: <?php echo esc_attr($infographer_options['h3_color']);  ?>; <?php } ?>
			<?php if($infographer_options['h3_google_fonts'] != "-1"){ ?>
				font-family: <?php echo str_replace('+', ' ', $infographer_options['h3_google_fonts']); ?>, sans-serif;
			<?php } ?>
			<?php if (!empty($infographer_options['h3_fontsize'])) { ?>font-size: <?php echo intval($infographer_options['h3_fontsize']);  ?>px; <?php } ?>
			<?php if (!empty($infographer_options['h3_lineheight'])) { ?>line-height: <?php echo intval($infographer_options['h3_lineheight']);  ?>px; <?php } ?>
			<?php if (!empty($infographer_options['h3_fontstyle'])) { ?>font-style: <?php echo esc_attr($infographer_options['h3_fontstyle']);?>; <?php } ?>
			<?php if (!empty($infographer_options['h3_fontweight'])) { ?>font-weight: <?php echo esc_attr($infographer_options['h3_fontweight']);  ?>; <?php } ?>
			}
		<?php } ?>
		<?php if (!empty($infographer_options['h4_color']) || !empty($infographer_options['h4_fontsize']) || !empty($infographer_options['h4_lineheight']) || !empty($infographer_options['h4_fontstyle']) || !empty($infographer_options['h4_fontweight']) || $infographer_options['h4_google_fonts'] != "-1") { ?>
			h4, h4 a{
			<?php if (!empty($infographer_options['h4_color'])) { ?>color: <?php echo esc_attr($infographer_options['h4_color']);  ?>; <?php } ?>
			<?php if($infographer_options['h4_google_fonts'] != "-1"){ ?>
				font-family: <?php echo str_replace('+', ' ', $infographer_options['h4_google_fonts']); ?>, sans-serif;
			<?php } ?>
			<?php if (!empty($infographer_options['h4_fontsize'])) { ?>font-size: <?php echo intval($infographer_options['h4_fontsize']);  ?>px; <?php } ?>
			<?php if (!empty($infographer_options['h4_lineheight'])) { ?>line-height: <?php echo intval($infographer_options['h4_lineheight']);  ?>px; <?php } ?>
			<?php if (!empty($infographer_options['h4_fontstyle'])) { ?>font-style: <?php echo esc_attr($infographer_options['h4_fontstyle']);  ?>; <?php } ?>
			<?php if (!empty($infographer_options['h4_fontweight'])) { ?>font-weight: <?php echo esc_attr($infographer_options['h4_fontweight']);  ?>; <?php } ?>
			}
		<?php } ?>
		
		<?php if (!empty($infographer_options['h5_color']) || !empty($infographer_options['h5_fontsize']) || !empty($infographer_options['h5_lineheight']) || !empty($infographer_options['h5_fontstyle']) || !empty($infographer_options['h5_fontweight']) || $infographer_options['h5_google_fonts'] != "-1") { ?>
			h5{
			<?php if (!empty($infographer_options['h5_color'])) { ?>color: <?php echo esc_attr($infographer_options['h5_color']);  ?>; <?php } ?>
			<?php if($infographer_options['h5_google_fonts'] != "-1"){ ?>
				font-family: <?php echo str_replace('+', ' ', $infographer_options['h5_google_fonts']); ?>, sans-serif;
			<?php } ?>
			<?php if (!empty($infographer_options['h5_fontsize'])) { ?>font-size: <?php echo intval($infographer_options['h5_fontsize']);  ?>px; <?php } ?>
			<?php if (!empty($infographer_options['h5_lineheight'])) { ?>line-height: <?php echo intval($infographer_options['h5_lineheight']);  ?>px; <?php } ?>
			<?php if (!empty($infographer_options['h5_fontstyle'])) { ?>font-style: <?php echo esc_attr($infographer_options['h5_fontstyle']);  ?>; <?php } ?>
			<?php if (!empty($infographer_options['h5_fontweight'])) { ?>font-weight: <?php echo esc_attr($infographer_options['h5_fontweight']);  ?>; <?php } ?>
			}
		<?php } ?>
		<?php if (!empty($infographer_options['h6_color']) || !empty($infographer_options['h6_fontsize']) || !empty($infographer_options['h6_lineheight']) || !empty($infographer_options['h6_fontstyle']) || !empty($infographer_options['h6_fontweight']) || $infographer_options['h6_google_fonts'] != "-1") { ?>
			h6{
			<?php if (!empty($infographer_options['h6_color'])) { ?>color: <?php echo esc_attr($infographer_options['h6_color']);  ?>; <?php } ?>
			<?php if($infographer_options['h6_google_fonts'] != "-1"){ ?>
				font-family: <?php echo str_replace('+', ' ', $infographer_options['h6_google_fonts']); ?>, sans-serif;
			<?php } ?>
			<?php if (!empty($infographer_options['h6_fontsize'])) { ?>font-size: <?php echo intval($infographer_options['h6_fontsize']);  ?>px; <?php } ?>
			<?php if (!empty($infographer_options['h6_lineheight'])) { ?>line-height: <?php echo intval($infographer_options['h6_lineheight']);  ?>px; <?php } ?>
			<?php if (!empty($infographer_options['h6_fontstyle'])) { ?>font-style: <?php echo esc_attr($infographer_options['h6_fontstyle']);  ?>;  <?php } ?>
			<?php if (!empty($infographer_options['h6_fontweight'])) { ?>font-weight: <?php echo esc_attr($infographer_options['h6_fontweight']);  ?>; <?php } ?>
			}
		<?php } ?>
		<?php if (!empty($infographer_options['text_color']) || !empty($infographer_options['text_fontsize']) || !empty($infographer_options['text_lineheight']) || !empty($infographer_options['text_fontstyle']) || !empty($infographer_options['text_fontweight']) || $infographer_options['text_google_fonts'] != "-1") { ?>
			p,
			.title span{
			<?php if (!empty($infographer_options['text_color'])) { ?>color: <?php echo esc_attr($infographer_options['text_color']);  ?>;<?php } ?>
			<?php if($infographer_options['text_google_fonts'] != "-1"){ ?>
				font-family: <?php echo str_replace('+', ' ', $infographer_options['text_google_fonts']); ?>, sans-serif;
			<?php } ?>
			<?php if (!empty($infographer_options['text_fontsize'])) { ?>font-size: <?php echo intval($infographer_options['text_fontsize']);  ?>px;<?php } ?>
			<?php if (!empty($infographer_options['text_lineheight'])) { ?>line-height: <?php echo intval($infographer_options['text_lineheight']);  ?>px;<?php } ?>
			<?php if (!empty($infographer_options['text_fontstyle'])) { ?>font-style: <?php echo esc_attr($infographer_options['text_fontstyle']);  ?>;<?php } ?>
			<?php if (!empty($infographer_options['text_fontweight'])) { ?>font-weight: <?php echo esc_attr($infographer_options['text_fontweight']);  ?>;<?php } ?>
			}
		<?php } ?>
		<?php if (!empty($infographer_options['text_color']) || !empty($infographer_options['text_fontsize']) || !empty($infographer_options['text_lineheight']) || !empty($infographer_options['text_fontstyle']) || !empty($infographer_options['text_fontweight']) || $infographer_options['text_google_fonts'] != "-1") { ?>
			.post_info .author,
			.post_info .category,
			.post_info .author span,
			.post_info .category span,
			.post_info .category span a,
			.post_info .comment_number a,
			.post_date .month
			{
			<?php if (!empty($infographer_options['text_color'])) { ?>color: <?php echo esc_attr($infographer_options['text_color']);  ?>;<?php } ?>
			<?php if($infographer_options['text_google_fonts'] != "-1"){ ?>
				font-family: <?php echo str_replace('+', ' ', $infographer_options['text_google_fonts']); ?>, sans-serif;
			<?php } ?>
			<?php if (!empty($infographer_options['text_fontsize'])) { ?>font-size: <?php echo intval($infographer_options['text_fontsize']);  ?>px;<?php } ?>
			<?php if (!empty($infographer_options['text_lineheight'])) { ?>line-height: <?php echo intval($infographer_options['text_lineheight']);  ?>px;<?php } ?>
			<?php if (!empty($infographer_options['text_fontstyle'])) { ?>font-style: <?php echo esc_attr($infographer_options['text_fontstyle']);  ?>;<?php } ?>
			<?php if (!empty($infographer_options['text_fontweight'])) { ?>font-weight: <?php echo esc_attr($infographer_options['text_fontweight']);  ?>;<?php } ?>
			}
		<?php } ?>
		<?php if (!empty($infographer_options['text_color'])) { ?>
			.post_date .day{
			<?php if (!empty($infographer_options['text_color'])) { ?>color: <?php echo esc_attr($infographer_options['text_color']);  ?>;<?php } ?>
			}
		<?php } ?>
		<?php if (!empty($infographer_options['link_color']) || !empty($infographer_options['link_fontstyle']) || !empty($infographer_options['link_fontweight']) || !empty($infographer_options['link_fontdecoration'])) { ?>
			a, p a{
			<?php if (!empty($infographer_options['link_color'])) { ?>color: <?php echo esc_attr($infographer_options['link_color']);  ?>;<?php } ?>
			<?php if (!empty($infographer_options['link_fontstyle'])) { ?>font-style: <?php echo esc_attr($infographer_options['link_fontstyle']);  ?>;<?php } ?>
			<?php if (!empty($infographer_options['link_fontweight'])) { ?>font-weight: <?php echo esc_attr($infographer_options['link_fontweight']);  ?>;<?php } ?>
			<?php if (!empty($infographer_options['link_fontdecoration'])) { ?>text-decoration: <?php echo esc_attr($infographer_options['link_fontdecoration']);  ?>;<?php } ?>
			}
		<?php } ?>
		<?php if (!empty($infographer_options['link_hovercolor']) || !empty($infographer_options['link_fontdecoration'])) { ?>
			a:hover, p a:hover{
			<?php if (!empty($infographer_options['link_hovercolor'])) { ?>color: <?php echo esc_attr($infographer_options['link_hovercolor']);  ?>;<?php } ?>
			<?php if (!empty($infographer_options['link_fontdecoration'])) { ?>text-decoration: <?php echo esc_attr($infographer_options['link_fontdecoration']);  ?>;<?php } ?>
			}
		<?php } ?>
		<?php if (!empty($infographer_options['separator_thickness']) || !empty($infographer_options['separator_topmargin']) || !empty($infographer_options['separator_bottommargin']) || !empty($infographer_options['separator_color'])) { ?>
			.separator{
			<?php if (!empty($infographer_options['separator_thickness'])) { ?>	height: <?php echo intval($infographer_options['separator_thickness']);  ?>px; <?php } ?>
			<?php if (!empty($infographer_options['separator_topmargin'])) { ?>	margin-top: <?php echo intval($infographer_options['separator_topmargin']);  ?>px; <?php } ?>
			<?php if (!empty($infographer_options['separator_bottommargin'])) { ?>	margin-bottom: <?php echo intval($infographer_options['separator_bottommargin']);  ?>px; <?php } ?>
			<?php if (!empty($infographer_options['separator_color'])) { ?>	background-color: <?php echo esc_attr($infographer_options['separator_color']);  ?>; <?php } ?>
			}
			<?php if (!empty($infographer_options['separator_color'])) { ?>
				.blog_single_holder,
				.blog_holder.blog_sidebar article,
				.blog_holder section,
				.latest_post_small
				{
				border-color: <?php echo esc_attr($infographer_options['separator_color']);  ?>;
				}
			
			<?php } ?>
		
		<?php } ?>
		<?php if (!empty($infographer_options['separator_pattern_topmargin']) || !empty($infographer_options['separator_pattern_bottommargin']) || !empty($infographer_options['separator_pattern_color'])) { ?>
			.separator.pattern {
			<?php if (!empty($infographer_options['separator_pattern_color'])) { ?>
				background-color: <?php echo esc_attr($infographer_options['separator_pattern_color']);  ?>;
			<?php } ?>
			<?php if (!empty($infographer_options['separator_pattern_topmargin'])) { ?>
				margin-top: <?php echo intval($infographer_options['separator_pattern_topmargin']);  ?>px;
			<?php } ?>
			<?php if (!empty($infographer_options['separator_pattern_bottommargin'])) { ?>
				margin-bottom: <?php echo intval($infographer_options['separator_pattern_bottommargin']);  ?>px;
			<?php } ?>
			}
		<?php } ?>
		<?php if (!empty($infographer_options['button_title_color']) || !empty($infographer_options['button_title_fontsize']) || !empty($infographer_options['button_title_lineheight']) || !empty($infographer_options['button_title_fontstyle']) || !empty($infographer_options['button_title_fontweight']) || !empty($infographer_options['button_backgroundcolor']) || $infographer_options['button_title_google_fonts'] != "-1") { ?>
			.button, input[type="submit"],
			input[type="password"], .load_more a{
			<?php if (!empty($infographer_options['button_title_color'])) { ?>	color: <?php echo esc_attr($infographer_options['button_title_color']);  ?>; <?php } ?>
			<?php if($infographer_options['button_title_google_fonts'] != "-1"){ ?>
				font-family: <?php echo str_replace('+', ' ', $infographer_options['button_title_google_fonts']); ?>, sans-serif;
			<?php } ?>
			<?php if (!empty($infographer_options['button_title_fontsize'])) { ?>	font-size: <?php echo intval($infographer_options['button_title_fontsize']);  ?>px; <?php } ?>
			<?php if (!empty($infographer_options['button_title_lineheight'])) { ?>	line-height: <?php echo intval($infographer_options['button_title_lineheight']);  ?>px; <?php } ?>
			<?php if (!empty($infographer_options['button_title_fontstyle'])) { ?>	font-style: <?php echo esc_attr($infographer_options['button_title_fontstyle']);  ?>; <?php } ?>
			<?php if (!empty($infographer_options['button_title_fontweight'])) { ?>	font-weight: <?php echo esc_attr($infographer_options['button_title_fontweight']);  ?>; <?php } ?>
			<?php if (!empty($infographer_options['button_backgroundcolor'])) { ?>	background-color: <?php echo esc_attr($infographer_options['button_backgroundcolor']);  ?>; <?php } ?>
			}
		<?php } ?>
		<?php if (!empty($infographer_options['button_title_hovercolor'])) { ?>
			.button:hover,
			input[type='submit']:hover, .load_more a:hover{
			<?php if (!empty($infographer_options['button_title_hovercolor'])) { ?> color: <?php echo esc_attr($infographer_options['button_title_hovercolor']);?> !important; <?php } ?>
			}
		<?php } ?>
		<?php if (!empty($infographer_options['message_backgroundcolor'])) { ?>
			.message{
			background-color: <?php echo esc_attr($infographer_options['message_backgroundcolor']);  ?>;
			}
			.message_arrow {
			border-color: <?php echo esc_attr($infographer_options['message_backgroundcolor']);  ?> transparent transparent;
			}
		<?php } ?>
		<?php if (!empty($infographer_options['blockquote_background_color'])) { ?>
			blockquote{
			background-color: <?php echo esc_attr($infographer_options['blockquote_background_color']);  ?>;
			}
		<?php } ?>
		<?php if (!empty($infographer_options['blockquote_font_color'])) { ?>
			blockquote p{
			color: <?php echo esc_attr($infographer_options['blockquote_font_color']);  ?>;
			}
		<?php } ?>
		<?php if (!empty($infographer_options['message_title_color']) || $infographer_options['message_title_google_fonts'] != "-1") { ?>
			.message *{
			<?php if (!empty($infographer_options['message_title_color'])) { ?>
				color: <?php echo esc_attr($infographer_options['message_title_color']);  ?> !important;
			<?php } ?>
			<?php if($infographer_options['message_title_google_fonts'] != "-1"){ ?>
				font-family: <?php echo str_replace('+', ' ', $infographer_options['message_title_google_fonts']); ?>, sans-serif !important;
			<?php } ?>
			}
		<?php } ?>
		<?php if (!empty($infographer_options['highlight_color'])) { ?>
			.highlight {
			background-color: <?php echo esc_attr($infographer_options['highlight_color']);  ?>;
			}
		<?php } ?>
		<?php
		$parallax_onoff = "on";
		if (isset($infographer_options['parallax_onoff']))
			$parallax_onoff = $infographer_options['parallax_onoff'];
		if ($parallax_onoff == "off"){
			?>
			
			.touch .parallax section{
			height: auto !important;
			min-height: 300px;
			background-position: center top !important;
			background-size: 100% auto !important;
			background-attachment: scroll;
			}
			
			.touch	.parallax section.no_background{
			padding: 0px;
			}
		
		<?php } ?>
		<?php if (!empty($infographer_options['menu_color']) || !empty($infographer_options['menu_fontsize']) || !empty($infographer_options['menu_lineheight']) || !empty($infographer_options['menu_fontstyle']) || !empty($infographer_options['menu_fontweight']) || $infographer_options['menu_google_fonts'] != "-1") { ?>
			nav.main_menu ul li > a{
			<?php if (!empty($infographer_options['menu_color'])) { ?> color: <?php echo esc_attr($infographer_options['menu_color']);  ?>; <?php } ?>
			<?php if($infographer_options['menu_google_fonts'] != "-1"){ ?>
				font-family: <?php echo str_replace('+', ' ', $infographer_options['menu_google_fonts']); ?>, sans-serif;
			<?php } ?>
			<?php if (!empty($infographer_options['menu_fontsize'])) { ?> font-size: <?php echo intval($infographer_options['menu_fontsize']);  ?>px; <?php } ?>
			<?php if (!empty($infographer_options['menu_lineheight'])) { ?> line-height: <?php echo intval($infographer_options['menu_lineheight']);  ?>px; <?php } ?>
			<?php if (!empty($infographer_options['menu_fontstyle'])) { ?> font-style: <?php echo esc_attr($infographer_options['menu_fontstyle']);  ?>; <?php } ?>
			<?php if (!empty($infographer_options['menu_fontweight'])) { ?> font-weight: <?php echo esc_attr($infographer_options['menu_fontweight']);  ?>; <?php } ?>
			
			}
		<?php } ?>
		<?php if (!empty($infographer_options['menu_hovercolor']) || !empty($infographer_options['menu_hoverbackgroundcolor'])) { ?>
			nav.main_menu > ul > li.active > a,
			nav.main_menu > ul > li.has_sub:hover > a,
			nav.main_menu > ul > li:hover > a{
			color: <?php echo esc_attr($infographer_options['menu_hovercolor']);  ?>;
			background-color: <?php echo esc_attr($infographer_options['menu_hoverbackgroundcolor']);  ?>;
			}
		<?php } ?>
		
		<?php if (!empty($infographer_options['menu_lineheight'])){ ?>
			.header_right_widget{
			line-height: <?php echo intval($infographer_options['menu_lineheight']);  ?>px;
			}
		
		<?php } ?>
		
		<?php if(!empty($infographer_options['dropdown_color']) || !empty($infographer_options['dropdown_fontsize']) || !empty($infographer_options['dropdown_lineheight']) || !empty($infographer_options['dropdown_fontstyle']) || !empty($infographer_options['dropdown_fontweight']) || $infographer_options['dropdown_google_fonts'] != "-1"){ ?>
			.drop_down .second .inner2 > ul > li > a{
			<?php if (!empty($infographer_options['dropdown_color'])) { ?> color: <?php echo esc_attr($infographer_options['dropdown_color']); ?>; <?php } ?>
			<?php if($infographer_options['dropdown_google_fonts'] != "-1"){ ?>
				font-family: <?php echo str_replace('+', ' ', $infographer_options['dropdown_google_fonts']) ?>, sans-serif;
			<?php } ?>
			<?php if (!empty($infographer_options['dropdown_fontsize'])) { ?> font-size: <?php echo intval($infographer_options['dropdown_fontsize']);  ?>px; <?php } ?>
			<?php if (!empty($infographer_options['dropdown_lineheight'])) { ?> line-height: <?php echo intval($infographer_options['dropdown_lineheight']);  ?>px; <?php } ?>
			<?php if (!empty($infographer_options['dropdown_fontstyle'])) { ?> font-style: <?php echo esc_attr($infographer_options['dropdown_fontstyle']);  ?>;  <?php } ?>
			<?php if (!empty($infographer_options['dropdown_fontweight'])) { ?>font-weight: <?php echo esc_attr($infographer_options['dropdown_fontweight']);  ?>; <?php } ?>
			}
		<?php } ?>
		<?php if (!empty($infographer_options['dropdown_hovercolor'])) { ?>
			.drop_down .second .inner2 > ul > li:hover > a{
			color: <?php echo esc_attr($infographer_options['dropdown_hovercolor']);  ?>;
			}
		<?php } ?>
		<?php if(!empty($infographer_options['dropdown_color_thirdlvl']) || !empty($infographer_options['dropdown_fontsize_thirdlvl']) || !empty($infographer_options['dropdown_lineheight_thirdlvl']) || !empty($infographer_options['dropdown_fontstyle_thirdlvl']) || !empty($infographer_options['dropdown_fontweight_thirdlvl']) || $infographer_options['dropdown_google_fonts_thirdlvl'] != "-1"){ ?>
			.drop_down .second .inner2 ul li.sub ul li a
			{
			<?php if (!empty($infographer_options['dropdown_color_thirdlvl'])) { ?> color: <?php echo esc_attr($infographer_options['dropdown_color_thirdlvl']);  ?> !important;  <?php } ?>
			<?php if($infographer_options['dropdown_google_fonts_thirdlvl'] != "-1"){ ?>
				font-family: <?php echo str_replace('+', ' ', $infographer_options['dropdown_google_fonts_thirdlvl']) ?>, sans-serif !important;
			<?php } ?>
			<?php if (!empty($infographer_options['dropdown_fontsize_thirdlvl'])) { ?> font-size: <?php echo intval($infographer_options['dropdown_fontsize_thirdlvl']);  ?>px !important;  <?php } ?>
			<?php if (!empty($infographer_options['dropdown_lineheight_thirdlvl'])) { ?> line-height: <?php echo intval($infographer_options['dropdown_lineheight_thirdlvl']);  ?>px !important;  <?php } ?>
			<?php if (!empty($infographer_options['dropdown_fontstyle_thirdlvl'])) { ?> font-style: <?php echo esc_attr($infographer_options['dropdown_fontstyle_thirdlvl']);  ?> !important;   <?php } ?>
			<?php if (!empty($infographer_options['dropdown_fontweight_thirdlvl'])) { ?> font-weight: <?php echo esc_attr($infographer_options['dropdown_fontweight_thirdlvl']);  ?> !important;  <?php } ?>
			}
		<?php } ?>
		<?php if (!empty($infographer_options['dropdown_hovercolor_thirdlvl'])) { ?>
			.drop_down .second .inner2 ul li.sub ul li:hover a{
			color: <?php echo esc_attr($infographer_options['dropdown_hovercolor_thirdlvl']);  ?> !important;
			}
		<?php } ?>
		
		
		
		<?php
		if (!empty($qode_options_lounge['background_color'])) {
			$bg_color = infographer_qode_hex2rgb($qode_options_lounge['background_color']);
			?>
			.header_inner {
			
			background-color: rgb(<?php echo esc_attr($bg_color[0]); ?>,<?php echo esc_attr($bg_color[1]); ?>,<?php echo esc_attr($bg_color[2]); ?>);
			background-color: rgba(<?php echo esc_attr($bg_color[0]); ?>,<?php echo esc_attr($bg_color[1]); ?>,<?php echo esc_attr($bg_color[2]); ?>,0.85);
			}
			<?php
		}
		?>
		
		<?php if (!empty($infographer_options['dropdown_background_color'])) {
			$dropdown_background_color = infographer_qode_hex2rgb($infographer_options['dropdown_background_color']);
			?>
			.drop_down .second .inner2, .drop_down .second .inner ul li ul {
			background-color: rgb(<?php echo esc_attr($dropdown_background_color[0]); ?>,<?php echo esc_attr($dropdown_background_color[1]); ?>,<?php echo esc_attr($dropdown_background_color[2]); ?>);
			background-color: rgba(<?php echo esc_attr($dropdown_background_color[0]); ?>,<?php echo esc_attr($dropdown_background_color[1]); ?>,<?php echo esc_attr($dropdown_background_color[2]); ?>,0.95);
			}
		<?php } ?>
		<?php if (!empty($infographer_options['content_menu_backgroundcolor'])) { ?>
			nav.content_menu{
			background-color: <?php echo esc_attr($infographer_options['content_menu_backgroundcolor']);  ?>;
			}
			nav.content_menu ul li .arrow{
			border-color: <?php echo esc_attr($infographer_options['content_menu_backgroundcolor']);  ?> transparent transparent transparent;
			}
		<?php } ?>
		
		<?php if (!empty($infographer_options['content_menu_color']) || !empty($infographer_options['content_menu_fontsize']) || !empty($infographer_options['content_menu_lineheight']) || !empty($infographer_options['content_menu_fontstyle']) || !empty($infographer_options['content_menu_fontweight']) || $infographer_options['content_menu_google_fonts'] != "-1") { ?>
			nav.content_menu ul li > a{
			<?php if (!empty($infographer_options['content_menu_color'])) { ?> color: <?php echo esc_attr($infographer_options['content_menu_color']);  ?>; <?php } ?>
			<?php if($infographer_options['content_menu_google_fonts'] != "-1"){ ?>
				font-family: <?php echo str_replace('+', ' ', $infographer_options['content_menu_google_fonts']); ?>, sans-serif;
			<?php } ?>
			<?php if (!empty($infographer_options['content_menu_fontsize'])) { ?> font-size: <?php echo intval($infographer_options['content_menu_fontsize']);  ?>px; <?php } ?>
			<?php if (!empty($infographer_options['content_menu_lineheight'])) { ?> line-height: <?php echo intval($infographer_options['content_menu_lineheight']);  ?>px; <?php } ?>
			<?php if (!empty($infographer_options['content_menu_fontstyle'])) { ?> font-style: <?php echo esc_attr($infographer_options['content_menu_fontstyle']);  ?>; <?php } ?>
			<?php if (!empty($infographer_options['content_menu_fontweight'])) { ?> font-weight: <?php echo esc_attr($infographer_options['content_menu_fontweight']);  ?>; <?php } ?>
			
			}
		<?php } ?>
		<?php if (!empty($infographer_options['content_menu_hovercolor'])) { ?>
			nav.content_menu > ul > li:hover > a{
			color: <?php echo esc_attr($infographer_options['content_menu_hovercolor']);  ?>;
			}
		<?php } ?>
		
		<?php if (!empty($infographer_options['content_menu_position']) && $infographer_options['content_menu_position'] == "left") { ?>
			nav.content_menu ul{
			text-align: <?php echo esc_attr($infographer_options['content_menu_position']);  ?>;
			}
			
			.content_menu .logo{
			position: relative;
			margin: 0px;
			left: 0px;
			}
		<?php } ?>
		
		<?php if (!empty($infographer_options['content_menu_lineheight'])) { ?>
			nav.content_menu .back_outer,
			nav.content_menu .back,
			nav.content_menu .nav_select_menu .nav_select_button{
			height: <?php echo intval($infographer_options['content_menu_lineheight']);  ?>px;
			}
		<?php } ?>
		
		<?php if ($infographer_options['header_fixed'] == "no") { ?>
			header{
			position: relative;
			}
			.content {
			margin: -3px 0px 0px 0px;
			padding-top: 0px;
			}
		
		<?php } ?>
		
		<?php if (!empty($infographer_options['footer_top_title_color'])) { ?>
			.footer_top h4{
			color: <?php echo esc_attr($infographer_options['footer_top_title_color']);  ?>;
			}
		<?php } ?>
		
		<?php if (!empty($infographer_options['footer_top_text_color'])) { ?>
			.footer_top ul li a, .footer_top a, .footer_top p {
			color: <?php echo esc_attr($infographer_options['footer_top_text_color']);  ?>;
			}
		<?php } ?>
		
		<?php if (!empty($infographer_options['footer_top_background_color'])) { ?>
			footer {
			background-color: <?php echo esc_attr($infographer_options['footer_top_background_color']);  ?>;
			}
		<?php } ?>
		
		<?php if (!empty($infographer_options['footer_bottom_background_color'])) { ?>
			.footer_bottom {
			background-color:<?php echo esc_attr($infographer_options['footer_bottom_background_color']);  ?>;
			}
		<?php } ?>
		
		<?php if (!empty($infographer_options['footer_bottom_text_color'])) { ?>
			.footer_bottom, .footer_bottom p, .footer_bottom p a{
			color:<?php echo esc_attr($infographer_options['footer_bottom_text_color']);  ?>;
			}
		<?php } ?>
		
		<?php
	}
	
	add_action( 'infographer_qode_action_style_dynamic', 'infographer_qode_add_style_dynamic' );
}

if ( ! function_exists( 'infographer_qode_add_style_dynamic_responsive' ) ) {
	function infographer_qode_add_style_dynamic_responsive() {
		$infographer_options = infographer_qode_return_global_options();
		?>
		
		<?php if ( ! empty( $infographer_options['parallax_minheight'] ) ) { ?>
			
			@media only screen and (min-width: 480px) and (max-width: 768px){
			.parallax section{
			min-height: <?php echo intval( $infographer_options['parallax_minheight'] ); ?>px;
			}
			}
			
			@media only screen and (max-width: 480px){
			.parallax section{
			min-height: <?php echo intval( $infographer_options['parallax_minheight'] ); ?>px;
			}
			}
		
		<?php } ?>
		
		<?php
	}
	
	add_action( 'infographer_qode_action_style_dynamic_responsive', 'infographer_qode_add_style_dynamic_responsive' );
}

if ( ! function_exists( 'infographer_qode_add_default_dynamic' ) ) {
	function infographer_qode_add_default_dynamic() {
		$infographer_options = infographer_qode_return_global_options();
		?>
		
		<?php if($infographer_options['second_color'] != ""){
			$trackColor = $infographer_options['second_color'];
		}else{
			$trackColor = "#f4f4f4";
		}
		
		if($infographer_options['first_color'] != ""){
			$barColor = $infographer_options['first_color'];
		}else{
			$barColor = '#009CFF';
		}
		?>
		
		<?php if($infographer_options['menu_lineheight'] != ""){
			$line_height = $infographer_options['menu_lineheight'];
		}else{
			$line_height = 80;
		}
		
		if($infographer_options['content_menu_lineheight'] != ""){
			$content_line_height = $infographer_options['content_menu_lineheight'];
		}else{
			$content_line_height = 50;
		}
		?>
		var line_height = <?php echo intval( $line_height ); ?>;
		var logo_height; // it's value is calculated in window load function
		var contentTop = <?php echo intval( $line_height ); ?>;
		var content_line_height = <?php echo intval( $content_line_height ); ?>;
		
		function headerSize(scroll){
		"use strict";
		
		if((line_height - scroll) > 50){
		$j('header .logo').css({'top': (line_height - scroll)/2});
		$j('header .header_inner nav.main_menu > ul > li > a').css({'line-height': line_height - scroll +'px'});
		$j('header .logo').css({'height': line_height - scroll +'px'});
		$j('header .header_inner .header_right_widget').css({'line-height': line_height - scroll+'px'});
		$j('header .header_inner .drop_down .second').css({'top': line_height - scroll+'px'});
		$j('header .header_inner .drop_down2 .second').css({'top': line_height - scroll+'px'});
		
		}else if((line_height - scroll) <= 50){
		$j('header .logo').css({'top': 50/2});
		$j('header').addClass('move_menu');
		$j('header .header_inner nav.main_menu > ul > li > a').css({'line-height': '50px'});
		$j('header .logo').css({'height': '50px'});
		$j('header .header_inner .header_right_widget').css({'line-height': '50px'});
		$j('header .header_inner .drop_down .second').css({'top': '50px'});
		$j('header .header_inner .drop_down2 .second').css({'top': '50px'});
		
		}else if(scroll === 0){
		$j('header .logo').stop().animate({'top': line_height/2+'px'},100);
		$j('header .header_inner nav.main_menu > ul > li > a').css({'line-height': line_height+'px'});
		$j('header .logo').css({'height': line_height+'px'});
		$j('header .header_inner .header_right_widget').css({'line-height': line_height+'px'});
		$j('header .header_inner .drop_down .second').css({'top': line_height+'px'});
		$j('header .header_inner .drop_down2 .second').css({'top': line_height+'px'});
		$j('header').removeClass('move_menu');
		
		}
		
		if((line_height - scroll < logo_height) && (line_height - scroll) > 50 && logo_height > 45){
		$j('header .logo a').height(line_height - scroll - 5);
		}else if((line_height - scroll < logo_height) && (line_height - scroll) < 50 && logo_height > 45){
		$j('header .logo a').height(50 - 5);
		}else if(scroll === 0 && logo_height > 45){
		$j('header .logo a').height(logo_height);
		}
		
		}
		
		function setLogoHeightOnLoad(){
		"use strict";
		
		//logo in header
		$j('header .logo').css('top', line_height/2);
		
		if(line_height - logo_height >= 10){
		$j('header .logo a').height(logo_height);
		}else if(line_height - logo_height < 10){
		$j('header .logo a').height(line_height - 5);
		}
		$j('header .logo a').css('visibility','visible');
		
		//logo in content menu
		$j('.content_menu .logo').css('top', content_line_height/2);
		
		if(content_line_height - logo_height >= 10){
		$j('.content_menu .logo a').height(logo_height);
		}else if(content_line_height - logo_height < 10){
		$j('.content_menu .logo a').height(content_line_height - 5);
		}
		$j('.content_menu .logo a').css('visibility','visible');
		
		$j('.logo img').css('height','100%');
		}
		
		function ajaxSubmitCommentForm(){
		"use strict";
		
		var options = {
		success: function(){
		$j("#commentform textarea").val("");
		$j("#commentform .success p").text("<?php esc_html_e('Comment has been sent!','infographer'); ?>");
		}
		};
		
		$j('#commentform').submit(function() {
		$j(this).find('input[type="submit"]').next('.success').remove();
		$j(this).find('input[type="submit"]').after('<div class="success"><p></p></div>');
		$j(this).ajaxSubmit(options);
		return false;
		});
		}
		
		<?php if($infographer_options['enable_google_map'] != ""){ ?>
			
			var geocoder;
			var map;
			
			function initialize() {
			"use strict";
			
			geocoder = new google.maps.Geocoder();
			var latlng = new google.maps.LatLng(-34.397, 150.644);
			var myOptions = {
			zoom: 12,
			center: latlng,
			zoomControl: true,
			zoomControlOptions: {
			style: google.maps.ZoomControlStyle.SMALL,
			position: google.maps.ControlPosition.RIGHT_CENTER
			},
			scaleControl: false,
			scaleControlOptions: {
			position: google.maps.ControlPosition.LEFT_CENTER
			},
			streetViewControl: false,
			streetViewControlOptions: {
			position: google.maps.ControlPosition.LEFT_CENTER
			},
			panControl: false,
			panControlOptions: {
			position: google.maps.ControlPosition.LEFT_CENTER
			},
			mapTypeControl: false,
			mapTypeControlOptions: {
			mapTypeIds: [google.maps.MapTypeId.ROADMAP, 'pink_parks'],
			style: google.maps.MapTypeControlStyle.HORIZONTAL_BAR,
			position: google.maps.ControlPosition.LEFT_CENTER
			},
			mapTypeId: google.maps.MapTypeId.ROADMAP
			};
			map = new google.maps.Map(document.getElementById("map_canvas"), myOptions);
			}
			
			function codeAddress(data) {
			"use strict";
			
			var contentString = '<div id="content"><div id="siteNotice"></div><div id="bodyContent"><p>'+data+'</p></div></div>';
			var infowindow = new google.maps.InfoWindow({
			content: contentString
			});
			geocoder.geocode( { 'address': data}, function(results, status) {
			if (status === google.maps.GeocoderStatus.OK) {
			map.setCenter(results[0].geometry.location);
			var marker = new google.maps.Marker({
			map: map,
			position: results[0].geometry.location,
			<?php if(isset($infographer_options['google_maps_pin_image'])){ ?>
				icon:  '<?php echo esc_attr( $infographer_options['google_maps_pin_image'] ); ?>',
			<?php } ?>
			title: data['store_title']
			});
			google.maps.event.addListener(marker, 'click', function() {
			infowindow.open(map,marker);
			});
			//infowindow.open(map,marker);
			}
			});
			}
			
			var $j = jQuery.noConflict();
			
			$j(document).ready(function() {
			"use strict";
			
			showContactMap();
			
			<?php
			$has_ajax = false;
			
			$qode_animation = "";
			if (isset($_SESSION['qode_animation']))
				$qode_animation = $_SESSION['qode_animation'];
			
			if (($infographer_options['page_transitions'] != "0") && (empty($qode_animation) || ($qode_animation != "no")))
				$has_ajax = true;
			elseif (!empty($qode_animation) && ($qode_animation != "no"))
				$has_ajax = true;
			
			if ($has_ajax) :
				?>
				balanceNavArrows();
			<?php endif; ?>
			
			});
			<?php
		}
		?>
		
		function showContactMap() {
		"use strict";
		
		if($j("#map_canvas").length > 0 && typeof google === 'object'){
		initialize();
		codeAddress('<?php if ( isset( $infographer_options['google_maps_address'] ) ) { echo esc_attr( $infographer_options['google_maps_address'] ); } ?>');
		}
		}
		
		var no_ajax_pages = [];
		var root = '<?php echo esc_url( home_url( '/' ) ); ?>';
		<?php if ( $infographer_options['parallax_speed'] != '' ) { ?>
			var parallax_speed = <?php echo esc_attr( $infographer_options['parallax_speed'] ); ?>;
		<?php } else { ?>
			var parallax_speed = 1;
		<?php } ?>
		
		<?php if ( $infographer_options['header_hide'] == 'no' && $infographer_options['header_fixed'] == 'yes' ) { ?>
			var header_height = 50;
		<?php } else { ?>
			var header_height = 0;
		<?php } ?>
		
		<?php
		$pages = get_pages();
		foreach ( $pages as $page ) {
			if ( get_post_meta( $page->ID, "qode_show-animation", true ) == "no_animation" ) : ?>
				no_ajax_pages.push('<?php echo get_permalink( $page->ID ) ?>');
			<?php
			endif;
		}
		if ( isset( $infographer_options['internal_no_ajax_links'] ) ) {
			foreach ( explode( ',', $infographer_options['internal_no_ajax_links'] ) as $no_ajax_link ) { ?>
				no_ajax_pages.push('<?php echo trim( $no_ajax_link ); ?>');
				<?php
			}
		}
		?>
		
		<?php
	}
	
	add_action( 'infographer_qode_action_default_dynamic', 'infographer_qode_add_default_dynamic' );
}