<?php

if ( ! function_exists( 'infographer_qode_return_toolbar_variable' ) ) {
	function infographer_qode_return_toolbar_variable() {
		global $qode_toolbar;
		
		return $qode_toolbar;
	}
}

if ( ! function_exists( 'infographer_qode_return_global_options' ) ) {
	function infographer_qode_return_global_options() {
		global $qode_options_infographer;
		
		return $qode_options_infographer;
	}
}

if ( ! function_exists( 'infographer_qode_return_global_wp_query' ) ) {
	function infographer_qode_return_global_wp_query() {
		global $wp_query;
		
		return $wp_query;
	}
}

if ( ! function_exists( 'infographer_qode_get_module_part' ) ) {
	function infographer_qode_get_module_part( $module ) {
		return $module;
	}
}

if ( ! function_exists( 'infographer_qode_return_page_background_style' ) ) {
	function infographer_qode_return_page_background_style( $type = '' ) {
		$global_options = infographer_qode_return_global_options();
		$page_id        = infographer_qode_get_page_id();
		
		$background_color = get_post_meta( $page_id, "qode_page-background-color", true );
		
		if ( $type === 'blog' && $global_options['blog_background_color'] != "" && empty( $background_color ) ) {
			$background_color = $global_options['blog_background_color'];
		}
		
		if ( $type === 'portfolio' && $global_options['portfolio_background_color'] != "" && empty( $background_color ) ) {
			$background_color = $global_options['portfolio_background_color'];
		}
		
		return $background_color;
	}
}

if ( ! function_exists( 'infographer_qode_inline_page_background_style' ) ) {
	function infographer_qode_inline_page_background_style( $type = '' ) {
		$style = array();
		
		$background_color = infographer_qode_return_page_background_style( $type );
		if ( ! empty( $background_color ) ) {
			$style[] = 'background-color:' . esc_attr( $background_color );
		}
		
		if ( ! empty( $style ) ) {
			echo infographer_qode_get_inline_style( $style );
		}
	}
}

if ( ! function_exists( 'infographer_qode_get_sidebar_layout' ) ) {
	function infographer_qode_get_sidebar_layout( $default_value = true ) {
		$global_options    = infographer_qode_return_global_options();
		$qode_page_id      = infographer_qode_get_page_id();
		$show_sidebar_meta = get_post_meta( $qode_page_id, "qode_show-sidebar", true );
		$sidebar           = $default_value ? $global_options['category_blog_sidebar'] : '';
		
		if ( ! empty( $show_sidebar_meta ) ) {
			$sidebar = $show_sidebar_meta;
		}
		
		if ( is_singular( 'post' ) && empty( $show_sidebar_meta ) && isset( $global_options['blog_single_sidebar'] ) ) {
			$sidebar = $global_options['blog_single_sidebar'];
		}
		
		if ( ! empty( $sidebar ) && ! is_active_sidebar( infographer_qode_get_sidebar_name() ) ) {
			$sidebar = '';
		}
		
		return $sidebar;
	}
}

if ( ! function_exists( 'infographer_qode_get_sidebar_name' ) ) {
	function infographer_qode_get_sidebar_name() {
		$infographer_options = infographer_qode_return_global_options();
		$page_id      = infographer_qode_get_page_id();
		
		if ( get_post_meta( $page_id, 'qode_choose-sidebar', true ) != "" ) {
			$sidebar = get_post_meta( $page_id, 'qode_choose-sidebar', true );
		} else {
			if ( is_singular( "post" ) ) {
				if ( $infographer_options['blog_single_sidebar_custom_display'] != "" ) {
					$sidebar = $infographer_options['blog_single_sidebar_custom_display'];
				} else {
					$sidebar = 'sidebar';
				}
			} else {
				$sidebar = 'sidebar_page';
			}
		}
		
		return $sidebar;
	}
}

if ( ! function_exists( 'infographer_qode_init_global_option' ) ) {
	function infographer_qode_init_global_option() {
		
		if ( ! infographer_qode_is_core_installed() ) {
			global $qode_options_infographer;
			
			$qode_options_infographer = array( // intitialize the '$qode_options_infographer' array with the following key => value pairs:
			                                   "reset_to_defaults" => '',
			                                   "number_of_chars" => 45,
			                                   "first_color" => '',
			                                   "second_color" => '',
			                                   "background_color" => '',
			                                   "background_color_box" => '',
			                                   "highlight_color" => '',
			                                   "selection_color" => '',
			                                   "favicon_image" => QODE_ROOT."/img/favicon.ico",
			                                   "background_image" => '',
			                                   "patern_background_image" => '',
			                                   "google_fonts" => '-1',
			                                   "page_transitions" => '0',
			                                   "boxed" => 'no',
			                                   "responsiveness" => 'yes',
			                                   "show_back_button" => 'no',
			                                   "delay" => 'no',
			                                   "parallax_speed" => '1',
			                                   "parallax_minheight" => '300',
			                                   "parallax_onoff" => 'on',
			                                   "internal_no_ajax_links" => '',
			                                   "custom_css" => '',
			                                   "custom_js" => '',
			                                   "meta_keywords" => '',
			                                   "meta_description" => '',
			                                   "disable_qode_seo" => 'no',
			                                   "h1_color" => '',
			                                   "h1_google_fonts" => '-1',
			                                   "h1_fontsize" => '',
			                                   "h1_lineheight" => '',
			                                   "h1_fontstyle" => '',
			                                   "h1_fontweight" => '',
			                                   "h2_color" => '',
			                                   "h2_google_fonts" => '-1',
			                                   "h2_fontsize" => '',
			                                   "h2_lineheight" => '',
			                                   "h2_fontstyle" => '',
			                                   "h2_fontweight" => '',
			                                   "h3_color" => '',
			                                   "h3_google_fonts" => '-1',
			                                   "h3_fontsize" => '',
			                                   "h3_lineheight" => '',
			                                   "h3_fontstyle" => '',
			                                   "h3_fontweight" => '',
			                                   "h4_color" => '',
			                                   "h4_google_fonts" => '-1',
			                                   "h4_fontsize" => '',
			                                   "h4_lineheight" => '',
			                                   "h4_fontstyle" => '',
			                                   "h4_fontweight" => '',
			                                   "h5_color" => '',
			                                   "h5_google_fonts" => '-1',
			                                   "h5_fontsize" => '',
			                                   "h5_lineheight" => '',
			                                   "h5_fontstyle" => '',
			                                   "h5_fontweight" => '',
			                                   "h6_color" => '',
			                                   "h6_google_fonts" => '-1',
			                                   "h6_fontsize" => '',
			                                   "h6_lineheight" => '',
			                                   "h6_fontstyle" => '',
			                                   "h6_fontweight" => '',
			                                   "text_color" => '',
			                                   "text_google_fonts" => '-1',
			                                   "text_fontsize" => '',
			                                   "text_lineheight" => '',
			                                   "text_fontstyle" => '',
			                                   "text_fontweight" => '',
			                                   "text_margin" => '',
			                                   "link_color" => '',
			                                   "link_hovercolor" => '',
			                                   "link_fontstyle" => '',
			                                   "link_fontweight" => '',
			                                   "link_fontdecoration" => '',
			                                   "page_title_color" => '',
			                                   "page_title_google_fonts" => '-1',
			                                   "page_title_fontsize" => '',
			                                   "page_title_lineheight" => '',
			                                   "page_title_fontstyle" => '',
			                                   "page_title_fontweight" => '',
			                                   "menu_color" => '',
			                                   "menu_hovercolor" => '',
			                                   "menu_hoverbackgroundcolor" => '',
			                                   "menu_google_fonts" => '-1',
			                                   "menu_fontsize" => '',
			                                   "menu_lineheight" => '',
			                                   "menu_fontstyle" => '',
			                                   "menu_fontweight" => '',
			                                   "header_hide" => 'no',
			                                   "header_in_grid" => 'no',
			                                   "header_fixed" => 'yes',
			                                   "header_widget_area" => 'yes',
			                                   "header_background_color" => '',
			                                   "logo_image" => QODE_ROOT."/img/logo.png",
			                                   "dropdown_background_color" => '',
			                                   "menu_position" => 'left',
			                                   "dropdown_color" => '',
			                                   "dropdown_hovercolor" => '',
			                                   "dropdown_google_fonts" => '-1',
			                                   "dropdown_fontsize" => '',
			                                   "dropdown_lineheight" => '',
			                                   "dropdown_fontstyle" => '',
			                                   "dropdown_fontweight" => '',
			                                   "dropdown_color_thirdlvl" => '',
			                                   "dropdown_hovercolor_thirdlvl" => '',
			                                   "dropdown_google_fonts_thirdlvl" => '-1',
			                                   "dropdown_fontsize_thirdlvl" => '',
			                                   "dropdown_lineheight_thirdlvl" => '',
			                                   "dropdown_fontstyle_thirdlvl" => '',
			                                   "dropdown_fontweight_thirdlvl" => '',
			                                   "header_separator_thickness" => '',
			                                   "responsive_title_image" => '',
			                                   "fixed_title_image" => '',
			                                   "title_image" => '',
			                                   "title_height" => '',
			                                   "page_title_position" => '0',
			                                   "title_in_grid" => 'yes',
			                                   "footer_widget_area" => 'yes',
			                                   "footer_text" => 'yes',
			                                   "footer_top_title_color" => '',
			                                   "footer_top_text_color" => '',
			                                   "footer_top_background_color" => '',
			                                   "footer_bottom_text_color" => '',
			                                   "footer_bottom_background_color" => '',
			                                   "content_menu_color" => '',
			                                   "content_menu_hovercolor" => '',
			                                   "content_menu_backgroundcolor" => '',
			                                   "content_menu_google_fonts" => '-1',
			                                   "content_menu_fontsize" => '',
			                                   "content_menu_lineheight" => '',
			                                   "content_menu_fontstyle" => '',
			                                   "content_menu_fontweight" => '',
			                                   "content_menu_position" => '0',
			                                   "separator_thickness" => '',
			                                   "separator_topmargin" => '',
			                                   "separator_bottommargin" => '',
			                                   "separator_pattern_color" => '',
			                                   "separator_pattern_topmargin" => '',
			                                   "separator_pattern_bottommargin" => '',
			                                   "button_title_color" => '',
			                                   "button_title_hovercolor" => '',
			                                   "button_title_google_fonts" => '-1',
			                                   "button_title_fontsize" => '',
			                                   "button_title_lineheight" => '',
			                                   "button_title_fontstyle" => '',
			                                   "button_title_fontweight" => '',
			                                   "button_size" => '',
			                                   "button_backgroundcolor" => '',
			                                   "button_backgroundhovercolor" => '',
			                                   "message_title_color" => '',
			                                   "message_title_google_fonts" => '-1',
			                                   "message_backgroundcolor" => '',
			                                   "blockquote_font_color" => '',
			                                   "blockquote_background_color" => '',
			                                   "portfolio_background_color" => '',
			                                   "portfolio_style" => '1',
			                                   "blog_background_color" => '',
			                                   "pagination" => '1',
			                                   "blog_style" => '1',
			                                   "category_blog_sidebar" => 'default',
			                                   "blog_hide_comments" => 'no',
			                                   "back_to_previous" => 'no',
			                                   "number_of_chars" => '45',
			                                   "receive_mail" => '',
			                                   "enable_contact_form" => 'no',
			                                   "hide_contact_form_website" => 'no',
			                                   "email_from" => '',
			                                   "email_subject" => '',
			                                   "use_recaptcha" => 'no',
			                                   "recaptcha_public_key" => '',
			                                   "recaptcha_private_key" => '',
			                                   "contact_heading_above" => '',
			                                   "contact_text_above" => '',
			                                   "enable_google_map" => 'no',
			                                   "google_maps_pin_image" => QODE_ROOT."/img/pin.png",
			                                   "google_maps_address" => '',
			                                   "google_maps_iframe" => '',
			                                   "404_title" => '',
			                                   "404_subtitle" => '',
			                                   "404_text" => '',
			                                   "404_backlabel" => '',
			                                   "enable_social_share" => 'no',
			                                   "enable_facebook_share" => 'no',
			                                   "enable_twitter_share" => 'no',
			                                   "enable_google_plus" => 'no',
			                                   "facebook_icon" => '',
			                                   "twitter_icon" => '',
			                                   "google_plus_icon" => '',
			                                   "twitter_via" => ''
			);
		}
	}
	
	add_action( 'after_setup_theme', 'infographer_qode_init_global_option' );
}

if ( ! function_exists( 'infographer_qode_is_core_installed' ) ) {
	/**
	 * Function that checks if Core plugin is installed
	 * @return bool
	 */
	function infographer_qode_is_core_installed() {
		return class_exists( 'InfographerCore' );
	}
}

if ( ! function_exists( 'infographer_qode_get_blog_query_posts' ) ) {
	function infographer_qode_get_blog_query_posts() {
		$qode_page_id             = infographer_qode_get_page_id();
		$category                 = get_post_meta( $qode_page_id, "qode_choose-blog-category", true );
		$number_of_posts_per_page = get_post_meta( $qode_page_id, "qode_show-posts-per-page", true );
		$post_number              = ! empty( $number_of_posts_per_page ) ? esc_attr( $number_of_posts_per_page ) : esc_attr( get_option( 'posts_per_page' ) );
		
		if ( get_query_var( 'paged' ) ) {
			$paged = get_query_var( 'paged' );
		} elseif ( get_query_var( 'page' ) ) {
			$paged = get_query_var( 'page' );
		} else {
			$paged = 1;
		}
		
		$query_array = array(
			'post_status'    => 'publish',
			'post_type'      => 'post',
			'paged'          => $paged,
			'cat'            => $category,
			'posts_per_page' => $post_number
		);
		
		$blog_query = new WP_Query( $query_array );
		if ( is_archive() ) {
			global $wp_query;
			$blog_query = $wp_query;
		}
		
		return $blog_query;
	}
}

if ( ! function_exists( 'infographer_qode_wp_link_pages' ) ) {
	function infographer_qode_wp_link_pages() {
		wp_link_pages();
	}
}

if ( ! function_exists( 'infographer_qode_wp_link_pages_exist' ) ) {
	function infographer_qode_wp_link_pages_exist() {
		$args_pages = array(
			'echo' => 0
		);
		
		return wp_link_pages( $args_pages );
	}
}

if ( ! function_exists( 'infographer_qode_post_has_read_more' ) ) {
	/**
	 * Function that checks if current post has read more tag set
	 * @return int position of read more tag text. It will return false if read more tag isn't set
	 */
	function infographer_qode_post_has_read_more() {
		global $post;
		
		return strpos( $post->post_content, '<!--more-->' );
	}
}

if ( ! function_exists( 'infographer_qode_get_blog_pagination' ) ) {
	function infographer_qode_get_blog_pagination( $qode_blog_query ) {
		$global_options = infographer_qode_return_global_options();
		
		if ( isset( $global_options['pagination'] ) && $global_options['pagination'] != "0" ) {
			
			if ( isset( $global_options['blog_page_range'] ) && $global_options['blog_page_range'] != "" ) {
				$blog_page_range = $global_options['blog_page_range'];
			} else {
				$blog_page_range = $qode_blog_query->max_num_pages;
			}
			
			if ( get_query_var( 'paged' ) ) {
				$paged = get_query_var( 'paged' );
			} elseif ( get_query_var( 'page' ) ) {
				$paged = get_query_var( 'page' );
			} else {
				$paged = 1;
			}
			
			infographer_qode_get_blog_pagination_html( $qode_blog_query->max_num_pages, $blog_page_range, $paged );
		}
	}
}

if ( ! function_exists( 'infographer_qode_get_blog_pagination_html' ) ) {
	function infographer_qode_get_blog_pagination_html( $pages = '', $range = 4, $paged = 1 ) {
		$showitems = $range + 1;
		
		if ( $pages == '' ) {
			global $wp_query;
			$pages = $wp_query->max_num_pages;
			if ( ! $pages ) {
				$pages = 1;
			}
		}
		
		if ( 1 != $pages ) {
			echo "<div class='pagination'><ul>";
			if ( $paged > 2 && $paged > $range + 1 && $showitems < $pages ) {
				echo "<li class='first'><a href='" . get_pagenum_link( 1 ) . "'>&laquo;" . esc_html__( ' First', 'infographer' ) . "</a></li>";
			}
			echo "<li class='prev";
			if ( $paged > 2 && $paged > $range + 1 && $showitems < $pages ) {
				echo " prev_first";
			}
			echo "'><a href='" . get_pagenum_link( $paged - 1 ) . "'></a></li>";
			
			for ( $i = 1; $i <= $pages; $i ++ ) {
				if ( 1 != $pages && ( ! ( $i >= $paged + $range + 1 || $i <= $paged - $range - 1 ) || $pages <= $showitems ) ) {
					echo esc_attr( $paged == $i ) ? "<li class='active'><span>" . $i . "</span></li>" : "<li><a href='" . get_pagenum_link( $i ) . "' class='inactive'>" . $i . "</a></li>";
				}
			}
			
			echo "<li class='next";
			if ( $paged < $pages - 1 && $paged + $range - 1 < $pages && $showitems < $pages ) {
				echo " next_last";
			}
			echo "'><a href=\"";
			if ( $pages > $paged ) {
				echo get_pagenum_link( $paged + 1 );
			} else {
				echo get_pagenum_link( $paged );
			}
			echo "\"></a></li>";
			
			if ( $paged < $pages - 1 && $paged + $range - 1 < $pages && $showitems < $pages ) {
				echo "<li class='last'><a href='" . get_pagenum_link( $pages ) . "'>" . esc_html__( 'Last ', 'infographer' ) . "&raquo;</a></li>";
			}
			echo "</ul></div><div class='pagination-blog-wp'>" . get_the_posts_pagination() . "</div>";
		}
	}
}

if ( ! function_exists( 'infographer_qode_is_comments_enabled' ) ) {
	function infographer_qode_is_comments_enabled( $is_blog = true ) {
		$global_options = infographer_qode_return_global_options();
		
		$is_disabled = "";
		
		if ( isset( $global_options['blog_hide_comments'] ) && $is_blog ) {
			$is_disabled = $global_options['blog_hide_comments'];
		}
		
		if ( ! comments_open() ) {
			$is_disabled = 'yes';
		}
		
		return $is_disabled !== 'yes';
	}
}

if ( ! function_exists( 'infographer_qode_get_comments_template' ) ) {
	function infographer_qode_get_comments_template( $is_full_width = false, $is_blog = true ) {
		
		if ( infographer_qode_is_comments_enabled( $is_blog ) ) { ?>
			<?php if( $is_full_width ) { ?>
				<div class="container">
				<div class="container_inner">
			<?php } ?>
			<?php comments_template( '', true ); ?>
			<?php if( $is_full_width ) { ?>
				</div>
				</div>
			<?php } ?>
		<?php }
	}
}

if ( ! function_exists( 'infographer_qode_inline_style' ) ) {
	/**
	 * Function that echoes generated style attribute
	 *
	 * @param $value string | array attribute value
	 *
	 * @see infographer_qode_get_inline_style()
	 */
	function infographer_qode_inline_style( $value ) {
		echo infographer_qode_get_inline_style( $value );
	}
}

if ( ! function_exists( 'infographer_qode_get_inline_style' ) ) {
	/**
	 * Function that generates style attribute and returns generated string
	 *
	 * @param $value string | array value of style attribute
	 *
	 * @return string generated style attribute
	 *
	 * @see infographer_qode_get_inline_style()
	 */
	function infographer_qode_get_inline_style( $value ) {
		return infographer_qode_get_inline_attr( $value, 'style', ';' );
	}
}

if ( ! function_exists( 'infographer_qode_class_attribute' ) ) {
	/**
	 * Function that echoes class attribute
	 *
	 * @param $value string value of class attribute
	 *
	 * @see infographer_qode_get_class_attribute()
	 */
	function infographer_qode_class_attribute( $value ) {
		echo infographer_qode_get_class_attribute( $value );
	}
}

if ( ! function_exists( 'infographer_qode_get_class_attribute' ) ) {
	/**
	 * Function that returns generated class attribute
	 *
	 * @param $value string value of class attribute
	 *
	 * @return string generated class attribute
	 *
	 * @see infographer_qode_get_inline_attr()
	 */
	function infographer_qode_get_class_attribute( $value ) {
		return infographer_qode_get_inline_attr( $value, 'class', ' ' );
	}
}

if ( ! function_exists( 'infographer_qode_get_inline_attr' ) ) {
	/**
	 * Function that generates html attribute
	 *
	 * @param $value string | array value of html attribute
	 * @param $attr string name of html attribute to generate
	 * @param $glue string glue with which to implode $attr. Used only when $attr is array
	 * @param $allow_zero_values boolean allow data to have zero value
	 *
	 * @return string generated html attribute
	 */
	function infographer_qode_get_inline_attr( $value, $attr, $glue = '', $allow_zero_values = false ) {
		if ( $allow_zero_values ) {
			if ( $value !== '' ) {
				
				if ( is_array( $value ) && count( $value ) ) {
					$properties = implode( $glue, $value );
				} elseif ( $value !== '' ) {
					$properties = $value;
				}
				
				return $attr . '="' . esc_attr( $properties ) . '"';
			}
		} else {
			if ( ! empty( $value ) ) {
				
				if ( is_array( $value ) && count( $value ) ) {
					$properties = implode( $glue, $value );
				} elseif ( $value !== '' ) {
					$properties = $value;
				}
				
				return $attr . '="' . esc_attr( $properties ) . '"';
			}
		}
		
		return '';
	}
}

if ( ! function_exists( 'infographer_qode_inline_attr' ) ) {
	/**
	 * Function that generates html attribute
	 *
	 * @param $value string | array value of html attribute
	 * @param $attr string name of html attribute to generate
	 * @param $glue string glue with which to implode $attr. Used only when $attr is array
	 *
	 * @return string generated html attribute
	 */
	function infographer_qode_inline_attr( $value, $attr, $glue = '' ) {
		echo infographer_qode_get_inline_attr( $value, $attr, $glue );
	}
}

if ( ! function_exists( 'infographer_qode_get_inline_attrs' ) ) {
	/**
	 * Generate multiple inline attributes
	 *
	 * @param $attrs
	 *
	 * @return string
	 */
	function infographer_qode_get_inline_attrs( $attrs, $allow_zero_values = false ) {
		$output = '';
		
		if ( is_array( $attrs ) && count( $attrs ) ) {
			if ( $allow_zero_values ) {
				foreach ( $attrs as $attr => $value ) {
					$output .= ' ' . infographer_qode_get_inline_attr( $value, $attr, '', true );
				}
			} else {
				foreach ( $attrs as $attr => $value ) {
					$output .= ' ' . infographer_qode_get_inline_attr( $value, $attr );
				}
			}
		}
		
		$output = ltrim( $output );
		
		return $output;
	}
}

if ( ! function_exists( 'infographer_qode_get_attachment_meta' ) ) {
	/**
	 * Function that returns attachment meta data from attachment id
	 *
	 * @param $attachment_id
	 * @param array $keys sub array of attachment meta
	 *
	 * @return array|mixed
	 */
	function infographer_qode_get_attachment_meta( $attachment_id, $keys = array() ) {
		$meta_data = array();
		
		//is attachment id set?
		if ( ! empty( $attachment_id ) ) {
			//get all post meta for given attachment id
			$meta_data = get_post_meta( $attachment_id, '_wp_attachment_metadata', true );
			
			//is subarray of meta array keys set?
			if ( is_array( $keys ) && count( $keys ) ) {
				$sub_array = array();
				
				//for each defined key
				foreach ( $keys as $key ) {
					//check if that key exists in all meta array
					if ( array_key_exists( $key, $meta_data ) ) {
						//assign key from meta array for current key to meta subarray
						$sub_array[ $key ] = $meta_data[ $key ];
					}
				}
				
				//we want meta array to be subarray because that is what used whants to get
				$meta_data = $sub_array;
			}
		}
		
		//return meta array
		return $meta_data;
	}
}

if ( ! function_exists( 'infographer_qode_get_attachment_id_from_url' ) ) {
	/**
	 * Function that retrieves attachment id for passed attachment url
	 *
	 * @param $attachment_url
	 *
	 * @return null|string
	 */
	function infographer_qode_get_attachment_id_from_url( $attachment_url ) {
		global $wpdb;
		$attachment_id = '';
		
		//is attachment url set?
		if ( $attachment_url !== '' ) {
			//prepare query
			
			$query = $wpdb->prepare( "SELECT ID FROM {$wpdb->posts} WHERE guid=%s", $attachment_url );
			
			//get attachment id
			$attachment_id = $wpdb->get_var( $query );
		}
		
		//return id
		return $attachment_id;
	}
}

if ( ! function_exists( 'infographer_qode_get_attachment_meta_from_url' ) ) {
	/**
	 * Function that returns meta array for give attachment url
	 *
	 * @param $attachment_url
	 * @param array $keys sub array of attachment meta
	 *
	 * @return array|mixed
	 *
	 * @see infographer_qode_get_attachment_id_from_url()
	 * @see infographer_qode_get_attachment_meta()
	 *
	 * @version 0.1
	 */
	function infographer_qode_get_attachment_meta_from_url( $attachment_url, $keys = array() ) {
		$attachment_meta = array();
		
		//get attachment id for attachment url
		$attachment_id = infographer_qode_get_attachment_id_from_url( $attachment_url );
		
		//is attachment id set?
		if ( ! empty( $attachment_id ) ) {
			//get post meta
			$attachment_meta                  = infographer_qode_get_attachment_meta( $attachment_id, $keys );
			$attachment_meta['attachment_id'] = $attachment_id;
		}
		
		//return post meta
		return $attachment_meta;
	}
}

if ( ! function_exists( 'infographer_qode_get_image_dimensions' ) ) {
	/**
	 * Function that returns image sizes array. First looks in post_meta table if attachment exists in the database,
	 * if it does not than it uses getimagesize PHP function to get image sizes
	 *
	 * @param $url string url of the image
	 *
	 * @return array array of image sizes that contains height and width
	 *
	 * @see  infographer_qode_get_attachment_meta_from_url()
	 * @uses getimagesize
	 *
	 * @version 0.1
	 */
	function infographer_qode_get_image_dimensions( $url ) {
		$image_sizes = array();
		
		//is url passed?
		if ( $url !== '' ) {
			//get image sizes from posts meta if attachment exists
			$image_sizes = infographer_qode_get_attachment_meta_from_url( $url, array( 'width', 'height' ) );
			
			//image does not exists in post table, we have to use PHP way of getting image size
			if ( ! count( $image_sizes ) ) {
				require_once( ABSPATH . 'wp-admin/includes/file.php' );
				
				//can we open file by url?
				if ( ini_get( 'allow_url_fopen' ) == 1 && file_exists( $url ) ) {
					list( $width, $height, $type, $attr ) = getimagesize( $url );
				} else {
					//we can't open file directly, have to locate it with relative path.
					$image_obj           = parse_url( $url );
					$image_relative_path = rtrim( get_home_path(), '/' ) . $image_obj['path'];
					
					if ( file_exists( $image_relative_path ) ) {
						list( $width, $height, $type, $attr ) = getimagesize( $image_relative_path );
					}
				}
				
				//did we get width and height from some of above methods?
				if ( isset( $width ) && isset( $height ) ) {
					//set them to our image sizes array
					$image_sizes = array(
						'width'  => $width,
						'height' => $height
					);
				}
			}
		}
		
		return $image_sizes;
	}
}

if ( ! function_exists( 'infographer_qode_get_image_alt_from_url' ) ) {
	function infographer_qode_get_image_alt_from_url( $url ) {
		$alt_text = "";
		
		if ( ! empty( $url ) ) {
			global $wpdb;
			$thepost = $wpdb->get_row( $wpdb->prepare( "SELECT * FROM $wpdb->posts WHERE guid = '%s'", esc_url( $url ) ) );
			
			if ( ! empty( $thepost ) ) {
				$alt_text = get_post_meta( $thepost->ID, '_wp_attachment_image_alt', true );
				
				if ( empty( $alt_text ) ) {
					$alt_text = "";
				}
			}
		}
		
		return $alt_text;
	}
}

if ( ! function_exists( 'infographer_qode_return_portfolio_single_media' ) ) {
	function infographer_qode_return_portfolio_single_media( $porftolio_template ) {
		$portfolio_images = get_post_meta( get_the_ID(), "qode_portfolio_images", true );
		if ( $portfolio_images ) {
			usort( $portfolio_images, "infographer_qode_compare_portfolio_images" );
			
			$wrapper_begin   = '';
			$wrapper_end     = '';
			
			if ( $porftolio_template === 2 || $porftolio_template === 3 ) {
				$wrapper_begin = '<li class="slide">';
				$wrapper_end   = '</li>';
			}
			
			foreach ( $portfolio_images as $portfolio_image ) {
				
				if ( $portfolio_image['portfolioimg'] != "" ) {
					global $wpdb;
					$image_src = $portfolio_image['portfolioimg'];
					$query     = "SELECT ID FROM {$wpdb->posts} WHERE guid='$image_src'";
					$id        = $wpdb->get_var( $query );
					$alt       = get_post_meta( $id, '_wp_attachment_image_alt', true );
					?>
						<?php echo infographer_qode_get_module_part( $wrapper_begin ); ?>
						<img src="<?php echo esc_url( $portfolio_image['portfolioimg'] ); ?>" alt="<?php echo esc_attr( $alt ); ?>"/>
						<?php echo infographer_qode_get_module_part( $wrapper_end ); ?>
					<?php
				} else {
					$portfoliovideotype = "";
					if ( isset( $portfolio_image['portfoliovideotype'] ) ) {
						$portfoliovideotype = $portfolio_image['portfoliovideotype'];
					}
					
					switch ( $portfoliovideotype ) {
						case "youtube":
							?>
								<?php echo infographer_qode_get_module_part( $wrapper_begin ); ?>
								<iframe width="100%" src="https://www.youtube.com/embed/<?php echo esc_attr( $portfolio_image['portfoliovideoid'] ); ?>?wmode=transparent" wmode="Opaque" frameborder="0" allowfullscreen></iframe>
								<?php echo infographer_qode_get_module_part( $wrapper_end ); ?>
							<?php
							break;
						case "vimeo":
							?>
								<?php echo infographer_qode_get_module_part( $wrapper_begin ); ?>
								<iframe src="https://player.vimeo.com/video/<?php echo esc_attr( $portfolio_image['portfoliovideoid'] ); ?>?title=0&amp;byline=0&amp;portrait=0" width="100%" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>
								<?php echo infographer_qode_get_module_part( $wrapper_end ); ?>
							<?php
							break;
					}
				}
			}
		}
	}
}