<?php
$infographer_options = infographer_qode_return_global_options();
$qode_page_id        = infographer_qode_get_page_id();

if ( get_post_meta( $qode_page_id, "qode_responsive-title-image", true ) != "" ) {
	$responsive_title_image = get_post_meta( $qode_page_id, "qode_responsive-title-image", true );
} else {
	$responsive_title_image = $infographer_options['responsive_title_image'];
}

if ( get_post_meta( $qode_page_id, "qode_fixed-title-image", true ) != "" ) {
	$fixed_title_image = get_post_meta( $qode_page_id, "qode_fixed-title-image", true );
} else {
	$fixed_title_image = $infographer_options['fixed_title_image'];
}

if ( get_post_meta( $qode_page_id, "qode_title-image", true ) != "" ) {
	$title_image = get_post_meta( $qode_page_id, "qode_title-image", true );
} else {
	$title_image = $infographer_options['title_image'];
}

if ( get_post_meta( $qode_page_id, "qode_title-height", true ) != "" ) {
	$title_height = get_post_meta( $qode_page_id, "qode_title-height", true );
} else {
	$title_height = $infographer_options['title_height'];
}

$title_in_grid = false;
if ( isset( $infographer_options['title_in_grid'] ) && $infographer_options['title_in_grid'] == "yes" ) {
	$title_in_grid = true;
}

$title_classes = array();

if ( $responsive_title_image == 'no' && $title_image != "" && $fixed_title_image == "yes" ) {
	$title_classes[] = 'has_fixed_background';
}

if ( $responsive_title_image == 'no' && $title_image != "" && $fixed_title_image == "no" ) {
	$title_classes[] = 'has_background';
}

if ( $responsive_title_image == 'yes' ) {
	$title_classes[] = 'with_image';
}

$subtitle_text = get_post_meta( $qode_page_id, "qode-page-subtitle", true );

$title             = get_the_title( $qode_page_id );
$enable_page_title = get_post_meta( $qode_page_id, "qode_page-title-text", true );
if ( is_home() && is_front_page() ) {
	$title = get_option( 'blogname' );
} elseif ( is_tag() ) {
	$title = single_term_title( '', false ) . esc_html__( ' Tag', 'infographer' );
} elseif ( is_date() ) {
	$title = get_the_time( 'F Y' );
} elseif ( is_author() ) {
	$title = esc_html__( 'Author: ', 'infographer' ) . get_the_author();
} elseif ( is_category() ) {
	$title = single_cat_title( '', false );
} elseif ( is_archive() ) {
	$title = esc_html__( 'Archive', 'infographer' );
} elseif ( is_search() ) {
	$title = esc_html__( 'Search: ', 'infographer' ) . get_search_query();
} elseif ( is_404() ) {
	$title = $infographer_options['404_title'] !== '' ? $infographer_options['404_title'] : esc_html__( '404', 'infographer' );
	
	if ( isset( $infographer_options['404_subtitle'] ) && $infographer_options['404_subtitle'] != "" ) {
		$subtitle_text = $infographer_options['404_subtitle'];
	} else {
		$subtitle_text = esc_html__( 'Something went wrong', 'infographer' );
	}
} elseif ( is_singular( 'post' ) ) {
	$title = esc_html__( 'Blog', 'infographer' );
	
	if ( ! empty( $enable_page_title ) ) {
		$title = wp_kses_post( $enable_page_title );
	}
}

$post_type = 'blog';
if ( is_singular( 'portfolio_page' ) ) {
	$post_type = 'portfolio';
	
	$subtitle_text = esc_html__( 'Category: ', 'infographer' );
	
	$terms   = wp_get_post_terms( get_the_ID(), 'portfolio_category' );
	if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
		$counter = 0;
		$all     = count( $terms );
		foreach ( $terms as $term ) {
			$counter ++;
			if ( $counter < $all ) {
				$after = ', ';
			} else {
				$after = '';
			}
			$subtitle_text .= esc_attr( $term->name . $after );
		}
	}
} else if ( is_page_template( array( 'full_width.php', 'contact-page.php' ) ) || is_page() ) {
	$post_type = '';
}

$background_color = infographer_qode_return_page_background_style( $post_type );

$title_styles = array();
if ( $responsive_title_image == 'no' && $title_image != "" ) {
	$title_styles[] = 'background-image:url(' . esc_url( $title_image ) . ');';
}

if ( ! empty( $background_color ) ) {
	$title_styles[] = 'background-color: ' . esc_attr( $background_color ) . ';';
}

if ( $responsive_title_image == 'no' && $title_height != '' ) {
	$title_styles[] = 'height:' . intval( $title_height ) . 'px;';
}

$title_label_styles = array();
if ( get_post_meta( $qode_page_id, "qode_page-title-color", true ) != "" ) {
	$title_label_styles[] = 'color: ' . get_post_meta( $qode_page_id, "qode_page-title-color", true ) . '!important;';
}

if ( ! get_post_meta( $qode_page_id, "qode_show-page-title", true ) ) { ?>
	<div class="title <?php echo esc_attr( implode( ' ', $title_classes ) ); ?>" <?php infographer_qode_inline_style( $title_styles ); ?>>
		<?php if ( $responsive_title_image == 'yes' && ! empty( $title_image ) ) { ?>
			<img src="<?php echo esc_url( $title_image ); ?>" alt="<?php esc_attr_e( 'Title Image', 'infographer' ); ?>" />
		<?php } ?>
		<?php if ( ! get_post_meta( $qode_page_id, "qode_show-page-title-text", true ) ) { ?>
			<?php if($title_in_grid){ ?>
				<div class="container">
					<div class="container_inner clearfix">
			<?php } ?>
				<div class="title_text">
					<h1 <?php infographer_qode_inline_style( $title_label_styles ); ?>><?php echo wp_kses_post( $title ); ?></h1>
					<?php if ( ! empty( $subtitle_text ) ) { ?>
						<span class="page_subtitle" <?php infographer_qode_inline_style( $title_label_styles ); ?>><?php echo wp_kses_post( $subtitle_text ); ?></span>
					<?php } ?>
				</div>
			<?php if($title_in_grid){ ?>
					</div>
				</div>
			<?php } ?>
		<?php } ?>
	</div>
<?php } else { ?>
	<div class="no_title_gap" <?php infographer_qode_inline_page_background_style( $post_type ); ?>></div>
<?php } ?>