<?php
/*
Plugin Name: Infographer Core
Description: Plugin that adds additional features needed by our theme
Author: Qode Themes
Version: 1.0.3
*/
if ( ! class_exists( 'InfographerCore' ) ) {
	class InfographerCore {
		private static $instance;
		
		public function __construct() {
			require_once 'constants.php';
			require_once 'helpers/helper.php';
			
			// Make plugin available for translation
			add_action( 'plugins_loaded', array( $this, 'load_plugin_textdomain' ) );
			
			// Add plugin's body classes
			add_filter( 'body_class', array( $this, 'add_body_classes' ) );
			
			add_action( 'after_setup_theme', array( $this, 'init' ), 5 );
		}
		
		public static function get_instance() {
			if ( self::$instance == null ) {
				self::$instance = new self();
			}
			
			return self::$instance;
		}
		
		function load_plugin_textdomain() {
			load_plugin_textdomain( 'infographer-core', false, INFOGRAPHER_CORE_REL_PATH . '/languages' );
		}
		
		function add_body_classes( $classes ) {
			$classes[] = 'infographer-core-' . INFOGRAPHER_CORE_VERSION;
			
			return $classes;
		}
		
		function init() {
			
			if ( infographer_core_is_installed( 'theme' ) ) {
				include_once INFOGRAPHER_CORE_MODULES_PATH . '/helper.php';
			}
		}
	}
	
	InfographerCore::get_instance();
}