<?php

include_once 'shortcodes/shortcodes.php';
include_once 'qode-options.php';
include_once 'custom-fields.php';
include_once 'qode-custom-post-types.php';
include_once 'qode-seo.php';
include_once 'widgets/helper.php';

add_filter('widget_text', 'do_shortcode');
add_filter( 'the_excerpt', 'do_shortcode');

if ( ! function_exists( 'infographer_core_add_google_analytic' ) ) {
	function infographer_core_add_google_analytic() {
		$global_options = infographer_qode_return_global_options();
		
		if ( isset( $global_options['google_analytics_code'] ) && $global_options['google_analytics_code'] != "" ) { ?>
			<script>
				var _gaq = _gaq || [];
				_gaq.push(['_setAccount', '<?php echo esc_attr( $global_options['google_analytics_code'] ); ?>']);
				_gaq.push(['_trackPageview']);
				
				(function () {
					var ga = document.createElement('script');
					ga.type = 'text/javascript';
					ga.async = true;
					ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
					var s = document.getElementsByTagName('script')[0];
					s.parentNode.insertBefore(ga, s);
				})();
			</script>
		<?php }
	}
	
	add_action( 'infographer_qode_after_wrapper_begin', 'infographer_core_add_google_analytic' );
}

if ( ! function_exists( 'infographer_core_add_content_classes' ) ) {
	function infographer_core_add_content_classes( $classes ) {
		$qode_page_id = infographer_qode_get_page_id();
		$animation    = get_post_meta( $qode_page_id, "qode_show-animation", true );
		
		if ( ! empty( $animation ) ) {
			$classes .= ' ' . $animation;
		}
		
		return $classes;
	}
	
	add_filter( 'infographer_qode_content_classes', 'infographer_core_add_content_classes' );
}

if ( ! function_exists( 'infographer_core_add_inline_html_after_content' ) ) {
	function infographer_core_add_inline_html_after_content() {
		$global_options = infographer_qode_return_global_options();
		$qode_page_id   = infographer_qode_get_page_id();
		$animation      = get_post_meta( $qode_page_id, "qode_show-animation", true );
		
		if ( $global_options['page_transitions'] == "1" || $global_options['page_transitions'] == "2" || $global_options['page_transitions'] == "3" || $global_options['page_transitions'] == "4" || ( $animation == "updown" ) || ( $animation == "fade" ) || ( $animation == "updown_fade" ) || ( $animation == "leftright" ) ) { ?>
			<div class="meta">
				<?php do_action('qode_ajax_meta'); ?>
				
				<span id="qode_page_id"><?php echo esc_attr( $qode_page_id ); ?></span>
				<div class="body_classes"><?php echo implode( ',', get_body_class()); ?></div>
			</div>
		<?php }
	}
	
	add_action( 'infographer_qode_after_content_begin', 'infographer_core_add_inline_html_after_content' );
}