<?php

/* Create Portfolio post type */

if ( ! function_exists( 'infographer_qode_create_post_type' ) ) {
	function infographer_qode_create_post_type() {
		register_post_type( 'portfolio_page',
			array(
				'labels'        => array(
					'name'          => esc_html__( 'Portfolio', 'infographer-core' ),
					'singular_name' => esc_html__( 'Portfolio Item', 'infographer-core' ),
					'add_item'      => esc_html__( 'New Portfolio Item', 'infographer-core' ),
					'add_new_item'  => esc_html__( 'Add New Portfolio Item', 'infographer-core' ),
					'edit_item'     => esc_html__( 'Edit Portfolio Item', 'infographer-core' )
				),
				'public'        => true,
				'has_archive'   => true,
				'rewrite'       => array( 'slug' => 'portfolio_page' ),
				'menu_position' => 4,
				'show_ui'       => true,
				'supports'      => array(
					'author',
					'title',
					'editor',
					'thumbnail',
					'excerpt',
					'post-formats',
					'page-attributes'
				)
			)
		);
	}
	
	add_action( 'init', 'infographer_qode_create_post_type' );
}

/* Create Portfolio Categories */

if ( ! function_exists( 'infographer_qode_create_portfolio_taxonomies' ) ) {
	function infographer_qode_create_portfolio_taxonomies() {
		$labels = array(
			'name'              => esc_html__( 'Portfolio Categories', 'infographer-core' ),
			'singular_name'     => esc_html__( 'Portfolio Category', 'infographer-core' ),
			'search_items'      => esc_html__( 'Search Portfolio Categories', 'infographer-core' ),
			'all_items'         => esc_html__( 'All Portfolio Categories', 'infographer-core' ),
			'parent_item'       => esc_html__( 'Parent Portfolio Category', 'infographer-core' ),
			'parent_item_colon' => esc_html__( 'Parent Portfolio Category:', 'infographer-core' ),
			'edit_item'         => esc_html__( 'Edit Portfolio Category', 'infographer-core' ),
			'update_item'       => esc_html__( 'Update Portfolio Category', 'infographer-core' ),
			'add_new_item'      => esc_html__( 'Add New Portfolio Category', 'infographer-core' ),
			'new_item_name'     => esc_html__( 'New Portfolio Category Name', 'infographer-core' ),
			'menu_name'         => esc_html__( 'Portfolio Categories', 'infographer-core' ),
		);
		
		register_taxonomy( 'portfolio_category', array( 'portfolio_page' ), array(
			'hierarchical' => true,
			'labels'       => $labels,
			'show_ui'      => true,
			'query_var'    => true,
			'rewrite'      => array( 'slug' => 'portfolio-category' ),
		) );
		
	}
	
	add_action( 'init', 'infographer_qode_create_portfolio_taxonomies', 0 );
}