<?php
include_once('google-fonts.php');

if (!function_exists ('add_action')) {
		header('Status: 403 Forbidden');
		header('HTTP/1.1 403 Forbidden');
		exit();
}
global $qode_options_infographer;
$qode_options_infographer  = get_option('qode_options_infographer');

class Qode_Theme_Options {

	//constructor of class, PHP4 compatible construction for backward compatibility
	function __construct() {
		add_action('admin_menu', array(&$this, 'qode_admin_menu'));
		add_action('admin_init', array(&$this, 'register_qode_theme_settings'));
	}


	function init_qode_theme_options() {
		global $qode_options_infographer;
		if(isset($qode_options_infographer['reset_to_defaults'])){ 
			if( $qode_options_infographer['reset_to_defaults'] == 'yes' ) delete_option( "qode_options_infographer");
		}
		if (! get_option("qode_options_infographer")) {
			add_option( "qode_options_infographer",
				array( // intitialize the 'qode_options_infographer' array with the following key => value pairs:
					"reset_to_defaults" => '',
					"number_of_chars" => 45,
					"first_color" => '',
					"second_color" => '',
					"background_color" => '',
					"background_color_box" => '',
					"highlight_color" => '',
					"selection_color" => '',
					"favicon_image" => QODE_ROOT."/img/favicon.ico",
					"background_image" => '',
					"patern_background_image" => '',
					"google_fonts" => '-1',
					"page_transitions" => '0',
					"boxed" => 'no',
					"responsiveness" => 'yes',
					"show_back_button" => 'yes',
					"delay" => 'no',
					"parallax_speed" => '1',
					"parallax_minheight" => '300',
					"parallax_onoff" => 'on',
					"internal_no_ajax_links" => '',
					"custom_css" => '',
					"custom_js" => '',
					"meta_keywords" => '',
					"meta_description" => '',
					"disable_qode_seo" => 'no',
					"h1_color" => '',
					"h1_google_fonts" => '-1',
					"h1_fontsize" => '',
					"h1_lineheight" => '',
					"h1_fontstyle" => '',
					"h1_fontweight" => '',
					"h2_color" => '',
					"h2_google_fonts" => '-1',
					"h2_fontsize" => '',
					"h2_lineheight" => '',
					"h2_fontstyle" => '',
					"h2_fontweight" => '',
					"h3_color" => '',
					"h3_google_fonts" => '-1',
					"h3_fontsize" => '',
					"h3_lineheight" => '',
					"h3_fontstyle" => '',
					"h3_fontweight" => '',
					"h4_color" => '',
					"h4_google_fonts" => '-1',
					"h4_fontsize" => '',
					"h4_lineheight" => '',
					"h4_fontstyle" => '',
					"h4_fontweight" => '',
					"h5_color" => '',
					"h5_google_fonts" => '-1',
					"h5_fontsize" => '',
					"h5_lineheight" => '',
					"h5_fontstyle" => '',
					"h5_fontweight" => '',
					"h6_color" => '',
					"h6_google_fonts" => '-1',
					"h6_fontsize" => '',
					"h6_lineheight" => '',
					"h6_fontstyle" => '',
					"h6_fontweight" => '',
					"text_color" => '',
					"text_google_fonts" => '-1',
					"text_fontsize" => '',
					"text_lineheight" => '',
					"text_fontstyle" => '',
					"text_fontweight" => '',
					"text_margin" => '',
					"link_color" => '',
					"link_hovercolor" => '',
					"link_fontstyle" => '',
					"link_fontweight" => '',
					"link_fontdecoration" => '',
					"page_title_color" => '',
					"page_title_google_fonts" => '-1',
					"page_title_fontsize" => '',
					"page_title_lineheight" => '',
					"page_title_fontstyle" => '',
					"page_title_fontweight" => '',
					"menu_color" => '',
					"menu_hovercolor" => '',
					"menu_hoverbackgroundcolor" => '',
					"menu_google_fonts" => '-1',
					"menu_fontsize" => '',
					"menu_lineheight" => '',
					"menu_fontstyle" => '',
					"menu_fontweight" => '',
					"header_hide" => 'no',
					"header_in_grid" => 'no',
					"header_fixed" => 'yes',
					"header_widget_area" => 'yes',
					"header_background_color" => '',
					"logo_image" => QODE_ROOT."/img/logo.png",
					"dropdown_background_color" => '',
					"menu_position" => 'left',
					"dropdown_color" => '',
					"dropdown_hovercolor" => '',
					"dropdown_google_fonts" => '-1',
					"dropdown_fontsize" => '',
					"dropdown_lineheight" => '',
					"dropdown_fontstyle" => '',
					"dropdown_fontweight" => '',
					"dropdown_color_thirdlvl" => '',
					"dropdown_hovercolor_thirdlvl" => '',
					"dropdown_google_fonts_thirdlvl" => '-1',
					"dropdown_fontsize_thirdlvl" => '',
					"dropdown_lineheight_thirdlvl" => '',
					"dropdown_fontstyle_thirdlvl" => '',
					"dropdown_fontweight_thirdlvl" => '',
					"header_separator_thickness" => '',
					"responsive_title_image" => '',
					"fixed_title_image" => '',
					"title_image" => '',
					"title_height" => '',
					"page_title_position" => '0',
					"title_in_grid" => 'yes',
					"footer_widget_area" => 'yes',
					"footer_text" => 'yes',
					"footer_top_title_color" => '',
					"footer_top_text_color" => '',
					"footer_top_background_color" => '',
					"footer_bottom_text_color" => '',
					"footer_bottom_background_color" => '',
					"content_menu_color" => '',
					"content_menu_hovercolor" => '',
					"content_menu_backgroundcolor" => '',
					"content_menu_google_fonts" => '-1',
					"content_menu_fontsize" => '',
					"content_menu_lineheight" => '',
					"content_menu_fontstyle" => '',
					"content_menu_fontweight" => '',
					"content_menu_position" => '0',
					"separator_thickness" => '',
					"separator_topmargin" => '',
					"separator_bottommargin" => '',
					"separator_pattern_color" => '',
					"separator_pattern_topmargin" => '',
					"separator_pattern_bottommargin" => '',
					"button_title_color" => '',
					"button_title_hovercolor" => '',
					"button_title_google_fonts" => '-1',
					"button_title_fontsize" => '',
					"button_title_lineheight" => '',
					"button_title_fontstyle" => '',
					"button_title_fontweight" => '',
					"button_size" => '',
					"button_backgroundcolor" => '',
					"button_backgroundhovercolor" => '',
					"message_title_color" => '',
					"message_title_google_fonts" => '-1',
					"message_backgroundcolor" => '',
					"blockquote_font_color" => '',
					"blockquote_background_color" => '',
					"portfolio_background_color" => '',
					"portfolio_style" => '1',
					"blog_background_color" => '',
					"pagination" => '1',
					"blog_style" => '1',
					"category_blog_sidebar" => 'default',
					"blog_hide_comments" => 'no',
					"back_to_previous" => 'no',
					"number_of_chars" => '45',
					"receive_mail" => '',
					"enable_contact_form" => 'no',
					"hide_contact_form_website" => 'no',
					"email_from" => '',
					"email_subject" => '',
					"use_recaptcha" => 'no',
					"recaptcha_public_key" => '',
					"recaptcha_private_key" => '',
					"contact_heading_above" => '',
					"contact_text_above" => '',
					"enable_google_map" => 'no',
					"google_maps_pin_image" => QODE_ROOT."/img/pin.png",
					"google_maps_address" => '',
					"google_maps_iframe" => '',
					"404_title" => '',
					"404_subtitle" => '',
					"404_text" => '',
					"404_backlabel" => '',
					"enable_social_share" => 'no',
					"enable_facebook_share" => 'no',
					"enable_twitter_share" => 'no',
					"enable_google_plus" => 'no',
					"facebook_icon" => '',
					"twitter_icon" => '',
					"google_plus_icon" => '',
					"twitter_via" => ''
				)
			);
		} 
	}

	function register_qode_theme_settings() {
	    register_setting( 'qode_options_infographer_page', 'qode_options_infographer', array(&$this, 'validate_options') );
	}
	//extend the admin menu
	function qode_admin_menu() {
		$this->init_qode_theme_options();
		//Add the Qode options page to the Themes' menu
		$this->pagehook = add_menu_page('Qode Theme', esc_html__('Qode Options', 'infographer-core'), 'manage_options', 'qode_options_infographer_page', array(&$this, 'qode_generate_options_page'));
		add_action('load-'.$this->pagehook, array(&$this, 'on_load_page'));
	}

	function on_load_page() {
		
		// load javascripts to allow drag/drop, expand/collapse and hide/show of boxes
		add_meta_box('qode-general-options-metabox', esc_html__('Options', 'infographer-core'), array(&$this, 'general_options_contentbox'), $this->pagehook, 'normal', 'core');
	
	}

	function qode_generate_options_page() {

		// global screen column value to be able to have a sidebar in WordPress 2.8+
		global $screen_layout_columns;

		/* Messages to display saved and reset */
		if ( isset( $_REQUEST['settings-updated'] ) || isset( $_REQUEST['updated'] ) ) {
			echo '<div id="message" class="updated fade"><p><strong>' . esc_html__( 'Settings saved.', 'infographer-core' ) . '</strong></p></div>';
			
			do_action( 'infographer_qode_action_after_theme_option_save' );
		}
                
		?>
		<div id="qode-metaboxes-general" class="wrap">
		    <div style="float:left; padding:10px 10px 10px 0;"></div>
			<?php $current_theme = wp_get_theme(); ?>
			<h2 style="padding-top:25px;"><?php echo esc_attr($current_theme->get('Name').' - '.esc_html__('Theme Options - Version', 'infographer-core' ).' '.$current_theme->get('Version')); ?></h2>
			
			<form method="post" action="options.php">
<?php			settings_fields( 'qode_options_infographer_page' ); // Checks that the user can update options and also redirect the user back to the correct admin page (this form).
			$options = get_option('qode_options_infographer');
			// Allows the 'closed' state of metaboxes to be remembered
			wp_nonce_field('closedpostboxes', 'closedpostboxesnonce', false );
			// Allows the order of metaboxes to be remembered
			wp_nonce_field('meta-box-order', 'meta-box-order-nonce', false ); ?>

			<div id="poststuff" class="metabox-holder<?php echo 2 == $screen_layout_columns ? ' has-right-sidebar' : ''; ?>">
				<div id="post-body" class="has-sidebar">
					<div id="post-body-content" class="has-sidebar-content">
<?php					    do_meta_boxes($this->pagehook, 'normal', $options); ?>
<?php					    do_meta_boxes($this->pagehook, 'additional', $options); ?>
					    <fieldset style="margin:2px 0 0;"><legend class="screen-reader-text"><span><?php esc_attr_e('Reset to defaults', 'infographer-core') ?></span></legend>
						<label for="reset_to_defaults">
						    <input name="qode_options_infographer[reset_to_defaults]" type="checkbox" id="reset_to_defaults" value="yes" />
						    <?php esc_attr_e('Reset to defaults', 'infographer-core') ?>
						</label>
					    </fieldset>
					    <p class="submit">
						<input type="hidden" id="qode_submit" value="1" name="qode_submit" />
						<input class="button-primary" type="submit" name="submit" value="<?php esc_attr_e('Save Changes', 'infographer-core') ?>" />
					    </p>
					</div>
				</div>
				<br class="clear"/>
			</div>
		    </form>
		</div>
		<script type="text/javascript">
		    //<![CDATA[
		    jQuery(document).ready( function($) {
			    // close postboxes that should be closed
			    $('.if-js-closed').removeClass('if-js-closed').addClass('closed');
			    // postboxes setup
			    postboxes.add_postbox_toggles('<?php echo esc_attr($this->pagehook); ?>');
		    });
		    //]]>
		</script>
<?php	}

	/**
	 * Validate user input
	 *
	 * @param array $input, an array of user input
	 * @return array Return an input array of sanitized input
	 */
	function validate_options( $input ) {
	global $qode_options_infographer;
		$input['number_of_chars'] = is_numeric( $input['number_of_chars'] ) ? absint($input['number_of_chars']) : $qode_options_infographer['number_of_chars'];
		return $input;
	}
      


	/**************************************************************************************/
	/**** Below you will find the callback method for each of the registered metaboxes ****/
	/**************************************************************************************/

	function general_options_contentbox( $options ) {
		global $fontArrays;
	?>
		
		<div class="sections">
			<h3><?php esc_html_e( 'Global options', 'infographer-core' ); ?></h3>
			<div>
				<table class="form-table">
					<tbody>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('First main color', 'infographer-core'); ?></td>
							<td>
								<div class="colorSelector"><div style="<?php if ($options['first_color']){ echo 'background-color:'.esc_attr($options['first_color']).';'; } ?>"></div></div>
								<input name="qode_options_infographer[first_color]" type="text" value="<?php if ($options['first_color']) { echo esc_attr($options['first_color']); } ?>" size="30" maxlength="500" />
								<?php esc_html_e('Choose first main color', 'infographer-core'); ?>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Second main color', 'infographer-core'); ?></td>
							<td>
								<div class="colorSelector"><div style="<?php if ($options['second_color']){ echo 'background-color:'.esc_attr($options['second_color']).';'; } ?>"></div></div>
								<input name="qode_options_infographer[second_color]" type="text" value="<?php if ($options['second_color']) { echo esc_attr($options['second_color']); } ?>" size="30" maxlength="500" />
								<?php esc_html_e('Choose second main color', 'infographer-core'); ?>
							</td>
						</tr>
						<tr valign="middle">
								<td scope="row" width="150"><?php esc_html_e('Background color', 'infographer-core'); ?></td>
								<td>
									<div class="colorSelector"><div style="<?php if ($options['background_color']){ echo 'background-color:'.esc_attr($options['background_color']).';'; } ?>"></div></div>
									<input name="qode_options_infographer[background_color]" type="text" value="<?php if ($options['background_color']) { echo esc_attr($options['background_color']); } ?>" size="30" maxlength="500" />
									<?php esc_html_e('Choose background color', 'infographer-core'); ?>
								</td>
						</tr>
						<tr valign="middle">
								<td scope="row" width="150"><?php esc_html_e('Box background color', 'infographer-core'); ?></td>
								<td>
									<div class="colorSelector"><div style="<?php if ($options['background_color_box']){ echo 'background-color:'.esc_attr($options['background_color_box']).';'; } ?>"></div></div>
									<input name="qode_options_infographer[background_color_box]" type="text" value="<?php if (isset($options['background_color_box'])) { echo esc_attr($options['background_color_box']); } ?>" size="30" maxlength="500" />
									<?php esc_html_e('Choose box background color', 'infographer-core'); ?>
								</td>
						</tr>
						<tr valign="middle">
								<td scope="row" width="150"><?php esc_html_e('Highlight color', 'infographer-core'); ?></td>
								<td>
									<div class="colorSelector"><div style="<?php if ($options['highlight_color']){ echo 'background-color:'.esc_attr($options['highlight_color']).';'; } ?>"></div></div>
									<input name="qode_options_infographer[highlight_color]" type="text"  value="<?php if ($options['highlight_color']) { echo esc_attr($options['highlight_color']); } ?>" size="30" maxlength="500" />
									<?php esc_html_e('Choose highlight color', 'infographer-core'); ?>
								</td>
						</tr>
						<tr valign="middle">
								<td scope="row" width="150"><?php esc_html_e('Selection color', 'infographer-core'); ?></td>
								<td>
									<div class="colorSelector"><div style="<?php if ($options['selection_color']){ echo 'background-color:'.esc_attr($options['selection_color']).';'; } ?>"></div></div>
									<input name="qode_options_infographer[selection_color]" type="text"  value="<?php if ($options['selection_color']) { echo esc_attr($options['selection_color']); } ?>" size="30" maxlength="500" />
									<?php esc_html_e('Choose selection color', 'infographer-core'); ?>
								</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Background image', 'infographer-core'); ?></td>
							<td>	
								<div class="inline" style="width: 600px;">
								<input type="text" id="background_image" name="qode_options_infographer[background_image]" class="background_image" value="<?php if (isset($options['background_image'])) { echo esc_attr($options['background_image']); } ?>" size="70">
								<input class="upload_button" type="button" value="Upload file">
								<br/>
								<?php esc_html_e('Only with boxed layout', 'infographer-core'); ?>
								</div>
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Pattern background image', 'infographer-core'); ?></td>
							<td>	
								<div class="inline" style="width: 600px;">
								<input type="text" id="pattern_background_image" name="qode_options_infographer[pattern_background_image]" class="pattern_background_image" value="<?php if (isset($options['pattern_background_image'])) { echo esc_attr($options['pattern_background_image']); } ?>" size="70">
								<input class="upload_button" type="button" value="Upload file">
								<br/>
								<?php esc_html_e('Only with boxed layout', 'infographer-core'); ?>
								</div>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Favicon image', 'infographer-core'); ?></td>
							<td>	
								<div class="inline" style="width: 600px;">
								<input type="text" id="favicon_image" name="qode_options_infographer[favicon_image]" class="favicon_image" value="<?php if ($options['favicon_image']) { echo esc_attr($options['favicon_image']); } else { echo QODE_ROOT."/img/favicon.ico"; } ?>" size="70">
								<input class="upload_button" type="button" value="Upload file">
								</div>
							</td>
						</tr>
						<tr valign="middle">
								<td scope="row" width="150"><?php esc_html_e('Google fonts', 'infographer-core'); ?></td>
								<td>
							<select name="qode_options_infographer[google_fonts]">
							<option value="-1"><?php esc_html_e( 'Default', 'infographer-core' ); ?></option>
							<?php foreach($fontArrays as $fontArray) { ?> 
								<option <?php if ($options['google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo  esc_attr($fontArray["family"]); ?></option>
							<?php } ?>
								
							</select>
							<?php esc_html_e('Choose Font', 'infographer-core'); ?>
								</td>
						</tr>
						<tr valign="middle">
								<td scope="row" width="150"><?php esc_html_e('Page transition', 'infographer-core'); ?></td>
								<td>
							<select name="qode_options_infographer[page_transitions]">
								<option <?php if ($options['page_transitions'] == 0) { echo "selected='selected'"; } ?> value="0"><?php esc_html_e( 'No animation', 'infographer-core' ); ?></option>
								<option <?php if ($options['page_transitions'] == 1) { echo "selected='selected'"; } ?> value="1"><?php esc_html_e( 'Up/Down', 'infographer-core' ); ?></option>
								<option <?php if ($options['page_transitions'] == 2) { echo "selected='selected'"; } ?> value="2"><?php esc_html_e( 'Fade', 'infographer-core' ); ?></option>
								<option <?php if ($options['page_transitions'] == 3) { echo "selected='selected'"; } ?> value="3"><?php esc_html_e( 'Up/Down (In) / Fade (Out)', 'infographer-core' ); ?></option>
								<option <?php if ($options['page_transitions'] == 4) { echo "selected='selected'"; } ?> value="4"><?php esc_html_e( 'Left/Right', 'infographer-core' ); ?></option>
							</select>
							<?php esc_html_e('In order for animation to work properly, you must choose "Post name" in permalinks settings', 'infographer-core'); ?>
								</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Boxed', 'infographer-core'); ?></td>
							<td>
								<select name="qode_options_infographer[boxed]">
									<option <?php if(isset($options['boxed'])){ $boxed = $options['boxed']; if ($boxed == 'no') { echo "selected='selected'"; } }  ?> value="no"><?php esc_html_e( 'No', 'infographer-core' ); ?></option>
									<option <?php if(isset($options['boxed'])){ $boxed = $options['boxed']; if ($boxed == 'yes') { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'infographer-core' ); ?></option>
								</select>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Responsiveness', 'infographer-core'); ?></td>
							<td>
								<select name="qode_options_infographer[responsiveness]">
									<option <?php if(isset($options['responsiveness'])){ $responsiveness = $options['responsiveness']; if ($responsiveness == 'yes') { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'infographer-core' ); ?></option>
									<option <?php if(isset($options['responsiveness'])){ $responsiveness = $options['responsiveness']; if ($responsiveness == 'no') { echo "selected='selected'"; } }  ?> value="no"><?php esc_html_e( 'No', 'infographer-core' ); ?></option>
								</select>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Show back button', 'infographer-core'); ?></td>
							<td>
								<select name="qode_options_infographer[show_back_button]">
									<option <?php if(isset($options['show_back_button'])){ $show_back_button = $options['show_back_button']; if ($show_back_button == 'no') { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'infographer-core' ); ?></option>
									<option <?php if(isset($options['show_back_button'])){ $show_back_button = $options['show_back_button']; if ($show_back_button == 'yes') { echo "selected='selected'"; } }  ?> value="yes"><?php esc_html_e( 'Yes', 'infographer-core' ); ?></option>
								</select>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Turn off delay on touch devices', 'infographer-core'); ?></td>
							<td>
								<select name="qode_options_infographer[delay]">
									<option <?php if(isset($options['delay'])){ $delay = $options['delay']; if ($delay == 'no') { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'infographer-core' ); ?></option>
									<option <?php if(isset($options['delay'])){ $delay = $options['delay']; if ($delay == 'yes') { echo "selected='selected'"; } }  ?> value="yes"><?php esc_html_e( 'Yes', 'infographer-core' ); ?></option>
								</select>
								<?php esc_html_e('Turn off displaying delay of elements on touch devices', 'infographer-core'); ?>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Google Analytics Account ID', 'infographer-core'); ?></td>
							<td>
								<input name="qode_options_infographer[google_analytics_code]" type="text" value="<?php if (isset($options['google_analytics_code'])) { echo esc_attr($options['google_analytics_code']); } ?>" size="63" maxlength="500" />
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Google Maps Api Key', 'infographer-core'); ?></td>
							<td>
								<input name="qode_options_infographer[google_maps_api_key]" type="text" value="<?php if (isset($options['google_maps_api_key'])) { echo esc_attr($options['google_maps_api_key']); } ?>" size="63" maxlength="500" />
							</td>
						</tr>
						<tr valign="top">
							<td valign="top"><?php esc_html_e('List of internal URLs loaded without AJAX (separated with comma)', 'infographer-core'); ?></td>
							<td>
								<div class="inline">
									<textarea id="internal_no_ajax_links" name="qode_options_infographer[internal_no_ajax_links]" cols="60" rows="5"><?php if (isset($options['internal_no_ajax_links'])) { echo esc_attr($options['internal_no_ajax_links']); } ?></textarea>
								</div>
								
							</td>
						</tr>
						<tr valign="top">
							<td valign="top"><?php esc_html_e('Custom css', 'infographer-core'); ?></td>
							<td>
								<div class="inline">
									<textarea id="custom_css" name="qode_options_infographer[custom_css]" cols="60" rows="5"><?php if ($options['custom_css']) { echo esc_attr($options['custom_css']); } ?></textarea>
								</div>
								
							</td>
						</tr>
						<tr valign="top">
							<td valign="top"><?php esc_html_e('Custom js', 'infographer-core'); ?></td>
							<td>
								<div class="inline">
									<textarea id="custom_js" name="qode_options_infographer[custom_js]" cols="60" rows="5"><?php if ($options['custom_js']) { echo esc_attr($options['custom_js']); } ?></textarea>
								</div><br/>
								<?php esc_html_e('jQuery selector is "$j" because of the conflict mode', 'infographer-core'); ?>
							</td>
						</tr>
						<tr valign="top">
							<td valign="top"><?php esc_html_e('Meta Keywords', 'infographer-core'); ?></td>
							<td>
								<div class="inline">
									<textarea id="meta_keywords" name="qode_options_infographer[meta_keywords]" cols="60" rows="5"><?php if ($options['meta_keywords']) { echo esc_attr($options['meta_keywords']); } ?></textarea>
								</div>
							</td>
						</tr>
						<tr valign="top">
							<td valign="top"><?php esc_html_e('Meta Description', 'infographer-core'); ?></td>
							<td>
								<div class="inline">
									<textarea id="meta_description" name="qode_options_infographer[meta_description]" cols="60" rows="5"><?php if ($options['meta_description']) { echo esc_attr($options['meta_description']); } ?></textarea>
								</div>
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Disable Qode SEO', 'infographer-core'); ?></td>
							<td>
								<select name="qode_options_infographer[disable_qode_seo]">
									<option <?php if(isset($options['disable_qode_seo'])){ $disable_qode_seo = $options['disable_qode_seo']; if ($disable_qode_seo == 'no') { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'infographer-core' ); ?></option>
									<option <?php if(isset($options['disable_qode_seo'])){ $disable_qode_seo = $options['disable_qode_seo']; if ($disable_qode_seo == 'yes') { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'infographer-core' ); ?></option>
								</select>
							</td>
						</tr>
					</tbody>
				</table>
				<?php		display_save_changes_button(); ?>
			</div>
			<h3><?php esc_html_e( 'General font options', 'infographer-core' ); ?></h3>
			<div>
				<table class="form-table">
					<tbody>
						<tr><td colspan='2'><h2><?php esc_html_e( 'Headings', 'infographer-core' ); ?></h2></td></tr>
						<tr valign="middle">
								<td scope="row" width="150"><?php esc_html_e('H1 style', 'infographer-core'); ?></td>
								<td>
									<div class="inline">
										<?php esc_html_e('Color', 'infographer-core'); ?>
										<div class="colorSelector"><div style="<?php if ($options['h1_color']){ echo 'background-color:'.esc_attr($options['h1_color']).';'; } ?>"></div></div>
										<input name="qode_options_infographer[h1_color]" type="text" value="<?php if ($options['h1_color']) { echo esc_attr($options['h1_color']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Font family', 'infographer-core'); ?>
										<select name="qode_options_infographer[h1_google_fonts]">
											<option value="-1"><?php esc_html_e( 'Default', 'infographer-core' ); ?></option>
											<?php foreach($fontArrays as $fontArray) { ?> 
												<option <?php if ($options['h1_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo  esc_attr($fontArray["family"]); ?></option>
											<?php } ?>
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font size (px)', 'infographer-core'); ?>
										<input name="qode_options_infographer[h1_fontsize]" type="text" value="<?php if ($options['h1_fontsize']) { echo esc_attr($options['h1_fontsize']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Line height (px)', 'infographer-core'); ?>
										<input name="qode_options_infographer[h1_lineheight]" type="text" value="<?php if ($options['h1_lineheight']) { echo esc_attr($options['h1_lineheight']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Font style', 'infographer-core'); ?>
										<select name="qode_options_infographer[h1_fontstyle]">
											<option <?php if ($options['h1_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
											<option <?php if ($options['h1_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'infographer-core' ); ?></option>
											<option <?php if ($options['h1_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'infographer-core' ); ?></option>
											
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font weight', 'infographer-core'); ?>
										<select name="qode_options_infographer[h1_fontweight]">
											<option <?php if ($options['h1_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
											<option <?php if ($options['h1_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200"><?php esc_html_e( '200', 'infographer-core' ); ?></option>
											<option <?php if ($options['h1_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300"><?php esc_html_e( '300', 'infographer-core' ); ?></option>
											<option <?php if ($options['h1_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400"><?php esc_html_e( '400', 'infographer-core' ); ?></option>
											<option <?php if ($options['h1_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500"><?php esc_html_e( '500', 'infographer-core' ); ?></option>
											<option <?php if ($options['h1_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600"><?php esc_html_e( '600', 'infographer-core' ); ?></option>
											<option <?php if ($options['h1_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700"><?php esc_html_e( '700', 'infographer-core' ); ?></option>
											<option <?php if ($options['h1_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800"><?php esc_html_e( '800', 'infographer-core' ); ?></option>
											<option <?php if ($options['h1_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900"><?php esc_html_e( '900', 'infographer-core' ); ?></option>
										</select>
									</div>
								</td>
						</tr>
						<tr valign="middle">
								<td scope="row" width="150"><?php esc_html_e('H2 style', 'infographer-core'); ?></td>
								<td>
									<div class="inline">
										<?php esc_html_e('Color', 'infographer-core'); ?>
										<div class="colorSelector"><div style="<?php if ($options['h2_color']){ echo 'background-color:'.esc_attr($options['h2_color']).';'; } ?>"></div></div>
										<input name="qode_options_infographer[h2_color]" type="text" value="<?php if ($options['h2_color']) { echo esc_attr($options['h2_color']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Font family', 'infographer-core'); ?>
										<select name="qode_options_infographer[h2_google_fonts]">
											<option value="-1"><?php esc_html_e( 'Default', 'infographer-core' ); ?></option>
											<?php foreach($fontArrays as $fontArray) { ?> 
												<option <?php if ($options['h2_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo  esc_attr($fontArray["family"]); ?></option>
											<?php } ?>
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font size (px)', 'infographer-core'); ?>
										<input name="qode_options_infographer[h2_fontsize]" type="text" value="<?php if ($options['h2_fontsize']) { echo esc_attr($options['h2_fontsize']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Line height (px)', 'infographer-core'); ?>
										<input name="qode_options_infographer[h2_lineheight]" type="text" value="<?php if ($options['h2_lineheight']) { echo esc_attr($options['h2_lineheight']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Font style', 'infographer-core'); ?>
										<select name="qode_options_infographer[h2_fontstyle]">
											<option <?php if ($options['h2_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
											<option <?php if ($options['h2_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'infographer-core' ); ?></option>
											<option <?php if ($options['h2_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'infographer-core' ); ?></option>
											
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font weight', 'infographer-core'); ?>
										<select name="qode_options_infographer[h2_fontweight]">
											<option <?php if ($options['h2_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
											<option <?php if ($options['h2_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200"><?php esc_html_e( '200', 'infographer-core' ); ?></option>
											<option <?php if ($options['h2_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300"><?php esc_html_e( '300', 'infographer-core' ); ?></option>
											<option <?php if ($options['h2_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400"><?php esc_html_e( '400', 'infographer-core' ); ?></option>
											<option <?php if ($options['h2_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500"><?php esc_html_e( '500', 'infographer-core' ); ?></option>
											<option <?php if ($options['h2_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600"><?php esc_html_e( '600', 'infographer-core' ); ?></option>
											<option <?php if ($options['h2_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700"><?php esc_html_e( '700', 'infographer-core' ); ?></option>
											<option <?php if ($options['h2_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800"><?php esc_html_e( '800', 'infographer-core' ); ?></option>
											<option <?php if ($options['h2_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900"><?php esc_html_e( '900', 'infographer-core' ); ?></option>
											
										</select>
									</div>
								</td>
						</tr>
						<tr valign="middle">
								<td scope="row" width="150"><?php esc_html_e('H3 style', 'infographer-core'); ?></td>
								<td>
									<div class="inline">
										<?php esc_html_e('Color', 'infographer-core'); ?>
										<div class="colorSelector"><div style="<?php if ($options['h3_color']){ echo 'background-color:'.esc_attr($options['h3_color']).';'; } ?>"></div></div>
										<input name="qode_options_infographer[h3_color]" type="text" value="<?php if ($options['h3_color']) { echo esc_attr($options['h3_color']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Font family', 'infographer-core'); ?>
										<select name="qode_options_infographer[h3_google_fonts]">
											<option value="-1"><?php esc_html_e( 'Default', 'infographer-core' ); ?></option>
											<?php foreach($fontArrays as $fontArray) { ?> 
												<option <?php if ($options['h3_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo  esc_attr($fontArray["family"]); ?></option>
											<?php } ?>
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font size (px)', 'infographer-core'); ?>
										<input name="qode_options_infographer[h3_fontsize]" type="text" value="<?php if ($options['h3_fontsize']) { echo esc_attr($options['h3_fontsize']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Line height (px)', 'infographer-core'); ?>
										<input name="qode_options_infographer[h3_lineheight]" type="text" value="<?php if ($options['h3_lineheight']) { echo esc_attr($options['h3_lineheight']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Font style', 'infographer-core'); ?>
										<select name="qode_options_infographer[h3_fontstyle]">
											<option <?php if ($options['h3_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
											<option <?php if ($options['h3_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'infographer-core' ); ?></option>
											<option <?php if ($options['h3_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'infographer-core' ); ?></option>
											
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font weight', 'infographer-core'); ?>
										<select name="qode_options_infographer[h3_fontweight]">
											<option <?php if ($options['h3_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
											<option <?php if ($options['h3_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200"><?php esc_html_e( '200', 'infographer-core' ); ?></option>
											<option <?php if ($options['h3_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300"><?php esc_html_e( '300', 'infographer-core' ); ?></option>
											<option <?php if ($options['h3_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400"><?php esc_html_e( '400', 'infographer-core' ); ?></option>
											<option <?php if ($options['h3_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500"><?php esc_html_e( '500', 'infographer-core' ); ?></option>
											<option <?php if ($options['h3_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600"><?php esc_html_e( '600', 'infographer-core' ); ?></option>
											<option <?php if ($options['h3_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700"><?php esc_html_e( '700', 'infographer-core' ); ?></option>
											<option <?php if ($options['h3_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800"><?php esc_html_e( '800', 'infographer-core' ); ?></option>
											<option <?php if ($options['h3_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900"><?php esc_html_e( '900', 'infographer-core' ); ?></option>
											
										</select>
									</div>
								</td>
						</tr>
						<tr valign="middle">
								<td scope="row" width="150"><?php esc_html_e('H4 style', 'infographer-core'); ?></td>
								<td>
									<div class="inline">
										<?php esc_html_e('Color', 'infographer-core'); ?>
										<div class="colorSelector"><div style="<?php if ($options['h4_color']){ echo 'background-color:'.esc_attr($options['h4_color']).';'; } ?>"></div></div>
										<input name="qode_options_infographer[h4_color]" type="text" value="<?php if ($options['h4_color']) { echo esc_attr($options['h4_color']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Font family', 'infographer-core'); ?>
										<select name="qode_options_infographer[h4_google_fonts]">
											<option value="-1"><?php esc_html_e( 'Default', 'infographer-core' ); ?></option>
											<?php foreach($fontArrays as $fontArray) { ?> 
												<option <?php if ($options['h4_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo  esc_attr($fontArray["family"]); ?></option>
											<?php } ?>
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font size (px)', 'infographer-core'); ?>
										<input name="qode_options_infographer[h4_fontsize]" type="text" value="<?php if ($options['h4_fontsize']) { echo esc_attr($options['h4_fontsize']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Line height (px)', 'infographer-core'); ?>
										<input name="qode_options_infographer[h4_lineheight]" type="text" value="<?php if ($options['h4_lineheight']) { echo esc_attr($options['h4_lineheight']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Font style', 'infographer-core'); ?>
										<select name="qode_options_infographer[h4_fontstyle]">
											<option <?php if ($options['h4_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
											<option <?php if ($options['h4_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'infographer-core' ); ?></option>
											<option <?php if ($options['h4_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'infographer-core' ); ?></option>
											
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font weight', 'infographer-core'); ?>
										<select name="qode_options_infographer[h4_fontweight]">
											<option <?php if ($options['h4_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
											<option <?php if ($options['h4_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200"><?php esc_html_e( '200', 'infographer-core' ); ?></option>
											<option <?php if ($options['h4_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300"><?php esc_html_e( '300', 'infographer-core' ); ?></option>
											<option <?php if ($options['h4_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400"><?php esc_html_e( '400', 'infographer-core' ); ?></option>
											<option <?php if ($options['h4_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500"><?php esc_html_e( '500', 'infographer-core' ); ?></option>
											<option <?php if ($options['h4_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600"><?php esc_html_e( '600', 'infographer-core' ); ?></option>
											<option <?php if ($options['h4_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700"><?php esc_html_e( '700', 'infographer-core' ); ?></option>
											<option <?php if ($options['h4_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800"><?php esc_html_e( '800', 'infographer-core' ); ?></option>
											<option <?php if ($options['h4_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900"><?php esc_html_e( '900', 'infographer-core' ); ?></option>
											
										</select>
									</div>
								</td>
						</tr>
						<tr valign="middle">
								<td scope="row" width="150"><?php esc_html_e('H5 style', 'infographer-core'); ?></td>
								<td>
									<div class="inline">
										<?php esc_html_e('Color', 'infographer-core'); ?>
										<div class="colorSelector"><div style="<?php if ($options['h5_color']){ echo 'background-color:'.esc_attr($options['h5_color']).';'; } ?>"></div></div>
										<input name="qode_options_infographer[h5_color]" type="text" value="<?php if ($options['h5_color']) { echo esc_attr($options['h5_color']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Font family', 'infographer-core'); ?>
										<select name="qode_options_infographer[h5_google_fonts]">
											<option value="-1"><?php esc_html_e( 'Default', 'infographer-core' ); ?></option>
											<?php foreach($fontArrays as $fontArray) { ?> 
												<option <?php if ($options['h5_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo  esc_attr($fontArray["family"]); ?></option>
											<?php } ?>
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font size (px)', 'infographer-core'); ?>
										<input name="qode_options_infographer[h5_fontsize]" type="text" value="<?php if ($options['h5_fontsize']) { echo esc_attr($options['h5_fontsize']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Line height (px)', 'infographer-core'); ?>
										<input name="qode_options_infographer[h5_lineheight]" type="text" value="<?php if ($options['h5_lineheight']) { echo esc_attr($options['h5_lineheight']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Font style', 'infographer-core'); ?>
										<select name="qode_options_infographer[h5_fontstyle]">
											<option <?php if ($options['h5_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
											<option <?php if ($options['h5_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'infographer-core' ); ?></option>
											<option <?php if ($options['h5_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'infographer-core' ); ?></option>
											
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font weight', 'infographer-core'); ?>
										<select name="qode_options_infographer[h5_fontweight]">
											<option <?php if ($options['h5_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
											<option <?php if ($options['h5_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200"><?php esc_html_e( '200', 'infographer-core' ); ?></option>
											<option <?php if ($options['h5_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300"><?php esc_html_e( '300', 'infographer-core' ); ?></option>
											<option <?php if ($options['h5_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400"><?php esc_html_e( '400', 'infographer-core' ); ?></option>
											<option <?php if ($options['h5_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500"><?php esc_html_e( '500', 'infographer-core' ); ?></option>
											<option <?php if ($options['h5_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600"><?php esc_html_e( '600', 'infographer-core' ); ?></option>
											<option <?php if ($options['h5_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700"><?php esc_html_e( '700', 'infographer-core' ); ?></option>
											<option <?php if ($options['h5_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800"><?php esc_html_e( '800', 'infographer-core' ); ?></option>
											<option <?php if ($options['h5_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900"><?php esc_html_e( '900', 'infographer-core' ); ?></option>
											
										</select>
									</div>
								</td>
						</tr>
						<tr valign="middle">
								<td scope="row" width="150"><?php esc_html_e('H6 style', 'infographer-core'); ?></td>
								<td>
									<div class="inline">
										<?php esc_html_e('Color', 'infographer-core'); ?>
										<div class="colorSelector"><div style="<?php if ($options['h6_color']){ echo 'background-color:'.esc_attr($options['h6_color']).';'; } ?>"></div></div>
										<input name="qode_options_infographer[h6_color]" type="text" value="<?php if ($options['h6_color']) { echo esc_attr($options['h6_color']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Font family', 'infographer-core'); ?>
										<select name="qode_options_infographer[h6_google_fonts]">
											<option value="-1"><?php esc_html_e( 'Default', 'infographer-core' ); ?></option>
											<?php foreach($fontArrays as $fontArray) { ?> 
												<option <?php if ($options['h6_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo  esc_attr($fontArray["family"]); ?></option>
											<?php } ?>
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font size (px)', 'infographer-core'); ?>
										<input name="qode_options_infographer[h6_fontsize]" type="text" value="<?php if ($options['h6_fontsize']) { echo esc_attr($options['h6_fontsize']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Line height (px)', 'infographer-core'); ?>
										<input name="qode_options_infographer[h6_lineheight]" type="text" value="<?php if ($options['h6_lineheight']) { echo esc_attr($options['h6_lineheight']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Font style', 'infographer-core'); ?>
										<select name="qode_options_infographer[h6_fontstyle]">
											<option <?php if ($options['h6_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
											<option <?php if ($options['h6_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'infographer-core' ); ?></option>
											<option <?php if ($options['h6_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'infographer-core' ); ?></option>
											
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font weight', 'infographer-core'); ?>
										<select name="qode_options_infographer[h6_fontweight]">
											<option <?php if ($options['h6_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
											<option <?php if ($options['h6_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200"><?php esc_html_e( '200', 'infographer-core' ); ?></option>
											<option <?php if ($options['h6_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300"><?php esc_html_e( '300', 'infographer-core' ); ?></option>
											<option <?php if ($options['h6_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400"><?php esc_html_e( '400', 'infographer-core' ); ?></option>
											<option <?php if ($options['h6_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500"><?php esc_html_e( '500', 'infographer-core' ); ?></option>
											<option <?php if ($options['h6_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600"><?php esc_html_e( '600', 'infographer-core' ); ?></option>
											<option <?php if ($options['h6_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700"><?php esc_html_e( '700', 'infographer-core' ); ?></option>
											<option <?php if ($options['h6_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800"><?php esc_html_e( '800', 'infographer-core' ); ?></option>
											<option <?php if ($options['h6_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900"><?php esc_html_e( '900', 'infographer-core' ); ?></option>
											
										</select>
									</div>
								</td>
						</tr>
						<tr><td colspan='2'><h2><?php esc_html_e( 'Text', 'infographer-core' ); ?></h2></td></tr>
						<tr valign="middle">
								<td scope="row" width="150"><?php esc_html_e('Text style', 'infographer-core'); ?></td>
								<td>
									<div class="inline">
										<?php esc_html_e('Color', 'infographer-core'); ?>
										<div class="colorSelector"><div style="<?php if ($options['text_color']){ echo 'background-color:'.esc_attr($options['text_color']).';'; } ?>"></div></div>
										<input name="qode_options_infographer[text_color]" type="text" value="<?php if ($options['text_color']) { echo esc_attr($options['text_color']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Font family', 'infographer-core'); ?>
										<select name="qode_options_infographer[text_google_fonts]">
											<option value="-1"><?php esc_html_e( 'Default', 'infographer-core' ); ?></option>
											<?php foreach($fontArrays as $fontArray) { ?> 
												<option <?php if ($options['text_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo  esc_attr($fontArray["family"]); ?></option>
											<?php } ?>
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font size (px)', 'infographer-core'); ?>
										<input name="qode_options_infographer[text_fontsize]" type="text" value="<?php if ($options['text_fontsize']) { echo esc_attr($options['text_fontsize']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Line height (px)', 'infographer-core'); ?>
										<input name="qode_options_infographer[text_lineheight]" type="text" value="<?php if ($options['text_lineheight']) { echo esc_attr($options['text_lineheight']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Font style', 'infographer-core'); ?>
										<select name="qode_options_infographer[text_fontstyle]">
											<option <?php if ($options['text_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
											<option <?php if ($options['text_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'infographer-core' ); ?></option>
											<option <?php if ($options['text_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'infographer-core' ); ?></option>
											
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font weight', 'infographer-core'); ?>
										<select name="qode_options_infographer[text_fontweight]">
											<option <?php if ($options['text_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
											<option <?php if ($options['text_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200"><?php esc_html_e( '200', 'infographer-core' ); ?></option>
											<option <?php if ($options['text_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300"><?php esc_html_e( '300', 'infographer-core' ); ?></option>
											<option <?php if ($options['text_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400"><?php esc_html_e( '400', 'infographer-core' ); ?></option>
											<option <?php if ($options['text_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500"><?php esc_html_e( '500', 'infographer-core' ); ?></option>
											<option <?php if ($options['text_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600"><?php esc_html_e( '600', 'infographer-core' ); ?></option>
											<option <?php if ($options['text_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700"><?php esc_html_e( '700', 'infographer-core' ); ?></option>
											<option <?php if ($options['text_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800"><?php esc_html_e( '800', 'infographer-core' ); ?></option>
											<option <?php if ($options['text_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900"><?php esc_html_e( '900', 'infographer-core' ); ?></option>
											
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Top/Bottom margin (px)', 'infographer-core'); ?>
										<input name="qode_options_infographer[text_margin]" type="text" value="<?php if (isset($options['text_margin'])) { echo esc_attr($options['text_margin']); } ?>" size="10" maxlength="10" />
									</div>
								</td>
						</tr>
						<tr valign="middle">
								<td scope="row" width="150"><?php esc_html_e('Link style', 'infographer-core'); ?></td>
								<td>
									<div class="inline">
										<?php esc_html_e('Color', 'infographer-core'); ?>
										<div class="colorSelector"><div style="<?php if ($options['link_color']){ echo 'background-color:'.esc_attr($options['link_color']).';'; } ?>"></div></div>
										<input name="qode_options_infographer[link_color]" type="text" value="<?php if ($options['link_color']) { echo esc_attr($options['link_color']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Hover color', 'infographer-core'); ?>
										<div class="colorSelector"><div style="<?php if ($options['link_hovercolor']){ echo 'background-color:'.esc_attr($options['link_hovercolor']).';'; } ?>"></div></div>
										<input name="qode_options_infographer[link_hovercolor]" type="text" value="<?php if ($options['link_hovercolor']) { echo esc_attr($options['link_hovercolor']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Font style', 'infographer-core'); ?>
										<select name="qode_options_infographer[link_fontstyle]">
											<option <?php if ($options['link_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
											<option <?php if ($options['link_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'infographer-core' ); ?></option>
											<option <?php if ($options['link_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'infographer-core' ); ?></option>
											
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font weight', 'infographer-core'); ?>
										<select name="qode_options_infographer[link_fontweight]">
											<option <?php if ($options['link_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
											<option <?php if ($options['link_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200"><?php esc_html_e( '200', 'infographer-core' ); ?></option>
											<option <?php if ($options['link_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300"><?php esc_html_e( '300', 'infographer-core' ); ?></option>
											<option <?php if ($options['link_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400"><?php esc_html_e( '400', 'infographer-core' ); ?></option>
											<option <?php if ($options['link_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500"><?php esc_html_e( '500', 'infographer-core' ); ?></option>
											<option <?php if ($options['link_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600"><?php esc_html_e( '600', 'infographer-core' ); ?></option>
											<option <?php if ($options['link_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700"><?php esc_html_e( '700', 'infographer-core' ); ?></option>
											<option <?php if ($options['link_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800"><?php esc_html_e( '800', 'infographer-core' ); ?></option>
											<option <?php if ($options['link_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900"><?php esc_html_e( '900', 'infographer-core' ); ?></option>
											
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font decoration', 'infographer-core'); ?>
										<select name="qode_options_infographer[link_fontdecoration]">
											<option <?php if ($options['link_fontdecoration'] == "") { echo "selected='selected'"; } ?> value=""></option>
											<option <?php if ($options['link_fontdecoration'] == "none") { echo "selected='selected'"; } ?> value="none"><?php esc_html_e( 'none', 'infographer-core' ); ?></option>
											<option <?php if ($options['link_fontdecoration'] == "bold") { echo "selected='selected'"; } ?> value="underline"><?php esc_html_e( 'underline', 'infographer-core' ); ?></option>
											
										</select>
									</div>
								</td>
						</tr>
						<tr><td colspan='2'><h2><?php esc_html_e( 'Page title', 'infographer-core' ); ?></h2></td></tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Page title style', 'infographer-core'); ?></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Color', 'infographer-core'); ?>
									<div class="colorSelector"><div style="<?php if ($options['page_title_color']){ echo 'background-color:'.esc_attr($options['page_title_color']).';'; } ?>"></div></div>
									<input name="qode_options_infographer[page_title_color]" type="text" value="<?php if ($options['page_title_color']) { echo esc_attr($options['page_title_color']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Font family', 'infographer-core'); ?>
									<select name="qode_options_infographer[page_title_google_fonts]">
										<option value="-1"><?php esc_html_e( 'Default', 'infographer-core' ); ?></option>
										<?php foreach($fontArrays as $fontArray) { ?> 
											<option <?php if ($options['page_title_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo  esc_attr($fontArray["family"]); ?></option>
										<?php } ?>
									</select>
								</div>
								<div class="inline">
									<?php esc_html_e('Font size (px)', 'infographer-core'); ?>
									<input name="qode_options_infographer[page_title_fontsize]" type="text" value="<?php if ($options['page_title_fontsize']) { echo esc_attr($options['page_title_fontsize']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Line height (px)', 'infographer-core'); ?>
									<input name="qode_options_infographer[page_title_lineheight]" type="text" value="<?php if ($options['page_title_lineheight']) { echo esc_attr($options['page_title_lineheight']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Font style', 'infographer-core'); ?>
									<select name="qode_options_infographer[page_title_fontstyle]">
										<option <?php if ($options['page_title_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
										<option <?php if ($options['page_title_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'infographer-core' ); ?></option>
										<option <?php if ($options['page_title_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'infographer-core' ); ?></option>
										
									</select>
								</div>
								<div class="inline">
									<?php esc_html_e('Font weight', 'infographer-core'); ?>
									<select name="qode_options_infographer[page_title_fontweight]">
										<option <?php if ($options['page_title_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
										<option <?php if ($options['page_title_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200"><?php esc_html_e( '200', 'infographer-core' ); ?></option>
											<option <?php if ($options['page_title_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300"><?php esc_html_e( '300', 'infographer-core' ); ?></option>
											<option <?php if ($options['page_title_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400"><?php esc_html_e( '400', 'infographer-core' ); ?></option>
											<option <?php if ($options['page_title_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500"><?php esc_html_e( '500', 'infographer-core' ); ?></option>
											<option <?php if ($options['page_title_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600"><?php esc_html_e( '600', 'infographer-core' ); ?></option>
											<option <?php if ($options['page_title_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700"><?php esc_html_e( '700', 'infographer-core' ); ?></option>
											<option <?php if ($options['page_title_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800"><?php esc_html_e( '800', 'infographer-core' ); ?></option>
											<option <?php if ($options['page_title_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900"><?php esc_html_e( '900', 'infographer-core' ); ?></option>
										
									</select>
								</div>
							</td>
						</tr>
					</tbody>
				</table>
				<?php		display_save_changes_button(); ?>
			</div>
			<h3>Header, Footer & Menus</h3>
			<div>
				<table class="form-table">
					<tbody>
						<tr><td colspan='2'><h2><?php esc_html_e( 'Header', 'infographer-core' ); ?></h2></td></tr>
						<tr>
							<td valign="middle" width="150"><?php esc_html_e('Hide header', 'infographer-core'); ?></td>
							<td>
								<div class="inline">
									<select name="qode_options_infographer[header_hide]">
										<option <?php if ($options['header_hide'] == "no") { echo "selected='selected'"; } ?> value="no"><?php esc_html_e( 'No', 'infographer-core' ); ?></option>
										<option <?php if ($options['header_hide'] == "yes") { echo "selected='selected'"; } ?> value="yes"><?php esc_html_e( 'Yes', 'infographer-core' ); ?></option>
										
									</select>
								</div>
							</td>
						</tr>
						<tr>
							<td valign="middle" width="150"><?php esc_html_e('Header in grid', 'infographer-core'); ?></td>
							<td>
								<div class="inline">
									<select name="qode_options_infographer[header_in_grid]">
										<option <?php if ($options['header_in_grid'] == "no") { echo "selected='selected'"; } ?> value="no"><?php esc_html_e( 'No', 'infographer-core' ); ?></option>
										<option <?php if ($options['header_in_grid'] == "yes") { echo "selected='selected'"; } ?> value="yes"><?php esc_html_e( 'Yes', 'infographer-core' ); ?></option>
										
									</select>
								</div>
							</td>
						</tr>
						<tr>
							<td valign="middle" width="150"><?php esc_html_e('Fixed header', 'infographer-core'); ?></td>
							<td>
								<div class="inline">
									<select name="qode_options_infographer[header_fixed]">
										<option <?php if ($options['header_fixed'] == "yes") { echo "selected='selected'"; } ?> value="yes"><?php esc_html_e( 'Yes', 'infographer-core' ); ?></option>
										<option <?php if ($options['header_fixed'] == "no") { echo "selected='selected'"; } ?> value="no"><?php esc_html_e( 'No', 'infographer-core' ); ?></option>
									</select>
								</div>
							</td>
						</tr>
						<tr>
							<td valign="middle" width="150"><?php esc_html_e('Show header widget area', 'infographer-core'); ?></td>
							<td>
								<div class="inline">
									<select name="qode_options_infographer[header_widget_area]">
										<option <?php if ($options['header_widget_area'] == "no") { echo "selected='selected'"; } ?> value="no"><?php esc_html_e( 'No', 'infographer-core' ); ?></option>
										<option <?php if ($options['header_widget_area'] == "yes") { echo "selected='selected'"; } ?> value="yes"><?php esc_html_e( 'Yes', 'infographer-core' ); ?></option>
										
									</select>
								</div>
							</td>
						</tr>
						<tr>
							<td scope="row" width="150"><?php esc_html_e('Background color', 'infographer-core'); ?></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Color', 'infographer-core'); ?>
									<div class="colorSelector"><div style="<?php if ($options['header_background_color']){ echo 'background-color:'.esc_attr($options['header_background_color']).';'; } ?>"></div></div>
									<input name="qode_options_infographer[header_background_color]" type="text" value="<?php if ($options['header_background_color']) { echo esc_attr($options['header_background_color']); } ?>" size="10" maxlength="10" />
								</div>
							</td>
						</tr>
						<tr>
							<td valign="top" width="150"><?php esc_html_e('Logo', 'infographer-core'); ?></td>
							<td>
								<div class="inline" style="width: 600px;">
									<?php esc_html_e('Logo image', 'infographer-core'); ?>
									<input type="text" id="logo_image" name="qode_options_infographer[logo_image]" class="logo_image" value="<?php if ($options['logo_image']) { echo esc_attr($options['logo_image']); } else { echo QODE_ROOT."/img/logo.png"; } ?>" size="70">
									<input class="upload_button" type="button" value="Upload file">
								</div>
							</td>
						</tr>
						<tr valign="top">
								<td scope="row" width="150"><?php esc_html_e('Menu position', 'infographer-core'); ?></td>
								<td>
									<div class="inline">
										<select name="qode_options_infographer[menu_position]">
											<option <?php if($options['menu_position'] == "left") { echo "selected='selected'"; } ?> value="left"><?php esc_html_e( 'Left', 'infographer-core' ); ?></option>
											<option <?php if($options['menu_position'] == "right") { echo "selected='selected'"; } ?> value="right"><?php esc_html_e( 'Right', 'infographer-core' ); ?></option>
										</select>
									</div>
								</td>
						</tr>
						<tr valign="top">
								<td scope="row" width="150"><?php esc_html_e('Main menu background color for 2nd and 3rd level', 'infographer-core'); ?></td>
								<td>
									<div class="inline">
										<div class="colorSelector"><div style="<?php if (isset($options['dropdown_background_color'])){ echo 'background-color:'.esc_attr($options['dropdown_background_color']).';'; } ?>"></div></div>
										<input name="qode_options_infographer[dropdown_background_color]" type="text" value="<?php if (isset($options['dropdown_background_color'])) { echo esc_attr($options['dropdown_background_color']); } ?>" size="10" maxlength="10" />
									</div>
								</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('1st level menu style', 'infographer-core'); ?></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Color', 'infographer-core'); ?>
									<div class="colorSelector"><div style="<?php if ($options['menu_color']){ echo 'background-color:'.esc_attr($options['menu_color']).';'; } ?>"></div></div>
									<input name="qode_options_infographer[menu_color]" type="text" value="<?php if ($options['menu_color']) { echo esc_attr($options['menu_color']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Hover color', 'infographer-core'); ?>
									<div class="colorSelector"><div style="<?php if (isset($options['menu_hovercolor'])){ echo 'background-color:'.esc_attr($options['menu_hovercolor']).';'; } ?>"></div></div>
									<input name="qode_options_infographer[menu_hovercolor]" type="text" value="<?php if (isset($options['menu_hovercolor'])) { echo esc_attr($options['menu_hovercolor']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Font family', 'infographer-core'); ?>
									<select name="qode_options_infographer[menu_google_fonts]">
										<option value="-1"><?php esc_html_e( 'Default', 'infographer-core' ); ?></option>
										<?php foreach($fontArrays as $fontArray) { ?> 
											<option <?php if ($options['menu_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo  esc_attr($fontArray["family"]); ?></option>
										<?php } ?>
									</select>
								</div>
								<div class="inline">
									<?php esc_html_e('Font size (px)', 'infographer-core'); ?>
									<input name="qode_options_infographer[menu_fontsize]" type="text" value="<?php if ($options['menu_fontsize']) { echo esc_attr($options['menu_fontsize']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Line height (px)', 'infographer-core'); ?>
									<input name="qode_options_infographer[menu_lineheight]" type="text" value="<?php if ($options['menu_lineheight']) { echo esc_attr($options['menu_lineheight']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Font style', 'infographer-core'); ?>
									<select name="qode_options_infographer[menu_fontstyle]">
										<option <?php if ($options['menu_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
										<option <?php if ($options['menu_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'infographer-core' ); ?></option>
										<option <?php if ($options['menu_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'infographer-core' ); ?></option>
										
									</select>
								</div>
								<div class="inline">
									<?php esc_html_e('Font weight', 'infographer-core'); ?>
									<select name="qode_options_infographer[menu_fontweight]">
										<option <?php if ($options['menu_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
										<option <?php if ($options['menu_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200"><?php esc_html_e( '200', 'infographer-core' ); ?></option>
											<option <?php if ($options['menu_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300"><?php esc_html_e( '300', 'infographer-core' ); ?></option>
											<option <?php if ($options['menu_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400"><?php esc_html_e( '400', 'infographer-core' ); ?></option>
											<option <?php if ($options['menu_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500"><?php esc_html_e( '500', 'infographer-core' ); ?></option>
											<option <?php if ($options['menu_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600"><?php esc_html_e( '600', 'infographer-core' ); ?></option>
											<option <?php if ($options['menu_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700"><?php esc_html_e( '700', 'infographer-core' ); ?></option>
											<option <?php if ($options['menu_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800"><?php esc_html_e( '800', 'infographer-core' ); ?></option>
											<option <?php if ($options['menu_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900"><?php esc_html_e( '900', 'infographer-core' ); ?></option>
										
									</select>
								</div>
								<br/><br/>
								<div class="inline">
									<?php esc_html_e('Background hover color', 'infographer-core'); ?>
									<div class="colorSelector"><div style="<?php if (isset($options['menu_hoverbackgroundcolor'])){ echo 'background-color:'.esc_attr($options['menu_hoverbackgroundcolor']).';'; } ?>"></div></div>
									<input name="qode_options_infographer[menu_hoverbackgroundcolor]" type="text" value="<?php if (isset($options['menu_hoverbackgroundcolor'])) { echo esc_attr($options['menu_hoverbackgroundcolor']); } ?>" size="10" maxlength="10" />
								</div>
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('2nd level menu style', 'infographer-core'); ?></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Color', 'infographer-core'); ?>
									<div class="colorSelector"><div style="<?php if (isset($options['dropdown_color'])){ echo 'background-color:'.esc_attr($options['dropdown_color']).';'; } ?>"></div></div>
									<input name="qode_options_infographer[dropdown_color]" type="text" value="<?php if (isset($options['dropdown_color'])) { echo esc_attr($options['dropdown_color']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Hover color', 'infographer-core'); ?>
									<div class="colorSelector"><div style="<?php if (isset($options['dropdown_hovercolor'])){ echo 'background-color:'.esc_attr($options['dropdown_hovercolor']).';'; } ?>"></div></div>
									<input name="qode_options_infographer[dropdown_hovercolor]" type="text" value="<?php if (isset($options['dropdown_hovercolor'])) { echo esc_attr($options['dropdown_hovercolor']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Font family', 'infographer-core'); ?>
									<select name="qode_options_infographer[dropdown_google_fonts]">
										<option value="-1"><?php esc_html_e( 'Default', 'infographer-core' ); ?></option>
										<?php foreach($fontArrays as $fontArray) { ?> 
											<option <?php if ($options['dropdown_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo  esc_attr($fontArray["family"]); ?></option>
										<?php } ?>
									</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font size (px)', 'infographer-core'); ?>
										<input name="qode_options_infographer[dropdown_fontsize]" type="text" value="<?php if ($options['dropdown_fontsize']) { echo esc_attr($options['dropdown_fontsize']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Line height (px)', 'infographer-core'); ?>
										<input name="qode_options_infographer[dropdown_lineheight]" type="text" value="<?php if ($options['dropdown_lineheight']) { echo esc_attr($options['dropdown_lineheight']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Font style', 'infographer-core'); ?>
										<select name="qode_options_infographer[dropdown_fontstyle]">
											<option <?php if ($options['dropdown_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
											<option <?php if ($options['dropdown_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'infographer-core' ); ?></option>
											<option <?php if ($options['dropdown_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'infographer-core' ); ?></option>
											
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font weight', 'infographer-core'); ?>
										<select name="qode_options_infographer[dropdown_fontweight]">
											<option <?php if ($options['dropdown_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
											<option <?php if ($options['dropdown_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200"><?php esc_html_e( '200', 'infographer-core' ); ?></option>
											<option <?php if ($options['dropdown_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300"><?php esc_html_e( '300', 'infographer-core' ); ?></option>
											<option <?php if ($options['dropdown_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400"><?php esc_html_e( '400', 'infographer-core' ); ?></option>
											<option <?php if ($options['dropdown_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500"><?php esc_html_e( '500', 'infographer-core' ); ?></option>
											<option <?php if ($options['dropdown_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600"><?php esc_html_e( '600', 'infographer-core' ); ?></option>
											<option <?php if ($options['dropdown_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700"><?php esc_html_e( '700', 'infographer-core' ); ?></option>
											<option <?php if ($options['dropdown_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800"><?php esc_html_e( '800', 'infographer-core' ); ?></option>
											<option <?php if ($options['dropdown_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900"><?php esc_html_e( '900', 'infographer-core' ); ?></option>
										</select>
									</div>
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('3rd level menu style', 'infographer-core'); ?></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Color', 'infographer-core'); ?>
									<div class="colorSelector"><div style="<?php if (isset($options['dropdown_color_thirdlvl'])){ echo 'background-color:'.esc_attr($options['dropdown_color_thirdlvl']).';'; } ?>"></div></div>
									<input name="qode_options_infographer[dropdown_color_thirdlvl]" type="text" value="<?php if (isset($options['dropdown_color_thirdlvl'])) { echo esc_attr($options['dropdown_color_thirdlvl']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Hover color', 'infographer-core'); ?>
									<div class="colorSelector"><div style="<?php if (isset($options['dropdown_hovercolor_thirdlvl'])){ echo 'background-color:'.esc_attr($options['dropdown_hovercolor_thirdlvl']).';'; } ?>"></div></div>
									<input name="qode_options_infographer[dropdown_hovercolor_thirdlvl]" type="text" value="<?php if (isset($options['dropdown_hovercolor_thirdlvl'])) { echo esc_attr($options['dropdown_hovercolor_thirdlvl']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Font family', 'infographer-core'); ?>
									<select name="qode_options_infographer[dropdown_google_fonts_thirdlvl]">
										<option value="-1"><?php esc_html_e( 'Default', 'infographer-core' ); ?></option>
										<?php foreach($fontArrays as $fontArray) { ?> 
											<option <?php if(isset($options['dropdown_google_fonts_thirdlvl'])){ $dropdown_google_fonts_thirdlvl = $options['dropdown_google_fonts_thirdlvl']; if ($dropdown_google_fonts_thirdlvl == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo  esc_attr($fontArray["family"]); ?></option>
										<?php } ?>
									</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font size (px)', 'infographer-core'); ?>
										<input name="qode_options_infographer[dropdown_fontsize_thirdlvl]" type="text" value="<?php if (isset($options['dropdown_fontsize_thirdlvl'])) { echo esc_attr($options['dropdown_fontsize_thirdlvl']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Line height (px)', 'infographer-core'); ?>
										<input name="qode_options_infographer[dropdown_lineheight_thirdlvl]" type="text" value="<?php if (isset($options['dropdown_lineheight_thirdlvl'])) { echo esc_attr($options['dropdown_lineheight_thirdlvl']); } ?>" size="10" maxlength="10" />
									</div>
									<div class="inline">
										<?php esc_html_e('Font style', 'infographer-core'); ?>
										<select name="qode_options_infographer[dropdown_fontstyle_thirdlvl]">
											<option <?php if(isset($options['dropdown_fontstyle_thirdlvl'])){ $dropdown_fontstyle_thirdlvl = $options['dropdown_fontstyle_thirdlvl']; if ($dropdown_fontstyle_thirdlvl == '') { echo "selected='selected'"; } } ?> value=""></option>
											<option <?php if(isset($options['dropdown_fontstyle_thirdlvl'])){ $dropdown_fontstyle_thirdlvl = $options['dropdown_fontstyle_thirdlvl']; if ($dropdown_fontstyle_thirdlvl == 'normal') { echo "selected='selected'"; } } ?> value="normal"><?php esc_html_e( 'normal', 'infographer-core' ); ?></option>
											<option <?php if(isset($options['dropdown_fontstyle_thirdlvl'])){ $dropdown_fontstyle_thirdlvl = $options['dropdown_fontstyle_thirdlvl']; if ($dropdown_fontstyle_thirdlvl == 'italic') { echo "selected='selected'"; } } ?> value="italic"><?php esc_html_e( 'italic', 'infographer-core' ); ?></option>
										</select>
									</div>
									<div class="inline">
										<?php esc_html_e('Font weight', 'infographer-core'); ?>
										<select name="qode_options_infographer[dropdown_fontweight_thirdlvl]">
											<option <?php if(isset($options['dropdown_fontweight_thirdlvl'])){ $dropdown_fontweight_thirdlvl = $options['dropdown_fontweight_thirdlvl']; if ($dropdown_fontweight_thirdlvl == '') { echo "selected='selected'"; } } ?> value=""></option>
											<option <?php if(isset($options['dropdown_fontweight_thirdlvl'])){ $dropdown_fontweight_thirdlvl = $options['dropdown_fontweight_thirdlvl']; if ($dropdown_fontweight_thirdlvl == '200') { echo "selected='selected'"; } } ?> value="200"><?php esc_html_e( '200', 'infographer-core' ); ?></option>
											<option <?php if(isset($options['dropdown_fontweight_thirdlvl'])){ $dropdown_fontweight_thirdlvl = $options['dropdown_fontweight_thirdlvl']; if ($dropdown_fontweight_thirdlvl == '300') { echo "selected='selected'"; } } ?> value="300"><?php esc_html_e( '300', 'infographer-core' ); ?></option>
											<option <?php if(isset($options['dropdown_fontweight_thirdlvl'])){ $dropdown_fontweight_thirdlvl = $options['dropdown_fontweight_thirdlvl']; if ($dropdown_fontweight_thirdlvl == '400') { echo "selected='selected'"; } } ?> value="400"><?php esc_html_e( '400', 'infographer-core' ); ?></option>
											<option <?php if(isset($options['dropdown_fontweight_thirdlvl'])){ $dropdown_fontweight_thirdlvl = $options['dropdown_fontweight_thirdlvl']; if ($dropdown_fontweight_thirdlvl == '500') { echo "selected='selected'"; } } ?> value="500"><?php esc_html_e( '500', 'infographer-core' ); ?></option>
											<option <?php if(isset($options['dropdown_fontweight_thirdlvl'])){ $dropdown_fontweight_thirdlvl = $options['dropdown_fontweight_thirdlvl']; if ($dropdown_fontweight_thirdlvl == '600') { echo "selected='selected'"; } } ?> value="600"><?php esc_html_e( '600', 'infographer-core' ); ?></option>
											<option <?php if(isset($options['dropdown_fontweight_thirdlvl'])){ $dropdown_fontweight_thirdlvl = $options['dropdown_fontweight_thirdlvl']; if ($dropdown_fontweight_thirdlvl == '700') { echo "selected='selected'"; } } ?> value="700"><?php esc_html_e( '700', 'infographer-core' ); ?></option>
											<option <?php if(isset($options['dropdown_fontweight_thirdlvl'])){ $dropdown_fontweight_thirdlvl = $options['dropdown_fontweight_thirdlvl']; if ($dropdown_fontweight_thirdlvl == '800') { echo "selected='selected'"; } } ?> value="800"><?php esc_html_e( '800', 'infographer-core' ); ?></option>
											<option <?php if(isset($options['dropdown_fontweight_thirdlvl'])){ $dropdown_fontweight_thirdlvl = $options['dropdown_fontweight_thirdlvl']; if ($dropdown_fontweight_thirdlvl == '900') { echo "selected='selected'"; } } ?> value="900"><?php esc_html_e( '900', 'infographer-core' ); ?></option>
										</select>
									</div>
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Title', 'infographer-core'); ?></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Responsive title image', 'infographer-core'); ?>
									<select name="qode_options_infographer[responsive_title_image]">
										<option <?php if(isset($options['responsive_title_image'])){ $responsive_title_image = $options['responsive_title_image']; if ($responsive_title_image == 'no') { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'infographer-core' ); ?></option>
										<option <?php if(isset($options['responsive_title_image'])){ $responsive_title_image = $options['responsive_title_image']; if ($responsive_title_image == 'yes') { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'infographer-core' ); ?></option>
									</select>
								</div>
								<div class="inline" style="width: 600px;">
									<?php esc_html_e('Title image', 'infographer-core'); ?>
									<input type="text" id="title_image" name="qode_options_infographer[title_image]" class="title_image" value="<?php if (isset($options['title_image'])) { echo esc_attr($options['title_image']); } ?>" size="70">
									<input class="upload_button" type="button" value="Upload file">
								</div>
								<br/><br/>
								<div class="inline">
									<?php esc_html_e('Fixed title image', 'infographer-core'); ?>
									<select name="qode_options_infographer[fixed_title_image]">
										<option <?php if(isset($options['fixed_title_image'])){ $fixed_title_image = $options['fixed_title_image']; if ($fixed_title_image == 'no') { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'infographer-core' ); ?></option>
										<option <?php if(isset($options['fixed_title_image'])){ $fixed_title_image = $options['fixed_title_image']; if ($fixed_title_image == 'yes') { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'infographer-core' ); ?></option>
									</select>
									<?php esc_html_e('Only if title image is not responsive', 'infographer-core'); ?>
								</div>
								<div class="inline">
									<?php esc_html_e('Title height (px)', 'infographer-core'); ?>
									<input name="qode_options_infographer[title_height]" type="text" value="<?php if (isset($options['title_height'])) { echo esc_attr($options['title_height']); } ?>" size="10" maxlength="10" />
									<?php esc_html_e('Only if title image is not responsive', 'infographer-core'); ?>
								</div>
								<br/><br/>
								<div class="inline">
									<?php esc_html_e('Title position', 'infographer-core'); ?>
									<select name="qode_options_infographer[page_title_position]">
										<option <?php if ($options['page_title_position'] == 0) { echo "selected='selected'"; } ?> value="0"></option>
										<option <?php if ($options['page_title_position'] == 1) { echo "selected='selected'"; } ?> value="1"><?php esc_html_e( 'Left', 'infographer-core' ); ?></option>
										<option <?php if ($options['page_title_position'] == 2) { echo "selected='selected'"; } ?> value="2"><?php esc_html_e( 'Center', 'infographer-core' ); ?></option>
										<option <?php if ($options['page_title_position'] == 3) { echo "selected='selected'"; } ?> value="3"><?php esc_html_e( 'Right', 'infographer-core' ); ?></option>
									</select>
								</div>
								<div class="inline">
									<?php esc_html_e('Title in grid', 'infographer-core'); ?>
									<select name="qode_options_infographer[title_in_grid]">
										<option <?php if(isset($options['title_in_grid'])){ $title_in_grid = $options['title_in_grid']; if ($title_in_grid == 'no') { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'infographer-core' ); ?></option>
										<option <?php if(isset($options['title_in_grid'])){ $title_in_grid = $options['title_in_grid']; if ($title_in_grid == 'yes') { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'infographer-core' ); ?></option>
									</select>
								</div>
							</td>
						</tr>
						<tr><td colspan='2'><h2><?php esc_html_e( 'Footer', 'infographer-core' ); ?></h2></td></tr>
						<tr>
							<td valign="middle" width="150"><?php esc_html_e('Show footer top', 'infographer-core'); ?></td>
							<td>
								<div class="inline">
									<select name="qode_options_infographer[footer_widget_area]">
										<option <?php if ($options['footer_widget_area'] == "no") { echo "selected='selected'"; } ?> value="no"><?php esc_html_e( 'No', 'infographer-core' ); ?></option>
										<option <?php if ($options['footer_widget_area'] == "yes") { echo "selected='selected'"; } ?> value="yes"><?php esc_html_e( 'Yes', 'infographer-core' ); ?></option>
										
									</select>
								</div>
							</td>
						</tr>
						<tr>
							<td valign="middle" width="150"><?php esc_html_e('Show footer bottom', 'infographer-core'); ?></td>
							<td>
								<div class="inline">
									<select name="qode_options_infographer[footer_text]">
										<option <?php if ($options['footer_text'] == "no") { echo "selected='selected'"; } ?> value="no"><?php esc_html_e( 'No', 'infographer-core' ); ?></option>
										<option <?php if ($options['footer_text'] == "yes") { echo "selected='selected'"; } ?> value="yes"><?php esc_html_e( 'Yes', 'infographer-core' ); ?></option>
										
									</select>
								</div>
							</td>
						</tr>
						<tr>
							<td scope="row" width="150"><?php esc_html_e('Footer top colors', 'infographer-core'); ?></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Title color', 'infographer-core'); ?>
									<div class="colorSelector"><div style="<?php if ($options['footer_top_title_color']){ echo 'background-color:'.esc_attr($options['footer_top_title_color']).';'; } ?>"></div></div>
									<input name="qode_options_infographer[footer_top_title_color]" type="text" value="<?php if ($options['footer_top_title_color']) { echo esc_attr($options['footer_top_title_color']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Text color', 'infographer-core'); ?>
									<div class="colorSelector"><div style="<?php if ($options['footer_top_text_color']){ echo 'background-color:'.esc_attr($options['footer_top_text_color']).';'; } ?>"></div></div>
									<input name="qode_options_infographer[footer_top_text_color]" type="text" value="<?php if ($options['footer_top_text_color']) { echo esc_attr($options['footer_top_text_color']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Background color', 'infographer-core'); ?>
									<div class="colorSelector"><div style="<?php if ($options['footer_top_background_color']){ echo 'background-color:'.esc_attr($options['footer_top_background_color']).';'; } ?>"></div></div>
									<input name="qode_options_infographer[footer_top_background_color]" type="text" value="<?php if ($options['footer_top_background_color']) { echo esc_attr($options['footer_top_background_color']); } ?>" size="10" maxlength="10" />
								</div>
							</td>
						</tr>
						<tr>
							<td scope="row" width="150"><?php esc_html_e('Footer bottom colors', 'infographer-core'); ?></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Text color', 'infographer-core'); ?>
									<div class="colorSelector"><div style="<?php if ($options['footer_bottom_text_color']){ echo 'background-color:'.esc_attr($options['footer_bottom_text_color']).';'; } ?>"></div></div>
									<input name="qode_options_infographer[footer_bottom_text_color]" type="text" value="<?php if ($options['footer_bottom_text_color']) { echo esc_attr($options['footer_bottom_text_color']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Background color', 'infographer-core'); ?>
									<div class="colorSelector"><div style="<?php if ($options['footer_bottom_background_color']){ echo 'background-color:'.esc_attr($options['footer_bottom_background_color']).';'; } ?>"></div></div>
									<input name="qode_options_infographer[footer_bottom_background_color]" type="text" value="<?php if ($options['footer_bottom_background_color']) { echo esc_attr($options['footer_bottom_background_color']); } ?>" size="10" maxlength="10" />
								</div>
							</td>
						</tr>
						<tr><td colspan='2'><h2><?php esc_html_e( 'Content Menu', 'infographer-core' ); ?></h2></td></tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Content menu style', 'infographer-core'); ?></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Color', 'infographer-core'); ?>
									<div class="colorSelector"><div style="<?php if ($options['content_menu_color']){ echo 'background-color:'.esc_attr($options['content_menu_color']).';'; } ?>"></div></div>
									<input name="qode_options_infographer[content_menu_color]" type="text" value="<?php if ($options['content_menu_color']) { echo esc_attr($options['content_menu_color']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Hover color', 'infographer-core'); ?>
									<div class="colorSelector"><div style="<?php if (isset($options['content_menu_hovercolor'])){ echo 'background-color:'.esc_attr($options['content_menu_hovercolor']).';'; } ?>"></div></div>
									<input name="qode_options_infographer[content_menu_hovercolor]" type="text" value="<?php if (isset($options['content_menu_hovercolor'])) { echo esc_attr($options['content_menu_hovercolor']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Font family', 'infographer-core'); ?>
									<select name="qode_options_infographer[content_menu_google_fonts]">
										<option value="-1"><?php esc_html_e( 'Default', 'infographer-core' ); ?></option>
										<?php foreach($fontArrays as $fontArray) { ?> 
											<option <?php if ($options['content_menu_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo  esc_attr($fontArray["family"]); ?></option>
										<?php } ?>
									</select>
								</div>
								<div class="inline">
									<?php esc_html_e('Font size (px)', 'infographer-core'); ?>
									<input name="qode_options_infographer[content_menu_fontsize]" type="text" value="<?php if ($options['content_menu_fontsize']) { echo esc_attr($options['content_menu_fontsize']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Line height (px)', 'infographer-core'); ?>
									<input name="qode_options_infographer[content_menu_lineheight]" type="text" value="<?php if ($options['content_menu_lineheight']) { echo esc_attr($options['content_menu_lineheight']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Font style', 'infographer-core'); ?>
									<select name="qode_options_infographer[content_menu_fontstyle]">
										<option <?php if ($options['content_menu_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
										<option <?php if ($options['content_menu_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'infographer-core' ); ?></option>
										<option <?php if ($options['content_menu_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'infographer-core' ); ?></option>
										
									</select>
								</div>
								<div class="inline">
									<?php esc_html_e('Font weight', 'infographer-core'); ?>
									<select name="qode_options_infographer[content_menu_fontweight]">
										<option <?php if ($options['content_menu_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
										<option <?php if ($options['content_menu_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200"><?php esc_html_e( '200', 'infographer-core' ); ?></option>
											<option <?php if ($options['content_menu_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300"><?php esc_html_e( '300', 'infographer-core' ); ?></option>
											<option <?php if ($options['content_menu_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400"><?php esc_html_e( '400', 'infographer-core' ); ?></option>
											<option <?php if ($options['content_menu_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500"><?php esc_html_e( '500', 'infographer-core' ); ?></option>
											<option <?php if ($options['content_menu_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600"><?php esc_html_e( '600', 'infographer-core' ); ?></option>
											<option <?php if ($options['content_menu_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700"><?php esc_html_e( '700', 'infographer-core' ); ?></option>
											<option <?php if ($options['content_menu_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800"><?php esc_html_e( '800', 'infographer-core' ); ?></option>
											<option <?php if ($options['content_menu_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900"><?php esc_html_e( '900', 'infographer-core' ); ?></option>
										
									</select>
								</div>
								<br/><br/>
								<div class="inline">
									<?php esc_html_e('Background color', 'infographer-core'); ?>
									<div class="colorSelector"><div style="<?php if (isset($options['content_menu_backgroundcolor'])){ echo 'background-color:'.esc_attr($options['content_menu_backgroundcolor']).';'; } ?>"></div></div>
									<input name="qode_options_infographer[content_menu_backgroundcolor]" type="text" value="<?php if (isset($options['content_menu_backgroundcolor'])) { echo esc_attr($options['content_menu_backgroundcolor']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Position', 'infographer-core'); ?>
									<select name="qode_options_infographer[content_menu_position]">
										<option <?php if(isset($options['content_menu_position'])){ $content_menu_position = $options['content_menu_position']; if ($content_menu_position == "center") { echo "selected='selected'"; } } ?> value="center"><?php esc_html_e( 'Center', 'infographer-core' ); ?></option>
										<option <?php if(isset($options['content_menu_position'])){ $content_menu_position = $options['content_menu_position']; if ($content_menu_position == "left") { echo "selected='selected'"; } } ?> value="left"><?php esc_html_e( 'Left', 'infographer-core' ); ?></option>
									</select>
								</div>
							</td>
						</tr>
					</tbody>
				</table>
				<?php		display_save_changes_button(); ?>
			</div>
			<h3><?php esc_html_e( 'Elements', 'infographer-core' ); ?></h3>
			<div>
				<table class="form-table">
					<tbody>
						<tr><td colspan='2'><h2><?php esc_html_e( 'Separator', 'infographer-core' ); ?></h2></td></tr>
						<tr valign="middle">
							<td valign="middle"><?php esc_html_e('Default separator', 'infographer-core'); ?></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Color', 'infographer-core'); ?>
									<div class="colorSelector"><div style="<?php if (isset($options['separator_color'])){ echo 'background-color:'.esc_attr($options['separator_color']).';'; } ?>"></div></div>
									<input name="qode_options_infographer[separator_color]" type="text" value="<?php if (isset($options['separator_color'])) { echo esc_attr($options['separator_color']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Thickness (px)', 'infographer-core'); ?>
									<input name="qode_options_infographer[separator_thickness]" type="text" value="<?php if ($options['separator_thickness']) { echo esc_attr($options['separator_thickness']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Top margin (px)', 'infographer-core'); ?>
									<input name="qode_options_infographer[separator_topmargin]" type="text" value="<?php if ($options['separator_topmargin']) { echo esc_attr($options['separator_topmargin']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Bottom margin (px)', 'infographer-core'); ?>
									<input name="qode_options_infographer[separator_bottommargin]" type="text" value="<?php if ($options['separator_bottommargin']) { echo esc_attr($options['separator_bottommargin']); } ?>" size="10" maxlength="10" />
								</div>
							</td>
						</tr>
						<tr valign="middle">
							<td valign="middle"><?php esc_html_e('Pattern separator', 'infographer-core'); ?></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Color', 'infographer-core'); ?>
									<div class="colorSelector"><div style="<?php if (isset($options['separator_pattern_color'])){ echo 'background-color:'.esc_attr($options['separator_pattern_color']).';'; } ?>"></div></div>
									<input name="qode_options_infographer[separator_pattern_color]" type="text" value="<?php if (isset($options['separator_pattern_color'])) { echo esc_attr($options['separator_pattern_color']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Top margin (px)', 'infographer-core'); ?>
									<input name="qode_options_infographer[separator_pattern_topmargin]" type="text" value="<?php if ($options['separator_pattern_topmargin']) { echo esc_attr($options['separator_pattern_topmargin']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Bottom margin (px)', 'infographer-core'); ?>
									<input name="qode_options_infographer[separator_pattern_bottommargin]" type="text" value="<?php if ($options['separator_pattern_bottommargin']) { echo esc_attr($options['separator_pattern_bottommargin']); } ?>" size="10" maxlength="10" />
								</div>
							</td>
						</tr>
						<tr><td colspan='2'><h2><?php esc_html_e( 'Buttons', 'infographer-core' ); ?></h2></td></tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Button style', 'infographer-core'); ?></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Color', 'infographer-core'); ?>
									<div class="colorSelector"><div style="<?php if ($options['button_title_color']){ echo 'background-color:'.esc_attr($options['button_title_color']).';'; } ?>"></div></div>
									<input name="qode_options_infographer[button_title_color]" type="text" value="<?php if ($options['button_title_color']) { echo esc_attr($options['button_title_color']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Hover color', 'infographer-core'); ?>
									<div class="colorSelector"><div style="<?php if ($options['button_title_hovercolor']){ echo 'background-color:'.esc_attr($options['button_title_hovercolor']).';'; } ?>"></div></div>
									<input name="qode_options_infographer[button_title_hovercolor]" type="text" value="<?php if ($options['button_title_hovercolor']) { echo esc_attr($options['button_title_hovercolor']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Font family', 'infographer-core'); ?>
									<select name="qode_options_infographer[button_title_google_fonts]">
										<option value="-1"><?php esc_html_e( 'Default', 'infographer-core' ); ?></option>
										<?php foreach($fontArrays as $fontArray) { ?> 
											<option <?php if ($options['button_title_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo  esc_attr($fontArray["family"]); ?></option>
										<?php } ?>
									</select>
								</div>
								<div class="inline">
									<?php esc_html_e('Font size (px)', 'infographer-core'); ?>
									<input name="qode_options_infographer[button_title_fontsize]" type="text" value="<?php if ($options['button_title_fontsize']) { echo esc_attr($options['button_title_fontsize']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Line height (px)', 'infographer-core'); ?>
									<input name="qode_options_infographer[button_title_lineheight]" type="text" value="<?php if ($options['button_title_lineheight']) { echo esc_attr($options['button_title_lineheight']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Font style', 'infographer-core'); ?>
									<select name="qode_options_infographer[button_title_fontstyle]">
										<option <?php if ($options['button_title_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
										<option <?php if ($options['button_title_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'infographer-core' ); ?></option>
										<option <?php if ($options['button_title_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'infographer-core' ); ?></option>
										
									</select>
								</div>
								<div class="inline">
									<?php esc_html_e('Font weight', 'infographer-core'); ?>
									<select name="qode_options_infographer[button_title_fontweight]">
										<option <?php if ($options['button_title_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
										<option <?php if ($options['button_title_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200"><?php esc_html_e( '200', 'infographer-core' ); ?></option>
										<option <?php if ($options['button_title_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300"><?php esc_html_e( '300', 'infographer-core' ); ?></option>
										<option <?php if ($options['button_title_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400"><?php esc_html_e( '400', 'infographer-core' ); ?></option>
										<option <?php if ($options['button_title_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500"><?php esc_html_e( '500', 'infographer-core' ); ?></option>
										<option <?php if ($options['button_title_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600"><?php esc_html_e( '600', 'infographer-core' ); ?></option>
										<option <?php if ($options['button_title_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700"><?php esc_html_e( '700', 'infographer-core' ); ?></option>
										<option <?php if ($options['button_title_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800"><?php esc_html_e( '800', 'infographer-core' ); ?></option>
										<option <?php if ($options['button_title_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900"><?php esc_html_e( '900', 'infographer-core' ); ?></option>
										
									</select>
								</div>
								<br/><br/>
								<div class="inline">
									<?php esc_html_e('Background color', 'infographer-core'); ?>
									<div class="colorSelector"><div style="<?php if ($options['button_backgroundcolor']){ echo 'background-color:'.esc_attr($options['button_backgroundcolor']).';'; } ?>"></div></div>
									<input name="qode_options_infographer[button_backgroundcolor]" type="text" value="<?php if ($options['button_backgroundcolor']) { echo esc_attr($options['button_backgroundcolor']); } ?>" size="10" maxlength="10" />
								</div>
							</td>
						</tr>
						<tr><td colspan='2'><h2><?php esc_html_e( 'Message box', 'infographer-core' ); ?></h2></td></tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Message box style', 'infographer-core'); ?></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Color', 'infographer-core'); ?>
									<div class="colorSelector"><div style="<?php if ($options['message_title_color']){ echo 'background-color:'.esc_attr($options['message_title_color']).';'; } ?>"></div></div>
									<input name="qode_options_infographer[message_title_color]" type="text" value="<?php if ($options['message_title_color']) { echo esc_attr($options['message_title_color']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Background color', 'infographer-core'); ?>
									<div class="colorSelector"><div style="<?php if ($options['message_backgroundcolor']){ echo 'background-color:'.esc_attr($options['message_backgroundcolor']).';'; } ?>"></div></div>
									<input name="qode_options_infographer[message_backgroundcolor]" type="text" class="colorpicker-input" value="<?php if ($options['message_backgroundcolor']) { echo esc_attr($options['message_backgroundcolor']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Font family', 'infographer-core'); ?>
									<select name="qode_options_infographer[message_title_google_fonts]">
										<option value="-1"><?php esc_html_e( 'Default', 'infographer-core' ); ?></option>
										<?php foreach($fontArrays as $fontArray) { ?> 
											<option <?php if ($options['message_title_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo  esc_attr($fontArray["family"]); ?></option>
										<?php } ?>
									</select>
								</div>
							</td>
						</tr>
						<tr><td colspan='2'><h2><?php esc_html_e( 'Blockquote', 'infographer-core' ); ?></h2></td></tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Blockquote style', 'infographer-core'); ?></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Text color', 'infographer-core'); ?>
									<div class="colorSelector"><div style="<?php if ($options['blockquote_font_color']){ echo 'background-color:'.esc_attr($options['blockquote_font_color']).';'; } ?>"></div></div>
									<input name="qode_options_infographer[blockquote_font_color]" type="text" value="<?php if ($options['blockquote_font_color']) { echo esc_attr($options['blockquote_font_color']); } ?>" size="10" maxlength="10" />
								</div>
								<div class="inline">
									<?php esc_html_e('Background color', 'infographer-core'); ?>
									<div class="colorSelector"><div style="<?php if ($options['blockquote_background_color']){ echo 'background-color:'.esc_attr($options['blockquote_background_color']).';'; } ?>"></div></div>
									<input name="qode_options_infographer[blockquote_background_color]" type="text" value="<?php if ($options['blockquote_background_color']) { echo esc_attr($options['blockquote_background_color']); } ?>" size="10" maxlength="10" />
								</div>
							</td>
						</tr>
					</tbody>
				</table>
				<?php		display_save_changes_button(); ?>
			</div>
			<h3><?php esc_html_e( 'Parallax', 'infographer-core' ); ?></h3>
			<div>
				<table class="form-table">
					<tbody>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Parallax speed', 'infographer-core'); ?></td>
							<td>
								<div class="inline">
									<input name="qode_options_infographer[parallax_speed]" type="text" value="<?php if ($options['parallax_speed']) { echo esc_attr($options['parallax_speed']); } ?>" size="10" maxlength="10" />
								</div>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Parallax on touch devices', 'infographer-core'); ?></td>
							<td>
								<div class="inline">
									<select name="qode_options_infographer[parallax_onoff]">
									<option <?php if ($options['parallax_onoff'] == "on") { echo "selected='selected'"; } ?> value="on"><?php esc_html_e( 'on', 'infographer-core' ); ?></option>
									<option <?php if ($options['parallax_onoff'] == "off") { echo "selected='selected'"; } ?> value="off"><?php esc_html_e( 'off', 'infographer-core' ); ?></option>
								</select>
								</div>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Parallax min height (px)', 'infographer-core'); ?></td>
							<td>
								<div class="inline">
									<input name="qode_options_infographer[parallax_minheight]" type="text" value="<?php if ($options['parallax_minheight']) { echo esc_attr($options['parallax_minheight']); } ?>" size="10" maxlength="10" />
									<?php esc_html_e('Set min-height for last two stages', 'infographer-core'); ?>
								</div>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
			<h3><?php esc_html_e( 'Portfolio', 'infographer-core' ); ?></h3>
			<div>
				<table class="form-table">
					<tbody>
						<tr><td colspan='2'><h2><?php esc_html_e( 'Portfolio single', 'infographer-core' ); ?></h2></td></tr>
						<tr>
							<td scope="row" width="150"><?php esc_html_e('Background color', 'infographer-core'); ?></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Color', 'infographer-core'); ?>
									<div class="colorSelector"><div style="<?php if ($options['portfolio_background_color']){ echo 'background-color:'.esc_attr($options['portfolio_background_color']).';'; } ?>"></div></div>
									<input name="qode_options_infographer[portfolio_background_color]" type="text" value="<?php if (isset($options['portfolio_background_color'])) { echo esc_attr($options['portfolio_background_color']); } ?>" size="10" maxlength="10" />
								</div>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Portfolio style', 'infographer-core'); ?></td>
							<td>
								<select name="qode_options_infographer[portfolio_style]">
									<option <?php if ($options['portfolio_style'] == 1) { echo "selected='selected'"; } ?> value="1"><?php esc_html_e( 'Portfolio style 1', 'infographer-core' ); ?></option>
									<option <?php if ($options['portfolio_style'] == 2) { echo "selected='selected'"; } ?> value="2"><?php esc_html_e( 'Portfolio style 2', 'infographer-core' ); ?></option>
									<option <?php if ($options['portfolio_style'] == 3) { echo "selected='selected'"; } ?> value="3"><?php esc_html_e( 'Portfolio style 3', 'infographer-core' ); ?></option>
									<option <?php if ($options['portfolio_style'] == 4) { echo "selected='selected'"; } ?> value="4"><?php esc_html_e( 'Portfolio style 4', 'infographer-core' ); ?></option>
									<option <?php if ($options['portfolio_style'] == 5) { echo "selected='selected'"; } ?> value="5"><?php esc_html_e( 'Portfolio style 5', 'infographer-core' ); ?></option>
								</select>
							</td>
						</tr>
					</tbody>
				</table>
				<?php		display_save_changes_button(); ?>
			</div>
			<h3><?php esc_html_e( 'Blog', 'infographer-core' ); ?></h3>
			<div>
				<table class="form-table">
					<tbody>
						<tr>
							<td scope="row" width="150"><?php esc_html_e('Background color', 'infographer-core'); ?></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Color', 'infographer-core'); ?>
									<div class="colorSelector"><div style="<?php if ($options['blog_background_color']){ echo 'background-color:'.esc_attr($options['blog_background_color']).';'; } ?>"></div></div>
									<input name="qode_options_infographer[blog_background_color]" type="text" value="<?php if (isset($options['blog_background_color'])) { echo esc_attr($options['blog_background_color']); } ?>" size="10" maxlength="10" />
								</div>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Pagination', 'infographer-core'); ?></td>
							<td>
								<select name="qode_options_infographer[pagination]">
									<option <?php if ($options['pagination'] == 0) { echo "selected='selected'"; } ?> value="0"><?php esc_html_e( 'No', 'infographer-core' ); ?></option>
									<option <?php if ($options['pagination'] == 1) { echo "selected='selected'"; } ?> value="1"><?php esc_html_e( 'Yes', 'infographer-core' ); ?></option>
								</select>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Blog list style', 'infographer-core'); ?></td>
							<td>
								<select name="qode_options_infographer[blog_style]">
									<option <?php if ($options['blog_style'] == 1) { echo "selected='selected'"; } ?> value="1"><?php esc_html_e( 'Blog style 1', 'infographer-core' ); ?></option>
									<option <?php if ($options['blog_style'] == 2) { echo "selected='selected'"; } ?> value="2"><?php esc_html_e( 'Blog style 2', 'infographer-core' ); ?></option>
									<option <?php if ($options['blog_style'] == 3) { echo "selected='selected'"; } ?> value="3"><?php esc_html_e( 'Blog style 3', 'infographer-core' ); ?></option>
								</select>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Blog sidebar', 'infographer-core'); ?></td>
							<td>
								<select name="qode_options_infographer[category_blog_sidebar]">
									<option <?php if ($options['category_blog_sidebar'] == "default") { echo "selected='selected'"; } ?> value="default"><?php esc_html_e( 'No Sidebar', 'infographer-core' ); ?></option>
									<option <?php if ($options['category_blog_sidebar'] == 1) { echo "selected='selected'"; } ?> value="1"><?php esc_html_e( 'Sidebar 1/3 right', 'infographer-core' ); ?></option>
									<option <?php if ($options['category_blog_sidebar'] == 2) { echo "selected='selected'"; } ?> value="2"><?php esc_html_e( 'Sidebar 1/4 right', 'infographer-core' ); ?></option>
									<option <?php if ($options['category_blog_sidebar'] == 3) { echo "selected='selected'"; } ?> value="3"><?php esc_html_e( 'Sidebar 1/3 left', 'infographer-core' ); ?></option>
									<option <?php if ($options['category_blog_sidebar'] == 4) { echo "selected='selected'"; } ?> value="4"><?php esc_html_e( 'Sidebar 1/4 left', 'infographer-core' ); ?></option>
									
								</select>
								<?php esc_html_e('Choose category sidebar', 'infographer-core'); ?>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Hide comments', 'infographer-core'); ?></td>
							<td>
								<select name="qode_options_infographer[blog_hide_comments]">
									<option <?php if(isset($options['blog_hide_comments'])){ $blog_hide_comments = $options['blog_hide_comments']; if ($blog_hide_comments == 'no') { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'infographer-core' ); ?></option>
									<option <?php if(isset($options['blog_hide_comments'])){ $blog_hide_comments = $options['blog_hide_comments']; if ($blog_hide_comments == 'yes') { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'infographer-core' ); ?></option>
								</select>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Number of characters', 'infographer-core'); ?></td>
							<td>
								<input name="qode_options_infographer[number_of_chars]" type="text" class="colorpicker-input" value="<?php if ($options['number_of_chars']) { echo esc_attr($options['number_of_chars']); } ?>" size="10" maxlength="10" />
								<?php esc_html_e('Number of characters in blog listing', 'infographer-core'); ?>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Enable back to previous', 'infographer-core'); ?></td>
							<td>
								<select name="qode_options_infographer[back_to_previous]">
									<option <?php if(isset($options['back_to_previous'])){ $back_to_previous = $options['back_to_previous']; if ($back_to_previous == 'no') { echo "selected='selected'"; } }  ?> value="no"><?php esc_html_e( 'No', 'infographer-core' ); ?></option>
									<option <?php if(isset($options['back_to_previous'])){ $back_to_previous = $options['back_to_previous']; if ($back_to_previous == 'yes') { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'infographer-core' ); ?></option>
								</select>
								<?php esc_html_e('Enable back to previous button in single post', 'infographer-core'); ?>
							</td>
						</tr>
					</tbody>
				</table>
				<?php		display_save_changes_button(); ?>
			</div>
			<h3><?php esc_html_e( 'Contact page', 'infographer-core' ); ?></h3>
			<div>
				<table class="form-table">
					<tbody>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Mail send to', 'infographer-core'); ?></td>
							<td>
								<input name="qode_options_infographer[receive_mail]" type="text" value="<?php if ($options['receive_mail']) { echo esc_attr($options['receive_mail']); } ?>"  />
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Enable Contact Form', 'infographer-core'); ?></td>
							<td>
								<select name="qode_options_infographer[enable_contact_form]">
									<option <?php if ($options['enable_contact_form'] == "no") { echo "selected='selected'"; } ?> value="no"><?php esc_html_e( 'No', 'infographer-core' ); ?></option>
									<option <?php if ($options['enable_contact_form'] == "yes") { echo "selected='selected'"; } ?> value="yes"><?php esc_html_e( 'Yes', 'infographer-core' ); ?></option>
								</select>
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Hide Website Field', 'infographer-core'); ?></td>
							<td>
								<select name="qode_options_infographer[hide_contact_form_website]">
									<option <?php if(isset($options['hide_contact_form_website'])){ $hide_contact_form_website = $options['hide_contact_form_website']; if ($hide_contact_form_website == 'no') { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'infographer-core' ); ?></option>
									<option <?php if(isset($options['hide_contact_form_website'])){ $hide_contact_form_website = $options['hide_contact_form_website']; if ($hide_contact_form_website == 'yes') { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'infographer-core' ); ?></option>
								</select>
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Email From', 'infographer-core'); ?></td>
							<td>
								<input name="qode_options_infographer[email_from]" type="text" value="<?php if ($options['email_from']) { echo esc_attr($options['email_from']); } ?>"  />
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Email Subject', 'infographer-core'); ?></td>
							<td>
								<input name="qode_options_infographer[email_subject]" type="text" value="<?php if ($options['email_subject']) { echo esc_attr($options['email_subject']); } ?>"  />
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Use reCaptcha', 'infographer-core'); ?></td>
							<td>
								<select name="qode_options_infographer[use_recaptcha]">
									<option <?php if ($options['use_recaptcha'] == "no") { echo "selected='selected'"; } ?> value="no"><?php esc_html_e( 'No', 'infographer-core' ); ?></option>
									<option <?php if ($options['use_recaptcha'] == "yes") { echo "selected='selected'"; } ?> value="yes"><?php esc_html_e( 'Yes', 'infographer-core' ); ?></option>
								</select>
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('ReCaptcha public key', 'infographer-core'); ?></td>
							<td>
								<input name="qode_options_infographer[recaptcha_public_key]" type="text" value="<?php if ($options['recaptcha_public_key']) { echo esc_attr($options['recaptcha_public_key']); } ?>"  />
							
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('ReCaptcha private key', 'infographer-core'); ?></td>
							<td>
								<input name="qode_options_infographer[recaptcha_private_key]" type="text" value="<?php if ($options['recaptcha_private_key']) { echo esc_attr($options['recaptcha_private_key']); } ?>"  />
							</td>
						</tr>			
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Heading above contact form', 'infographer-core'); ?></td>
							<td>
								<input name="qode_options_infographer[contact_heading_above]" type="text" value="<?php if ($options['contact_heading_above']) { echo esc_attr($options['contact_heading_above']); } ?>"  />
							</td>
						</tr>
						<tr valign="top">
							<td scope="row"><?php esc_html_e('Text above contact form', 'infographer-core'); ?></td>
							<td>
								<input name="qode_options_infographer[contact_text_above]" size="150" type="text" value="<?php if (isset($options['contact_text_above'])) { echo esc_attr($options['contact_text_above']); } ?>"  />
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Enable Google Map', 'infographer-core'); ?></td>
							<td>
								<select name="qode_options_infographer[enable_google_map]">
									<option <?php if ($options['enable_google_map'] == "no") { echo "selected='selected'"; } ?> value="no"><?php esc_html_e( 'No', 'infographer-core' ); ?></option>
									<option <?php if ($options['enable_google_map'] == "yes") { echo "selected='selected'"; } ?> value="yes"><?php esc_html_e( 'Yes', 'infographer-core' ); ?></option>
								</select>
							</td>
						</tr>
						<?php if($options['enable_google_map'] == "yes") : ?>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Pin image', 'infographer-core'); ?></td>
							<td>	
								<div class="inline" style="width: 600px;">
								<input type="text" id="google_maps_pin_image" name="qode_options_infographer[google_maps_pin_image]" class="google_maps_pin_image" value="<?php if (isset($options['google_maps_pin_image'])) { echo esc_attr($options['google_maps_pin_image']); } else { echo QODE_ROOT."/img/pin.png"; } ?>" size="70">
								<input class="upload_button" type="button" value="Upload file">
								</div>
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Google map address', 'infographer-core'); ?></td>
							<td>
								<input id="google_maps_address" name="qode_options_infographer[google_maps_address]" value="<?php if (isset($options['google_maps_address'])) { echo esc_attr($options['google_maps_address']); } ?>" size="130" />
							</td>
						</tr>
						<?php endif; ?>
					</tbody>
				</table>
				<?php		display_save_changes_button(); ?>
			</div>
			<h3><?php esc_html_e( '404 page', 'infographer-core' ); ?></h3>
			<div>
				<table class="form-table">
					<tbody>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Title', 'infographer-core'); ?></td>
							<td>
								<input name="qode_options_infographer[404_title]" type="text" value="<?php if ($options['404_title']) { echo esc_attr($options['404_title']); } ?>"  />
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Subtitle', 'infographer-core'); ?></td>
							<td>
								<input name="qode_options_infographer[404_subtitle]" type="text" value="<?php if ($options['404_subtitle']) { echo esc_attr($options['404_subtitle']); } ?>"  />
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Text', 'infographer-core'); ?></td>
							<td>
								<input name="qode_options_infographer[404_text]" type="text" value="<?php if ($options['404_text']) { echo esc_attr($options['404_text']); } ?>"  />
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Back to home label', 'infographer-core'); ?></td>
							<td>
								<input name="qode_options_infographer[404_backlabel]" type="text" value="<?php if ($options['404_backlabel']) { echo esc_attr($options['404_backlabel']); } ?>"  />
							</td>
						</tr>
					</tbody>
				</table>
				<?php		display_save_changes_button(); ?>
			</div>
			<h3><?php esc_html_e( 'Social', 'infographer-core' ); ?></h3>
			<div>
				<table class="form-table">
					<tbody>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Enable Social Share', 'infographer-core'); ?></td>
							<td>
								<select name="qode_options_infographer[enable_social_share]">
									<option <?php if ($options['enable_social_share'] == "no") { echo "selected='selected'"; } ?> value="no"><?php esc_html_e( 'No', 'infographer-core' ); ?></option>
									<option <?php if ($options['enable_social_share'] == "yes") { echo "selected='selected'"; } ?> value="yes"><?php esc_html_e( 'Yes', 'infographer-core' ); ?></option>
								</select>
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Facebook', 'infographer-core'); ?></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Enable Facebook', 'infographer-core'); ?>
									<select name="qode_options_infographer[enable_facebook_share]">
										<option <?php if ($options['enable_facebook_share'] == "no") { echo "selected='selected'"; } ?> value="no"><?php esc_html_e( 'No', 'infographer-core' ); ?></option>
										<option <?php if ($options['enable_facebook_share'] == "yes") { echo "selected='selected'"; } ?> value="yes"><?php esc_html_e( 'Yes', 'infographer-core' ); ?></option>
									</select>
								</div>
								<div class="inline" style="width: 600px;">
									<?php esc_html_e('Share Icon', 'infographer-core'); ?>
									<input type="text" id="facebook_icon" name="qode_options_infographer[facebook_icon]" class="facebook_icon" value="<?php if (isset($options['facebook_icon'])) { echo esc_attr($options['facebook_icon']); } ?>" size="70">
									<input class="upload_button" type="button" value="Upload file">
								</div>
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Twitter', 'infographer-core'); ?></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Enable Twitter', 'infographer-core'); ?>
									<select name="qode_options_infographer[enable_twitter_share]">
										<option <?php if ($options['enable_twitter_share'] == "no") { echo "selected='selected'"; } ?> value="no"><?php esc_html_e( 'No', 'infographer-core' ); ?></option>
										<option <?php if ($options['enable_twitter_share'] == "yes") { echo "selected='selected'"; } ?> value="yes"><?php esc_html_e( 'Yes', 'infographer-core' ); ?></option>
									</select>
								</div>
								<div class="inline" style="width: 600px;">
									<?php esc_html_e('Share Icon', 'infographer-core'); ?>
									<input type="text" id="twitter_icon" name="qode_options_infographer[twitter_icon]" class="twitter_icon" value="<?php if (isset($options['twitter_icon'])) { echo esc_attr($options['twitter_icon']); } ?>" size="70">
									<input class="upload_button" type="button" value="Upload file">
								</div>
								<div class="inline">
									<?php esc_html_e('Via', 'infographer-core'); ?>
									<input name="qode_options_infographer[twitter_via]" type="text" value="<?php if ($options['twitter_via']) { echo esc_attr($options['twitter_via']); } ?>"  />
								</div>
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Google +', 'infographer-core'); ?></td>
							<td>
								<div class="inline">
									<?php esc_html_e('Enable Google +', 'infographer-core'); ?>
									<select name="qode_options_infographer[enable_google_plus]">
										<option <?php if ($options['enable_google_plus'] == "no") { echo "selected='selected'"; } ?> value="no"><?php esc_html_e( 'No', 'infographer-core' ); ?></option>
										<option <?php if ($options['enable_google_plus'] == "yes") { echo "selected='selected'"; } ?> value="yes"><?php esc_html_e( 'Yes', 'infographer-core' ); ?></option>
									</select>
								</div>
								<div class="inline" style="width: 600px;">
									<?php esc_html_e('Share Icon', 'infographer-core'); ?>
									<input type="text" id="google_plus_icon" name="qode_options_infographer[google_plus_icon]" class="google_plus_icon" value="<?php if (isset($options['google_plus_icon'])) { echo esc_attr($options['google_plus_icon']); } ?>" size="70">
									<input class="upload_button" type="button" value="Upload file">
								</div>
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Show For', 'infographer-core'); ?></td>
							<td>
							<?php 
								$post_types = get_post_types(); 
								foreach ($post_types as $post_type ) {
									if($post_type != "attachment" && $post_type != "revision" && $post_type != "nav_menu_item") {
									$post_type_object = get_post_type_object($post_type );
									?>
								 <input type="checkbox" value="<?php echo esc_attr($post_type); ?>" <?php if (isset($options["post_types_names_$post_type"]) && ($options["post_types_names_$post_type"] == "$post_type")){ echo "checked='checked'"; }?> name="qode_options_infographer[post_types_names_<?php echo esc_attr($post_type); ?>]" /><?php echo " " . $post_type_object->labels->singular_name;  ?><br /><br />
								 
								<?php } } ?>
							</td>
						</tr>
					</tbody>
				</table>
				<?php		display_save_changes_button(); ?>
			</div>
		</div>
<?php	}


} // end of qode_Theme_Options Class



function display_save_changes_button() {
	    echo ('
		    <table class="form-table">
			<tbody>
			    <tr valign="middle">
				<th scope="row" width="150">&nbsp;</th>
				<td>
				    <div class="submit" style="padding:10px 0 0 80px; float:right; clear:both;">
					<input type="hidden" id="qode_submit" value="1" name="qode_submit"/>
					<input class="button-primary" type="submit" name="submit" value="'.esc_attr__('Save Changes', 'infographer-core').'" />
				    </div>
				</td>
			    </tr>
			</tbody>
		    </table>');
}




$my_Qode_Theme_Options = new Qode_Theme_Options();


