<?php

if ( ! function_exists( 'infographer_core_header_meta' ) ) {
	/**
	 * Function that echoes meta data if our seo is enabled
	 */
	function infographer_core_header_meta() {
		$global_options = infographer_qode_return_global_options();
		
		if ( isset( $global_options['disable_qode_seo'] ) && $global_options['disable_qode_seo'] == 'no' && ! infographer_core_seo_plugin_installed() ) {
			
			$seo_description = get_post_meta( infographer_qode_get_page_id(), "qode_seo_description", true );
			$seo_keywords    = get_post_meta( infographer_qode_get_page_id(), "qode_seo_keywords", true );
			?>
			
			<?php if ( $seo_description ) { ?>
				<meta name="description" content="<?php echo esc_attr( $seo_description ); ?>">
			<?php } else if ( $global_options['meta_description'] ) { ?>
				<meta name="description" content="<?php echo esc_attr( $global_options['meta_description'] ) ?>">
			<?php } ?>
			
			<?php if ( $seo_keywords ) { ?>
				<meta name="keywords" content="<?php echo esc_attr( $seo_keywords ); ?>">
			<?php } else if ( $global_options['meta_keywords'] ) { ?>
				<meta name="keywords" content="<?php echo esc_attr( $global_options['meta_keywords'] ) ?>">
			<?php }
		}
		
		$favicon = get_option( 'site_icon' );
		if ( empty( $favicon ) && $global_options['favicon_image'] !== '' ) { ?>
			<link rel="shortcut icon" type="image/x-icon" href="<?php echo esc_url( $global_options['favicon_image'] ); ?>">
			<link rel="apple-touch-icon" href="<?php echo esc_url( $global_options['favicon_image'] ); ?>"/>
		<?php }
	}
	
	add_action( 'infographer_qode_action_header_meta', 'infographer_core_header_meta' );
}

if ( ! function_exists( 'infographer_core_ajax_meta' ) ) {
	/**
	 * Function that echoes meta data for ajax
	 *
	 * @since 5.0
	 * @version 0.2
	 */
	function infographer_core_ajax_meta() {
		$global_options = infographer_qode_return_global_options();
		
		if ( isset( $global_options['disable_qode_seo'] ) && $global_options['disable_qode_seo'] == 'no' && ! infographer_core_seo_plugin_installed() ) {
			$seo_description = get_post_meta( infographer_qode_get_page_id(), "qode_seo_description", true );
			$seo_keywords    = get_post_meta( infographer_qode_get_page_id(), "qode_seo_keywords", true );
			?>
			
			<div class="seo_title"><?php wp_title( '' ); ?></div>
			
			<?php if ( $seo_description !== '' ) { ?>
				<div class="seo_description"><?php echo esc_attr( $seo_description ); ?></div>
			<?php } else if ( $global_options['meta_description'] ) { ?>
				<div class="seo_description"><?php echo esc_attr( $global_options['meta_description'] ); ?></div>
			<?php } ?>
			<?php if ( $seo_keywords !== '' ) { ?>
				<div class="seo_keywords"><?php echo esc_attr( $seo_keywords ); ?></div>
			<?php } else if ( $global_options['meta_keywords'] ) { ?>
				<div class="seo_keywords"><?php echo esc_attr( $global_options['meta_keywords'] ); ?></div>
			<?php }
		}
	}

	add_action('qode_ajax_meta', 'infographer_core_ajax_meta');
}

if ( ! function_exists( 'infographer_core_seo_plugin_installed' ) ) {
	/**
	 * Function that checks if popular seo plugins are installed
	 * @return bool
	 */
	function infographer_core_seo_plugin_installed() {
		return defined( 'WPSEO_VERSION' );
	}
}

if ( ! function_exists( 'infographer_core_remove_yoast_json_on_ajax' ) ) {
	/**
	 * Function that removes yoast json ld script
	 * that stops page transition to work on home page
	 * Hooks to wpseo_json_ld_output in order to disable json ld script
	 * @return bool
	 *
	 * @param $data array json ld data that is being passed to filter
	 *
	 * @version 0.2
	 */
	function infographer_core_remove_yoast_json_on_ajax( $data ) {
		global $qode_options_infographer;
		
		//is current request made through ajax?
		if ( isset( $qode_options_infographer['page_transitions'] ) && $qode_options_infographer['page_transitions'] !== 0 ) {
			//disable json ld script
			return array();
		}
		
		return $data;
	}
	
	//is yoast installed and it's version is greater or equal of 1.6?
	if ( infographer_core_seo_plugin_installed() && version_compare( WPSEO_VERSION, '1.6' ) >= 0 ) {
		add_filter( 'wpseo_json_ld_output', 'infographer_core_remove_yoast_json_on_ajax' );
		add_filter( 'disable_wpseo_json_ld_search', 'infographer_core_remove_yoast_json_on_ajax' );
	}
}