<?php
/**
 * Prohibit direct script loading.
 *
 * @package Convert_Plus.
 */

// Add new input type "slider".
if ( function_exists( 'smile_add_input_type' ) ) {
	smile_add_input_type( 'slider', 'cp_slider_settings_field' );
}

add_action( 'admin_enqueue_scripts', 'smile_slider_admin_scripts' );
/**
 * Function Name:smile_slider_admin_scripts description.
 *
 * @param  array $hook ap page list.
 */
function smile_slider_admin_scripts( $hook ) {
	if ( isset( $_REQUEST['cp_admin_page_nonce'] ) && wp_verify_nonce( $_REQUEST['cp_admin_page_nonce'], 'cp_admin_page' ) ) {
		$cp_page = strpos( $hook, CP_PLUS_SLUG );
		$data    = get_option( 'convert_plug_debug' );
		if ( false !== $cp_page ) {
			wp_enqueue_script( 'jquery' );
			wp_enqueue_script( 'jquery-ui-core' );
			wp_enqueue_script( 'jquery-ui-slider' );
			if ( isset( $data['cp-dev-mode'] ) && '1' === $data['cp-dev-mode'] && isset( $_GET['style-view'] ) && ( 'edit' === $_GET['style-view'] || 'variant' === $_GET['style-view'] ) ) {
				wp_enqueue_script( 'convert-plus-slider', SMILE_FRAMEWORK_URI . '/lib/fields/slider/slider.js', array(), '1.0.0', true );
				wp_enqueue_style( 'convert-plus-jquery-ui', SMILE_FRAMEWORK_URI . '/lib/fields/slider/jquery-ui.css', array(), CP_VERSION );
				wp_enqueue_style( 'convert-plus-slider', SMILE_FRAMEWORK_URI . '/lib/fields/slider/slider.css', array(), CP_VERSION );
			}
		}
	}
}

/**
 * Function Name:cp_slider_settings_field Function to handle new input type "slider".
 *
 * @param  string $name     settings provided when using the input type "slider".
 * @param  string $settings holds the default / updated value.
 * @param  string $value    html output generated by the function.
 * @return string           html output generated by the function.
 */
function cp_slider_settings_field( $name, $settings, $value ) {
	$input_name = $name;
	$type       = isset( $settings['type'] ) ? $settings['type'] : '';
	$class      = isset( $settings['class'] ) ? $settings['class'] : '';
	$min        = isset( $settings['min'] ) ? $settings['min'] : '';

	// Apply partials.
	$partials = generate_partial_atts( $settings );

	// If user set value larger than default max value then it will override and set max to user defined value..
	$max = isset( $settings['max'] ) ? $settings['max'] : '';
	if ( $value > $max ) {
		$max = $value;
	}

	$step   = isset( $settings['step'] ) ? $settings['step'] : '';
	$suffix = isset( $settings['suffix'] ) ? $settings['suffix'] : 'px';

	if ( isset( $settings['description'] ) && '' !== $settings['description'] ) {
		$tooltipclass = 'with-tooltip';
	} else {
		$tooltipclass = '';
	}

	$uid     = uniqid();
	$output  = '<div class="setting-block"><div class="row">';
	$output .= '<label class="align-right slider-label ' . $tooltipclass . '" for="' . $input_name . '">' . $suffix . '</label>';

	$output .= '<div class="text-1 slider-input ' . $tooltipclass . '"><input id="smile_' . $input_name . '_' . $uid . '" type="number"  step="' . $step . '" class="form-control smile-input smile-' . $type . ' ' . $input_name . ' ' . $type . ' ' . $class . '" name="' . $input_name . '" value="' . $value . '" data-min="' . $min . '" data-max="' . $max . '" min="' . $min . '" max="' . $max . '" data-step="' . $step . '" ' . $partials . ' ></div></div>';

	$output .= '<div id="slider_' . $input_name . '_' . $uid . '" class="slider-bar large ui-slider ui-slider-horizontal ui-widget ui-widget-content ' . $input_name . ' ' . $type . ' ' . $class . '"><a class="ui-slider-handle ui-state-default" href="#"></a><span class="range-quantity" ></span></div></div>';
	return $output;
}
