<?php
/**
 * Custom pagination handler for an archive query.
 *
 * @package The7
 */

namespace The7\Mods\Compatibility\Elementor\Pro\Modules\Archive;

use ElementorPro\Modules\ThemeBuilder\Module;
use The7\Mods\Compatibility\Elementor\Widgets\Woocommerce\Products;

defined( 'ABSPATH' ) || exit;

/**
 * Custom_Pagination_Query_Handler class.
 */
class Custom_Pagination_Query_Handler {

	/**
	 * Construct and init handler.
	 */
	public function __construct() {
		if ( ! is_admin() ) {
			add_action(
				'pre_get_posts',
				[ $this, 'handle_products_posts_per_page' ],
				11
			);
		}
	}

	/**
	 * Change archive posts_per_page value based on 'the7-wc-products' widget settings.
	 *
	 * @see Products::register_controls()
	 *
	 * @param  \WP_Query $query WP query.
	 */
	public function handle_products_posts_per_page( \WP_Query $query ) {
		if ( ! $query->is_main_query() ) {
			return;
		}

		$is_woocommerce = is_post_type_archive( 'product' ) || is_tax( get_object_taxonomies( 'product' ) );

		if ( ! $is_woocommerce ) {
			return;
		}

		$documents_by_conditions = Module::instance()->get_conditions_manager()->get_documents_for_location( 'archive' );

		foreach ( $documents_by_conditions as $document_id => $document ) {
			$widget = the7_elementor_find_the_first_element_recursive(
				$document->get_elements_raw_data(),
				static function ( $element ) {
					if ( isset( $element['widgetType'], $element['settings'] ) && $element['widgetType'] === 'the7-wc-products' ) {
						if ( isset( $element['settings']['query_post_type'] ) && $element['settings']['query_post_type'] === 'current_query' ) {
							return true;
						}
					}

					return false;
				}
			);

			if ( ! empty( $widget['settings']['archive_posts_per_page'] ) ) {
				$query->set( 'posts_per_page', (int) $widget['settings']['archive_posts_per_page'] );

				return;
			}
		}
	}
}
